/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.UninstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UnitTab
extends JPanel {
    private UnitTable table = null;
    private UnitDetails details = null;
    private UnitCategoryTableModel model = null;
    private DocumentListener dlForSearch;
    private String filter = "";
    private PluginManagerUI manager = null;
    private LocalDownloadSupport localDownloadSupport = null;
    private static final RequestProcessor RP = new RequestProcessor();
    private final RequestProcessor.Task searchTask = RP.create(new Runnable(){

        public void run() {
            if (UnitTab.this.filter != null) {
                UnitTab.this.model.setFilter(UnitTab.this.filter);
            }
        }
    });
    private final Logger log = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitTab");
    private JButton bAddLocallyDownloads;
    private JButton bRefresh;
    private JButton bTabAction;
    private JLabel lHowManyDownload;
    private JLabel lHowManySelected;
    private JLabel lSearch;
    private JLabel lTabActionDescription;
    private JScrollPane spUnitTable;
    private JTextField tfSearch;

    public UnitTab(UnitTable table, UnitDetails details, PluginManagerUI manager) {
        this.table = table;
        this.details = details;
        this.manager = manager;
        TableModel m = table.getModel();
        assert (m instanceof UnitCategoryTableModel) : m + " instanceof UnitCategoryTableModel.";
        this.model = (UnitCategoryTableModel)m;
        table.getSelectionModel().setSelectionMode(0);
        this.initComponents();
        this.spUnitTable.setViewportView(table);
        this.initTab();
        this.listenOnSelection();
    }

    public void addNotify() {
        super.addNotify();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.dlForSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        }
        this.dlForSearch = null;
    }

    public void refreshState() {
        Collection<Unit> units = this.model.getMarkedUnits();
        int downloadSize = this.model.getDownloadSize();
        if (units.size() == 0 || downloadSize == 0) {
            this.cleanHowMany();
        } else {
            this.setHowManyDownload(Utilities.getDownloadSizeAsString(downloadSize));
            this.setHowManySelected(units.size());
        }
        this.bTabAction.setEnabled(units.size() > 0);
    }

    private void initTab() {
        switch (this.model.getType()) {
            case INSTALLED: {
                this.setTabActionDescription("UnitTab_lTabActionDescription_Text_INSTALLED");
                this.setTabActionName("UnitTab_bTabAction_Name_INSTALLED");
                this.bRefresh.setVisible(true);
                this.bAddLocallyDownloads.setVisible(false);
                break;
            }
            case UPDATE: {
                this.setTabActionDescription("UnitTab_lTabActionDescription_Text_UPDATE");
                this.setTabActionName("UnitTab_bTabAction_Name_UPDATE");
                this.bRefresh.setVisible(true);
                this.bAddLocallyDownloads.setVisible(false);
                break;
            }
            case AVAILABLE: {
                this.setTabActionDescription("UnitTab_lTabActionDescription_Text_AVAILABLE");
                this.setTabActionName("UnitTab_bTabAction_Name_AVAILABLE");
                this.bRefresh.setVisible(true);
                this.bAddLocallyDownloads.setVisible(false);
                break;
            }
            case LOCAL: {
                this.setTabActionDescription("UnitTab_lTabActionDescription_Text_LOCAL");
                this.setTabActionName("UnitTab_bTabAction_Name_LOCAL");
                this.bRefresh.setVisible(false);
                this.bAddLocallyDownloads.setVisible(true);
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                UnitTab.this.refreshState();
            }
        });
        this.bTabAction.setEnabled(false);
    }

    private void setTabActionDescription(String key) {
        this.lTabActionDescription.setText(NbBundle.getMessage(UnitTab.class, (String)key));
    }

    private void setTabActionName(String key) {
        Mnemonics.setLocalizedText((AbstractButton)this.bTabAction, (String)NbBundle.getMessage(UnitTab.class, (String)key));
    }

    private void cleanHowMany() {
        this.lHowManyDownload.setText("");
        this.lHowManySelected.setText("");
    }

    private void setHowManyDownload(String size) {
        if (UnitCategoryTableModel.Type.INSTALLED == this.model.getType()) {
            return;
        }
        if (UnitCategoryTableModel.Type.LOCAL == this.model.getType()) {
            return;
        }
        this.lHowManyDownload.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lHowManyDownloaded_Text", (Object)size));
    }

    private void setHowManySelected(int count) {
        String key = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                key = "UnitTab_lHowManySelected_Text_INSTALLED";
                break;
            }
            case UPDATE: {
                key = "UnitTab_lHowManySelected_Text_UPDATE";
                break;
            }
            case AVAILABLE: {
                key = "UnitTab_lHowManySelected_Text_AVAILABLE";
                break;
            }
            case LOCAL: {
                key = "UnitTab_lHowManySelected_Text_LOCAL";
            }
        }
        this.lHowManySelected.setText(NbBundle.getMessage(UnitTab.class, (String)key, (Object)count));
    }

    private void showDetailsAtRow(int row) {
        if (row == -1) {
            this.details.setUnit(null);
        } else {
            Unit u;
            Unit unit = u = this.model.isCategoryAtRow(row) ? null : this.model.getUnitAtRow(row);
            if (u == null) {
                UnitCategory category = this.model.getCategoryAtRow(row);
                this.details.setUnitCategory(category);
            } else {
                this.details.setUnit(u);
            }
        }
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    UnitTab.this.showDetailsAtRow(-1);
                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    UnitTab.this.showDetailsAtRow(selectedRow);
                }
            }
        });
    }

    public void addUpdateUnitListener(UpdateUnitListener l) {
        this.model.addUpdateUnitListener(l);
    }

    public void removeUpdateUnitListener(UpdateUnitListener l) {
        this.model.removeUpdateUnitListener(l);
    }

    void fireUpdataUnitChange() {
        this.model.fireUpdataUnitChange();
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                public void insertUpdate(DocumentEvent arg0) {
                    UnitTab.this.filter = UnitTab.this.tfSearch.getText().trim();
                    UnitTab.this.searchTask.schedule(350);
                }

                public void removeUpdate(DocumentEvent arg0) {
                    this.insertUpdate(arg0);
                }

                public void changedUpdate(DocumentEvent arg0) {
                    this.insertUpdate(arg0);
                }
            };
        }
        return this.dlForSearch;
    }

    private void initComponents() {
        this.lTabActionDescription = new JLabel();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.spUnitTable = new JScrollPane();
        this.bRefresh = new JButton();
        this.lHowManySelected = new JLabel();
        this.lHowManyDownload = new JLabel();
        this.bTabAction = new JButton();
        this.bAddLocallyDownloads = new JButton();
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lSearch_Text"));
        this.tfSearch.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab.tfSearch.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab_bRefresh_Name"));
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitTab.this.bRefreshActionPerformed(evt);
            }
        });
        this.bTabAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitTab.this.bTabActionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bAddLocallyDownloads, (String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab_bAddLocallyDownloads_Name"));
        this.bAddLocallyDownloads.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitTab.this.bAddLocallyDownloadsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lTabActionDescription, -1, 375, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lSearch).addPreferredGap(0)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bAddLocallyDownloads).addPreferredGap(0).add((Component)this.bRefresh).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.lHowManyDownload, -1, -1, Short.MAX_VALUE).add(2, (Component)this.lHowManySelected, -1, -1, Short.MAX_VALUE)).add(32, 32, 32))).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.bTabAction, -2, 113, -2).add((Component)this.tfSearch, -2, 145, -2)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.spUnitTable, -1, 375, Short.MAX_VALUE).add(12, 12, 12)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lSearch).add((Component)this.tfSearch, -2, -1, -2).add((Component)this.lTabActionDescription, -1, 27, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.spUnitTable, -2, 21, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lHowManySelected, -2, 25, -2).add((Component)this.bAddLocallyDownloads).add((Component)this.bRefresh)).add((Component)this.bTabAction)).addPreferredGap(0).add((Component)this.lHowManyDownload, -2, 18, -2).addContainerGap()));
        layout.linkSize(new Component[]{this.lHowManyDownload, this.lHowManySelected}, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bAddLocallyDownloadsActionPerformed(ActionEvent evt) {
        try {
            this.table.setEnabled(false);
            this.bAddLocallyDownloads.setEnabled(false);
            this.bTabAction.setEnabled(false);
            List<UpdateUnit> units = this.getLocalDownloadSupport().getUpdateUnits();
            ArrayList<UnitCategory> categories = new ArrayList<UnitCategory>();
            categories.addAll(Utilities.makeAvailableCategories(units, true));
            categories.addAll(Utilities.makeUpdateCategories(units, true));
            for (UnitCategory c : categories) {
                for (Unit u : c.getUnits()) {
                    if (u.isMarked()) continue;
                    u.setMarked(true);
                }
            }
            this.model.setData(categories);
            this.fireUpdataUnitChange();
        }
        catch (Throwable throwable) {
            this.table.setEnabled(true);
            this.bAddLocallyDownloads.setEnabled(true);
            this.bTabAction.setEnabled(this.model.getMarkedUnits().size() > 0);
            this.fireUpdataUnitChange();
            throw throwable;
        }
        this.table.setEnabled(true);
        this.bAddLocallyDownloads.setEnabled(true);
        this.bTabAction.setEnabled(this.model.getMarkedUnits().size() > 0);
        this.fireUpdataUnitChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bTabActionActionPerformed(ActionEvent evt) {
        if (UnitCategoryTableModel.Type.UPDATE == this.model.getType()) {
            OperationContainer<InstallSupport> cont = Containers.forUpdate();
            try {
                this.table.setEnabled(false);
                this.bRefresh.setEnabled(false);
                this.bTabAction.setEnabled(false);
                new InstallUnitWizard().invokeWizard(cont);
            }
            finally {
                this.table.setEnabled(true);
                this.bRefresh.setEnabled(true);
                this.bTabAction.setEnabled(true);
                cont.removeAll();
                this.fireUpdataUnitChange();
            }
        }
        if (UnitCategoryTableModel.Type.AVAILABLE == this.model.getType()) {
            OperationContainer<InstallSupport> cont = Containers.forAvailable();
            try {
                this.table.setEnabled(false);
                this.bRefresh.setEnabled(false);
                this.bTabAction.setEnabled(false);
                new InstallUnitWizard().invokeWizard(cont);
            }
            finally {
                this.table.setEnabled(true);
                this.bRefresh.setEnabled(true);
                this.bTabAction.setEnabled(true);
                cont.removeAll();
                this.fireUpdataUnitChange();
            }
        }
        if (UnitCategoryTableModel.Type.INSTALLED == this.model.getType()) {
            UninstallUnitWizard wizard = new UninstallUnitWizard();
            try {
                this.table.setEnabled(false);
                this.bRefresh.setEnabled(false);
                this.bTabAction.setEnabled(false);
                wizard.invokeWizard();
            }
            finally {
                this.table.setEnabled(true);
                this.bRefresh.setEnabled(true);
                this.bTabAction.setEnabled(true);
                Containers.forUninstall().removeAll();
                this.fireUpdataUnitChange();
            }
        }
        if (UnitCategoryTableModel.Type.LOCAL == this.model.getType()) {
            int available = Containers.forAvailableNbms().listAll().size();
            int updates = Containers.forUpdateNbms().listAll().size();
            OperationContainer<InstallSupport> cont = updates > available ? Containers.forUpdateNbms() : Containers.forAvailableNbms();
            try {
                new InstallUnitWizard().invokeWizard(cont);
                Object var7_11 = null;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                cont.removeAll();
                List<UnitCategory> categories = this.model.data;
                Iterator<UnitCategory> categoryIt = categories.iterator();
                while (categoryIt.hasNext()) {
                    UnitCategory unitCategory = categoryIt.next();
                    List<Unit> units = unitCategory.getUnits();
                    Iterator<Unit> it = units.iterator();
                    while (it.hasNext()) {
                        Unit unit = it.next();
                        if (unit.updateUnit.getInstalled() == null) continue;
                        it.remove();
                    }
                    if (units.size() != 0) continue;
                    categoryIt.remove();
                }
                this.model.setData(categories);
                this.refresh(false);
                throw throwable;
            }
            cont.removeAll();
            List<UnitCategory> categories = this.model.data;
            Iterator<UnitCategory> categoryIt = categories.iterator();
            while (categoryIt.hasNext()) {
                UnitCategory unitCategory = categoryIt.next();
                List<Unit> units = unitCategory.getUnits();
                Iterator<Unit> it = units.iterator();
                while (it.hasNext()) {
                    Unit unit = it.next();
                    if (unit.updateUnit.getInstalled() == null) continue;
                    it.remove();
                }
                if (units.size() != 0) continue;
                categoryIt.remove();
            }
            this.model.setData(categories);
            this.refresh(false);
            {
            }
        }
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.refresh(true);
    }

    private LocalDownloadSupport getLocalDownloadSupport() {
        if (this.localDownloadSupport == null) {
            this.localDownloadSupport = new LocalDownloadSupport();
        }
        return this.localDownloadSupport;
    }

    private void refresh(final boolean force) {
        this.table.setEnabled(false);
        this.bRefresh.setEnabled(false);
        this.bTabAction.setEnabled(false);
        Runnable checkUpdates = new Runnable(){

            public void run() {
                Utilities.presentRefreshProviders(UnitTab.this.manager, force);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UnitTab.this.fireUpdataUnitChange();
                        UnitTab.this.table.setEnabled(true);
                        UnitTab.this.bRefresh.setEnabled(true);
                        UnitTab.this.bTabAction.setEnabled(UnitTab.this.model.getMarkedUnits().size() > 0);
                    }
                });
            }
        };
        NetworkProblemPanel.setPerformAgain(checkUpdates);
        RequestProcessor.getDefault().post(checkUpdates);
    }
}

