/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.SettingsTab;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateUnitProviderPanel
extends JPanel {
    private DocumentListener listener;
    private FocusListener focusNameListener;
    private FocusListener focusUrlListener;
    private JButton bOK = new JButton(NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel_OK"));
    private Set<String> namesOfProviders = null;
    private boolean isEdit;
    private String originalName;
    private JCheckBox cbActive;
    private JLabel lName;
    private JLabel lURL;
    private JTextField tfName;
    private JTextField tfURL;

    public UpdateUnitProviderPanel(boolean isActive, String name, String url, boolean editing) {
        this.isEdit = editing;
        this.originalName = name;
        this.initComponents();
        this.addListeners();
        this.tfURL.setText(url);
        this.tfName.setText(name);
        this.cbActive.setSelected(isActive);
    }

    JButton getOKButton() {
        return this.bOK;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    private void addListeners() {
        if (this.listener == null) {
            this.listener = new DocumentListener(){

                public void insertUpdate(DocumentEvent arg0) {
                    this.update();
                }

                public void removeUpdate(DocumentEvent arg0) {
                    this.update();
                }

                public void changedUpdate(DocumentEvent arg0) {
                    this.update();
                }

                private void update() {
                    UpdateUnitProviderPanel.this.bOK.setEnabled(this.isValid());
                }

                private boolean isValid() {
                    boolean isOk;
                    boolean bl = isOk = UpdateUnitProviderPanel.this.getProviderName().length() > 0 && UpdateUnitProviderPanel.this.getProviderURL().length() > 0;
                    if (isOk) {
                        boolean bl2 = isOk = UpdateUnitProviderPanel.this.isEdit && UpdateUnitProviderPanel.this.getProviderName().equals(UpdateUnitProviderPanel.this.originalName) || !UpdateUnitProviderPanel.this.getNamesOfProviders().contains(UpdateUnitProviderPanel.this.getProviderName());
                    }
                    if (isOk) {
                        String s = UpdateUnitProviderPanel.this.getProviderURL();
                        try {
                            new URI(s).toURL();
                        }
                        catch (MalformedURLException x) {
                            isOk = false;
                        }
                        catch (URISyntaxException x) {
                            isOk = false;
                        }
                        catch (IllegalArgumentException x) {
                            isOk = false;
                        }
                    }
                    return isOk;
                }
            };
            this.focusNameListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    UpdateUnitProviderPanel.this.tfName.selectAll();
                }

                public void focusLost(FocusEvent e) {
                    UpdateUnitProviderPanel.this.tfName.select(0, 0);
                }
            };
            this.tfName.addFocusListener(this.focusNameListener);
            this.focusUrlListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    UpdateUnitProviderPanel.this.tfURL.selectAll();
                }

                public void focusLost(FocusEvent e) {
                    UpdateUnitProviderPanel.this.tfURL.select(0, 0);
                }
            };
            this.tfURL.addFocusListener(this.focusUrlListener);
            this.tfName.getDocument().addDocumentListener(this.listener);
            this.tfURL.getDocument().addDocumentListener(this.listener);
        }
    }

    private Set<String> getNamesOfProviders() {
        if (this.namesOfProviders == null) {
            this.namesOfProviders = new HashSet<String>();
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
                this.namesOfProviders.add(p.getDisplayName());
            }
        }
        return this.namesOfProviders;
    }

    private void removeListener() {
        if (this.listener != null) {
            this.tfName.getDocument().removeDocumentListener(this.listener);
            this.tfURL.getDocument().removeDocumentListener(this.listener);
            this.tfName.removeFocusListener(this.focusNameListener);
            this.tfURL.removeFocusListener(this.focusUrlListener);
            this.listener = null;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SettingsTab.class, (String)"UpdateUnitProviderPanel_displayName");
    }

    public boolean isActive() {
        return this.cbActive.isSelected();
    }

    public String getProviderName() {
        return this.tfName.getText().trim();
    }

    public String getProviderURL() {
        return this.tfURL.getText().trim();
    }

    private void initComponents() {
        this.lName = new JLabel();
        this.tfName = new JTextField();
        this.lURL = new JLabel();
        this.tfURL = new JTextField();
        this.cbActive = new JCheckBox();
        this.lName.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel.lName.text"));
        this.lURL.setLabelFor(this.tfURL);
        Mnemonics.setLocalizedText((JLabel)this.lURL, (String)NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel.lURL.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActive, (String)NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel.cbActive.text"));
        this.cbActive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lName).add((Component)this.lURL)).add(15, 15, 15).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tfURL, -1, 474, Short.MAX_VALUE).add((Component)this.tfName, -1, 474, Short.MAX_VALUE).add((Component)this.cbActive)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lName).add((Component)this.tfName, -2, -1, -2)).addPreferredGap(0).add((Component)this.cbActive).add(24, 24, 24).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lURL).add((Component)this.tfURL, -2, -1, -2)).addContainerGap(21, Short.MAX_VALUE)));
        this.lName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel.lName.adesc"));
        this.lURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel.lURL.adesc"));
        this.cbActive.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateUnitProviderPanel.class, (String)"UpdateUnitProviderPanel.cbActive.adesc"));
    }
}

