/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallPanel
extends JPanel {
    static final String RUN_ACTION = "run-action";
    private ButtonGroup bgRestartButtons;
    private JLabel lDetailLabel;
    private JLabel lMainLabel;
    private JPanel pAboveSpace;
    private JPanel pProgress;
    private JProgressBar pbPlaceHolder;
    private JRadioButton rbRestartLater;
    private JRadioButton rbRestartNow;

    public InstallPanel() {
        this.initComponents();
        this.rbRestartNow.setSelected(true);
        this.setRestartButtonsVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                InstallPanel.this.firePropertyChange(InstallPanel.RUN_ACTION, null, Boolean.TRUE);
            }
        }, 200);
    }

    public void waitAndSetProgressComponents(final JLabel mainLabel, final JComponent progressComponent, final JLabel detailLabel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponents(mainLabel, progressComponent, detailLabel);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InstallPanel.this.setProgressComponents(mainLabel, progressComponent, detailLabel);
                }
            });
        }
    }

    public void setRestartButtonsVisible(boolean visible) {
        this.rbRestartLater.setVisible(visible);
        this.rbRestartNow.setVisible(visible);
    }

    public boolean restartNow() {
        return this.rbRestartNow.isSelected();
    }

    private void setProgressComponents(JLabel mainLabel, JComponent progressComponent, JLabel detailLabel) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        mainLabel.setPreferredSize(new Dimension(0, 20));
        detailLabel.setPreferredSize(new Dimension(0, 20));
        progressComponent.setPreferredSize(new Dimension(0, 20));
        this.pProgress.removeAll();
        this.pProgress.add((Component)mainLabel, "North");
        this.pProgress.add((Component)progressComponent, "Center");
        this.pProgress.add((Component)detailLabel, "South");
        this.revalidate();
    }

    public void setBody(final String msg, Set<UpdateElement> updateElements) {
        final ArrayList<UpdateElement> elements = new ArrayList<UpdateElement>(updateElements);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBodyInEQ(msg, elements);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InstallPanel.this.setBodyInEQ(msg, elements);
                }
            });
        }
    }

    private void setBodyInEQ(String msg, List<UpdateElement> elements) {
        this.pProgress.removeAll();
        this.pProgress.add((Component)this.getTitleComponent(msg), "North");
        this.pProgress.add((Component)this.getElementsComponent(elements), "Center");
        this.revalidate();
    }

    private JComponent getTitleComponent(String msg) {
        JTextArea area = new JTextArea(msg);
        area.setWrapStyleWord(true);
        area.setLineWrap(true);
        area.setEditable(false);
        area.setBackground(new JLabel().getBackground());
        return area;
    }

    private JComponent getElementsComponent(List<UpdateElement> elements) {
        JTextPane area = new JTextPane();
        area.setEditable(false);
        area.setContentType("text/html");
        String body = new String();
        for (UpdateElement el : elements) {
            body = body + el.getDisplayName() + "<br>";
        }
        area.setText(body);
        area.setBackground(new JLabel().getBackground());
        return area;
    }

    private void initComponents() {
        this.bgRestartButtons = new ButtonGroup();
        this.pAboveSpace = new JPanel();
        this.pProgress = new JPanel();
        this.pbPlaceHolder = new JProgressBar();
        this.lMainLabel = new JLabel();
        this.lDetailLabel = new JLabel();
        this.rbRestartNow = new JRadioButton();
        this.rbRestartLater = new JRadioButton();
        GroupLayout pAboveSpaceLayout = new GroupLayout((Container)this.pAboveSpace);
        this.pAboveSpace.setLayout((LayoutManager)pAboveSpaceLayout);
        pAboveSpaceLayout.setHorizontalGroup((GroupLayout.Group)pAboveSpaceLayout.createParallelGroup(1).add(0, 148, Short.MAX_VALUE));
        pAboveSpaceLayout.setVerticalGroup((GroupLayout.Group)pAboveSpaceLayout.createParallelGroup(1).add(0, 65, Short.MAX_VALUE));
        this.pProgress.setLayout(new BorderLayout());
        this.pbPlaceHolder.setPreferredSize(new Dimension(0, 20));
        this.pProgress.add((Component)this.pbPlaceHolder, "Center");
        this.pProgress.add((Component)this.lMainLabel, "North");
        this.pProgress.add((Component)this.lDetailLabel, "South");
        this.bgRestartButtons.add(this.rbRestartNow);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRestartNow, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallUnitWizardModel_Buttons_RestartNow"));
        this.rbRestartNow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRestartNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallPanel.this.rbRestartNowActionPerformed(evt);
            }
        });
        this.bgRestartButtons.add(this.rbRestartLater);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRestartLater, (String)NbBundle.getMessage(InstallPanel.class, (String)"InstallUnitWizardModel_Buttons_RestartLater"));
        this.rbRestartLater.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRestartLater.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallPanel.this.rbRestartLaterActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.pProgress, -1, 148, Short.MAX_VALUE).add((Component)this.pAboveSpace, -1, -1, Short.MAX_VALUE).add((Component)this.rbRestartNow).add((Component)this.rbRestartLater)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pAboveSpace, -2, -1, -2).addPreferredGap(0).add((Component)this.pProgress, -2, -1, -2).add(28, 28, 28).add((Component)this.rbRestartNow).addPreferredGap(0).add((Component)this.rbRestartLater).addContainerGap(51, Short.MAX_VALUE)));
    }

    private void rbRestartLaterActionPerformed(ActionEvent evt) {
    }

    private void rbRestartNowActionPerformed(ActionEvent evt) {
    }
}

