/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.wizards.InstallPanel;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.ValidationWarningPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private InstallPanel panel;
    private PanelBodyContainer component;
    private InstallUnitWizardModel model = null;
    private WizardDescriptor wd = null;
    private InstallSupport.Restarter restarter = null;
    private final Logger log = Logger.getLogger("org.netbeans.modules.autoupdate.ui.wizards.InstallPanel");
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_DOWNLOAD = "InstallStep_Header_Download_Head";
    private static final String CONTENT_DOWNLOAD = "InstallStep_Header_Download_Content";
    private static final String HEAD_VERIFY = "InstallStep_Header_Verify_Head";
    private static final String CONTENT_VERIFY = "InstallStep_Header_Verify_Content";
    private static final String HEAD_INSTALL = "InstallStep_Header_Install_Head";
    private static final String CONTENT_INSTALL = "InstallStep_Header_Install_Content";
    private static final String HEAD_INSTALL_DONE = "InstallStep_Header_InstallDone_Head";
    private static final String CONTENT_INSTALL_DONE = "InstallStep_Header_InstallDone_Content";
    private static final String HEAD_RESTART = "InstallStep_Header_Restart_Head";
    private static final String CONTENT_RESTART = "InstallStep_Header_Restart_Content";
    private InstallSupport.Validator validator;

    public InstallStep(InstallUnitWizardModel model) {
        this.model = model;
    }

    public boolean isFinishPanel() {
        return false;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new InstallPanel();
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("run-action".equals(evt.getPropertyName())) {
                        InstallStep.this.doDownloadAndVerificationAndInstall();
                    }
                }
            });
            this.component = new PanelBodyContainer(this.getBundle(HEAD_DOWNLOAD), this.getBundle(CONTENT_DOWNLOAD), this.panel);
        }
        return this.component;
    }

    private void doDownloadAndVerificationAndInstall() {
        InstallSupport.Validator v = null;
        v = this.handleDownload();
        if (v != null) {
            InstallSupport.Installer i = null;
            i = this.handleValidation(v);
            if (i != null) {
                InstallSupport.Restarter r = null;
                r = this.handleInstall(i);
                if (r != null) {
                    this.presentInstallNeedsRestart(r);
                } else {
                    this.presentInstallDone();
                }
            }
        }
        this.fireChange();
    }

    private InstallSupport.Validator handleDownload() {
        this.validator = null;
        final InstallSupport support = this.model.getSupport();
        assert (support != null);
        Runnable performDownload = new Runnable(){

            public void run() {
                try {
                    ProgressHandle handle = ProgressHandleFactory.createHandle((String)InstallStep.this.getBundle("InstallStep_Download_DownloadingPlugins"));
                    JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
                    JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
                    JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
                    handle.setInitialDelay(0);
                    InstallStep.this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
                    InstallStep.this.validator = support.doDownload(handle);
                    if (InstallStep.this.validator == null) {
                        return;
                    }
                    InstallStep.this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(InstallStep.this.getBundle("InstallStep_Done")));
                }
                catch (OperationException ex) {
                    assert (OperationException.ERROR_TYPE.PROXY.equals((Object)ex.getErrorType()));
                    InstallStep.this.log.log(Level.INFO, ex.getMessage(), ex);
                    NetworkProblemPanel.showNetworkProblemDialog(InstallStep.this.model.getCancelButton(InstallStep.this.wd), ex);
                }
            }
        };
        NetworkProblemPanel.setPerformAgain(performDownload);
        performDownload.run();
        return this.validator;
    }

    private InstallSupport.Installer handleValidation(InstallSupport.Validator v) {
        this.component.setHeadAndContent(this.getBundle(HEAD_VERIFY), this.getBundle(CONTENT_VERIFY));
        final InstallSupport support = this.model.getSupport();
        assert (support != null);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Validate_ValidatingPlugins"));
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        handle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        InstallSupport.Installer tmpInst = null;
        try {
            tmpInst = support.doValidate(v, handle);
            if (tmpInst == null) {
                return null;
            }
        }
        catch (OperationException ex) {
            this.log.log(Level.INFO, ex.getMessage(), ex);
        }
        final InstallSupport.Installer inst = tmpInst;
        ArrayList<UpdateElement> unsigned = new ArrayList<UpdateElement>();
        ArrayList<UpdateElement> untrusted = new ArrayList<UpdateElement>();
        UpdateElement sEl = null;
        for (UpdateElement el : this.model.getAllUpdateElements()) {
            if (!support.isSigned(inst, el)) {
                unsigned.add(el);
                if (sEl != null) continue;
                sEl = el;
                continue;
            }
            if (support.isTrusted(inst, el)) continue;
            untrusted.add(el);
            if (sEl != null) continue;
            sEl = el;
        }
        final UpdateElement strangeElement = sEl;
        if (untrusted.size() > 0 || unsigned.size() > 0) {
            ValidationWarningPanel p = new ValidationWarningPanel(unsigned, untrusted);
            final JButton showCertificate = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)showCertificate, (String)this.getBundle("ValidationWarningPanel_ShowCertificateButton"));
            showCertificate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (showCertificate.equals(e.getSource())) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)support.getCertificate(inst, strangeElement)));
                    }
                }
            });
            JButton canContinue = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)canContinue, (String)this.getBundle("ValidationWarningPanel_ContinueButton"));
            JButton cancel = this.model.getCancelButton(this.wd);
            DialogDescriptor dd = new DialogDescriptor((Object)p, this.getBundle("ValidationWarningPanel_Title"));
            dd.setOptions((Object[])new JButton[]{canContinue, cancel});
            dd.setClosingOptions((Object[])new JButton[]{canContinue, cancel});
            dd.setOptionType(2);
            if (!untrusted.isEmpty()) {
                dd.setAdditionalOptions((Object[])new JButton[]{showCertificate});
            }
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (!canContinue.equals(dd.getValue())) {
                if (!cancel.equals(dd.getValue())) {
                    cancel.doClick();
                }
                return null;
            }
            assert (canContinue.equals(dd.getValue()));
        }
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(this.getBundle("InstallStep_Done")));
        return inst;
    }

    private InstallSupport.Restarter handleInstall(InstallSupport.Installer i) {
        this.component.setHeadAndContent(this.getBundle(HEAD_INSTALL), this.getBundle(CONTENT_INSTALL));
        InstallSupport support = this.model.getSupport();
        assert (support != null);
        this.model.modifyOptionsForDisabledCancel(this.wd);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Install_InstallingPlugins"));
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        handle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        InstallSupport.Restarter r = null;
        try {
            r = support.doInstall(i, handle);
        }
        catch (OperationException ex) {
            this.log.log(Level.INFO, ex.getMessage(), ex);
        }
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(this.getBundle("InstallStep_Done")));
        return r;
    }

    private void presentInstallDone() {
        this.component.setHeadAndContent(this.getBundle(HEAD_INSTALL_DONE), this.getBundle(CONTENT_INSTALL_DONE));
        this.model.modifyOptionsForDoClose(this.wd);
        this.panel.setBody(this.getBundle("InstallStep_InstallDone_Text"), this.model.getAllUpdateElements());
    }

    private void presentInstallNeedsRestart(InstallSupport.Restarter r) {
        this.component.setHeadAndContent(this.getBundle(HEAD_RESTART), this.getBundle(CONTENT_RESTART));
        this.model.modifyOptionsForDoClose(this.wd);
        this.restarter = r;
        this.panel.setRestartButtonsVisible(true);
        this.panel.setBody(this.getBundle("InstallStep_InstallDone_Text"), this.model.getAllUpdateElements());
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
    }

    public void storeSettings(WizardDescriptor wd) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wd.getValue())) : "Cannot invoke Back in this case.";
        if (this.restarter != null) {
            InstallSupport support = this.model.getSupport();
            assert (support != null);
            if (this.panel.restartNow()) {
                try {
                    support.doRestart(this.restarter, null);
                }
                catch (OperationException x) {
                    this.log.log(Level.INFO, x.getMessage(), x);
                }
            } else {
                support.doRestartLater(this.restarter);
                return;
            }
        }
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            try {
                this.model.doCleanup();
            }
            catch (OperationException x) {
                this.log.log(Level.INFO, x.getMessage(), x);
            }
        }
    }

    public boolean isValid() {
        return false;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        InstallStep installStep = this;
        synchronized (installStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(InstallStep.class, (String)key);
    }
}

