/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionStep;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstallUnitWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor> {
    private int index;
    private List<WizardDescriptor.Panel> panels = new ArrayList<WizardDescriptor.Panel>();
    private InstallUnitWizardModel installModel;

    public InstallUnitWizardIterator(InstallUnitWizardModel model) {
        this.installModel = model;
        this.createPanels();
        this.index = 0;
    }

    public InstallUnitWizardModel getModel() {
        assert (this.installModel != null);
        return this.installModel;
    }

    private void createPanels() {
        assert (this.panels != null && this.panels.isEmpty()) : "Panels are still empty";
        this.panels.add(new OperationDescriptionStep(this.installModel));
        if (!this.installModel.allLicensesApproved()) {
            this.panels.add((WizardDescriptor.Panel)new LicenseApprovalStep(this.installModel));
        }
        this.panels.add((WizardDescriptor.Panel)new InstallStep(this.installModel));
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return this.panels.get(this.index);
    }

    public String name() {
        return NbBundle.getMessage(InstallUnitWizardIterator.class, (String)"InstallUnitWizard_Title");
    }

    public boolean hasNext() {
        return this.index < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0 && !(this.current() instanceof InstallStep);
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

