/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseApprovalPanel
extends JPanel {
    public static final String LICENSE_APPROVED = "license-approved";
    private String[] licenses;
    private ButtonGroup bgApproveButtons;
    private JComboBox cbLicenseFor;
    private JLabel lLicenseFor;
    private JRadioButton rbAccept;
    private JRadioButton rbDismis;
    private JScrollPane spLicense;
    private JTextArea taTitle;
    private JTextPane tpLicense;

    public LicenseApprovalPanel(InstallUnitWizardModel model) {
        this.initComponents();
        this.postInitComponents(model);
    }

    List<String> getLicenses() {
        assert (this.licenses != null) : "Licenses must found.";
        if (this.licenses == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.licenses);
    }

    private void postInitComponents(InstallUnitWizardModel model) {
        Color labelBackground = UIManager.getColor("Label.background");
        labelBackground = labelBackground == null ? new Color(new JLabel().getBackground().getRGB()) : new Color(labelBackground.getRGB());
        this.taTitle.setBackground(labelBackground);
        Color textAreaBackground = UIManager.getColor("TextArea.background");
        textAreaBackground = textAreaBackground == null ? new Color(new JTextArea().getBackground().getRGB()) : new Color(textAreaBackground.getRGB());
        this.tpLicense.setBackground(textAreaBackground);
        this.rbDismis.setSelected(true);
        this.cbLicenseFor.setModel(new DefaultComboBoxModel<String>(this.getItems(model)));
        this.cbLicenseFor.setSelectedIndex(0);
        this.cbLicenseForItemStateChanged(null);
    }

    private String[] getItems(InstallUnitWizardModel model) {
        Set<UpdateElement> all = model.getAllUpdateElements();
        String[] items = new String[all.size()];
        this.licenses = new String[items.length];
        int i = 0;
        for (UpdateElement el : all) {
            items[i] = el.getDisplayName();
            this.licenses[i] = el.getLicence();
            ++i;
        }
        assert (i == all.size());
        return items;
    }

    public boolean isApproved() {
        return this.rbAccept.isSelected();
    }

    private void initComponents() {
        this.bgApproveButtons = new ButtonGroup();
        this.taTitle = new JTextArea();
        this.lLicenseFor = new JLabel();
        this.cbLicenseFor = new JComboBox();
        this.rbAccept = new JRadioButton();
        this.rbDismis = new JRadioButton();
        this.spLicense = new JScrollPane();
        this.tpLicense = new JTextPane();
        this.taTitle.setEditable(false);
        this.taTitle.setLineWrap(true);
        this.taTitle.setText(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taTitle_Text"));
        this.taTitle.setWrapStyleWord(true);
        this.lLicenseFor.setLabelFor(this.cbLicenseFor);
        Mnemonics.setLocalizedText((JLabel)this.lLicenseFor, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_lLicenseFor_Text"));
        this.cbLicenseFor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LicenseApprovalPanel.this.cbLicenseForItemStateChanged(evt);
            }
        });
        this.bgApproveButtons.add(this.rbAccept);
        Mnemonics.setLocalizedText((AbstractButton)this.rbAccept, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_rbAccept_Text"));
        this.rbAccept.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbAccept.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LicenseApprovalPanel.this.rbAcceptActionPerformed(evt);
            }
        });
        this.bgApproveButtons.add(this.rbDismis);
        Mnemonics.setLocalizedText((AbstractButton)this.rbDismis, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_rbDismis_Text"));
        this.rbDismis.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbDismis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LicenseApprovalPanel.this.rbDismisActionPerformed(evt);
            }
        });
        this.tpLicense.setContentType("text/html");
        this.tpLicense.setEditable(false);
        this.spLicense.setViewportView(this.tpLicense);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.spLicense, -1, 524, Short.MAX_VALUE).add(1, (Component)this.rbAccept, -1, 524, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lLicenseFor).addPreferredGap(0).add((Component)this.cbLicenseFor, -2, 247, -2)).add(1, (Component)this.taTitle, -1, 524, Short.MAX_VALUE).add((Component)this.rbDismis, -1, 524, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.taTitle, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lLicenseFor).add((Component)this.cbLicenseFor, -2, -1, -2)).add(11, 11, 11).add((Component)this.spLicense, -1, 282, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.rbAccept).addPreferredGap(0).add((Component)this.rbDismis).addContainerGap()));
    }

    private void rbDismisActionPerformed(ActionEvent evt) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.rbAccept.isSelected());
    }

    private void rbAcceptActionPerformed(ActionEvent evt) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.rbAccept.isSelected());
    }

    private void cbLicenseForItemStateChanged(ItemEvent evt) {
        if (this.licenses != null) {
            this.writeLicense((String)this.cbLicenseFor.getSelectedItem(), this.licenses[this.cbLicenseFor.getSelectedIndex()]);
        }
    }

    private void writeLicense(String plugin, String license) {
        license = license.replaceAll("\\n", "<br>");
        this.tpLicense.setText("<h1>" + NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Head", (Object)plugin) + "</h1>" + license);
        this.tpLicense.setCaretPosition(0);
    }
}

