/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationDescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private static final String HEAD = "OperationDescriptionStep_Header_Head";
    private static final String CONTENT = "OperationDescriptionStep_Header_Content";
    private static final String TABLE_TITLE_INSTALL = "OperationDescriptionStep_TableInstall_Title";
    private static final String TABLE_TITLE_UPDATE = "OperationDescriptionStep_TableUpdate_Title";
    private static final String HEAD_UNINSTALL = "OperationDescriptionStep_HeaderUninstall_Head";
    private static final String CONTENT_UNINSTALL = "OperationDescriptionStep_HeaderUninstall_Content";
    private static final String TABLE_TITLE_UNINSTALL = "OperationDescriptionStep_TableUninstall_Title";
    private static final String HEAD_ACTIVATE = "OperationDescriptionStep_HeaderActivate_Head";
    private static final String CONTENT_ACTIVATE = "OperationDescriptionStep_HeaderActivate_Content";
    private static final String TABLE_TITLE_ACTIVATE = "OperationDescriptionStepActivate_Table_Title";
    private static final String HEAD_DEACTIVATE = "OperationDescriptionStep_HeaderDeativate_Head";
    private static final String CONTENT_DEACTIVATE = "OperationDescriptionStep_HeaderDeativate_Content";
    private static final String TABLE_TITLE_DEACTIVATE = "OperationDescriptionStep_TableDeativate_Title";
    private static final String DEPENDENCIES_TITLE_INSTALL = "DependenciesResolutionStep_Table_Title";
    private static final String DEPENDENCIES_TITLE_UPDATE = "DependenciesResolutionStep_Table_Title";
    private static final String DEPENDENCIES_TITLE_UNINSTALL = "UninstallDependenciesResolutionStep_Table_Title";
    private static final String DEPENDENCIES_TITLE_ACTIVATE = "OperationDescriptionStep_TableInstall_Title";
    private static final String DEPENDENCIES_TITLE_DEACTIVATE = "UninstallDependenciesResolutionStep_Table_Title";
    private static final String TABLE_TITLE_BROKEN = "OperationDescriptionStep_BrokenDependencies_Title";
    private static final String TITLE_BROKEN_DEPENDENCIES = "OperationDescriptionStep_BrokenDependencies";
    private PanelBodyContainer component;
    private OperationWizardModel model = null;

    public OperationDescriptionStep(OperationWizardModel model) {
        this.model = model;
    }

    public Component getComponent() {
        if (this.component == null) {
            String tableTitle = null;
            String dependenciesTitle = null;
            String head = null;
            String content = null;
            switch (this.model.getOperation()) {
                case INSTALL: {
                    tableTitle = this.getBundle("OperationDescriptionStep_TableInstall_Title");
                    dependenciesTitle = this.getBundle("DependenciesResolutionStep_Table_Title");
                    head = this.getBundle(HEAD);
                    content = this.getBundle(CONTENT);
                    break;
                }
                case UPDATE: {
                    tableTitle = this.getBundle(TABLE_TITLE_UPDATE);
                    dependenciesTitle = this.getBundle("DependenciesResolutionStep_Table_Title");
                    head = this.getBundle(HEAD);
                    content = this.getBundle(CONTENT);
                    break;
                }
                case UNINSTALL: {
                    tableTitle = this.getBundle(TABLE_TITLE_UNINSTALL);
                    dependenciesTitle = this.getBundle("UninstallDependenciesResolutionStep_Table_Title");
                    head = this.getBundle(HEAD_UNINSTALL);
                    content = this.getBundle(CONTENT_UNINSTALL);
                    break;
                }
                case ENABLE: {
                    tableTitle = this.getBundle(TABLE_TITLE_ACTIVATE);
                    dependenciesTitle = this.getBundle("OperationDescriptionStep_TableInstall_Title");
                    head = this.getBundle(HEAD_ACTIVATE);
                    content = this.getBundle(CONTENT_ACTIVATE);
                    break;
                }
                case DISABLE: {
                    tableTitle = this.getBundle(TABLE_TITLE_DEACTIVATE);
                    dependenciesTitle = this.getBundle("UninstallDependenciesResolutionStep_Table_Title");
                    head = this.getBundle(HEAD_DEACTIVATE);
                    content = this.getBundle(CONTENT_DEACTIVATE);
                }
            }
            if (this.model.hasBrokenDependencies()) {
                OperationDescriptionPanel body = new OperationDescriptionPanel("", "", this.prepareBrokenDependenciesForShow(this.model), "", true);
                this.component = new PanelBodyContainer(head, "", body);
            } else {
                OperationDescriptionPanel body = new OperationDescriptionPanel(tableTitle, this.preparePluginsForShow(this.model.getPrimaryUpdateElements()), dependenciesTitle, this.preparePluginsForShow(this.model.getRequiredUpdateElements()), this.model.hasRequiredUpdateElements());
                this.component = new PanelBodyContainer(head, content, body);
            }
        }
        return this.component;
    }

    private String prepareBrokenDependenciesForShow(OperationWizardModel model) {
        String s = new String();
        for (String plugin : model.getBrokenDependencies().keySet()) {
            s = s + "<h3>" + NbBundle.getMessage(OperationDescriptionStep.class, (String)"OperationDescriptionStep_PluginHasBrokenDependencies", (Object)plugin) + "</h3>";
            TreeSet sset = new TreeSet((Collection)model.getBrokenDependencies().get(plugin));
            for (String dep : sset) {
                s = s + "      " + this.tryTakeDisplayName(dep) + "<br>";
            }
        }
        return s.trim();
    }

    private String tryTakeDisplayName(String dep) {
        String displayName = null;
        if (dep != null && dep.startsWith("module")) {
            String codeName = dep.substring(6).trim();
            int end = codeName.indexOf(32);
            if (end != -1) {
                codeName = codeName.substring(0, end);
                for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits()) {
                    if (!codeName.equals(u.getCodeName())) continue;
                    if (u.getInstalled() != null) {
                        displayName = u.getInstalled().getDisplayName();
                        continue;
                    }
                    if (u.getAvailableUpdates().size() <= 0) continue;
                    displayName = ((UpdateElement)u.getAvailableUpdates().get(0)).getDisplayName();
                }
            }
            if (displayName != null) {
                displayName = NbBundle.getMessage(OperationDescriptionStep.class, (String)"OperationDescriptionStep_PluginNameFormat", displayName, (Object)dep);
            }
        }
        return displayName == null ? dep : displayName;
    }

    private String preparePluginsForShow(Set<UpdateElement> plugins) {
        String s = new String();
        ArrayList<String> names = new ArrayList<String>();
        for (UpdateElement el : plugins) {
            names.add("<b>" + el.getDisplayName() + "</b> " + NbBundle.getMessage(OperationDescriptionStep.class, (String)"OperationDescriptionStep_PluginVersionFormat", (Object)el.getSpecificationVersion()) + "<br>");
        }
        Collections.sort(names);
        for (String name : names) {
            s = s + name;
        }
        return s.trim();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        boolean approved;
        boolean bl = approved = !(this.model instanceof InstallUnitWizardModel) || ((InstallUnitWizardModel)this.model).allLicensesApproved();
        if (approved) {
            this.model.modifyOptionsForDoOperation(wd);
        } else {
            this.model.modifyOptionsForStartWizard(wd);
        }
    }

    public void storeSettings(WizardDescriptor wd) {
    }

    public boolean isValid() {
        return this.model != null && !this.model.hasBrokenDependencies();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(OperationDescriptionPanel.class, (String)key);
    }
}

