/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationWizardModel {
    private Set<UpdateElement> primaryElements;
    private Set<UpdateElement> requiredElements = null;
    private Set<UpdateElement> allElements = null;
    private JButton originalCancel = null;
    private JButton originalNext = null;
    private JButton originalFinish = null;
    private boolean reconized = false;

    abstract OperationType getOperation();

    abstract OperationContainer getContainer();

    public Set<UpdateElement> getPrimaryUpdateElements() {
        if (this.primaryElements == null) {
            assert (this.getContainer() != null);
            this.primaryElements = new HashSet<UpdateElement>();
            List l = this.getContainer().listAll();
            for (OperationContainer.OperationInfo info : l) {
                this.primaryElements.add(info.getUpdateElement());
            }
        }
        return this.primaryElements;
    }

    public boolean hasRequiredUpdateElements() {
        return !this.getRequiredUpdateElements().isEmpty();
    }

    public Set<UpdateElement> getRequiredUpdateElements() {
        if (this.requiredElements == null) {
            this.requiredElements = new HashSet<UpdateElement>();
            List l = this.getContainer().listAll();
            for (OperationContainer.OperationInfo info : l) {
                this.requiredElements.addAll(info.getRequiredElements());
            }
            this.getContainer().add(this.requiredElements);
        }
        return this.requiredElements;
    }

    public boolean hasBrokenDependencies() {
        return !this.getBrokenDependencies().isEmpty();
    }

    public SortedMap<String, Set<String>> getBrokenDependencies() {
        TreeMap<String, Set<String>> brokenDeps = new TreeMap<String, Set<String>>();
        List l = this.getContainer().listAll();
        for (OperationContainer.OperationInfo info : l) {
            Set broken = info.getBrokenDependencies();
            if (broken.isEmpty()) continue;
            brokenDeps.put(info.getUpdateElement().getDisplayName(), new HashSet(broken));
        }
        return brokenDeps;
    }

    public Set<UpdateElement> getAllUpdateElements() {
        if (this.allElements == null) {
            this.allElements = new HashSet<UpdateElement>(this.getPrimaryUpdateElements());
            this.allElements.addAll(this.getRequiredUpdateElements());
            assert (this.allElements.size() == this.getPrimaryUpdateElements().size() + this.getRequiredUpdateElements().size()) : "Primary [" + this.getPrimaryUpdateElements().size() + "] plus " + "Required [" + this.getRequiredUpdateElements().size() + "] is All [" + this.allElements.size() + "] ";
        }
        return this.allElements;
    }

    public void modifyOptionsForDoClose(WizardDescriptor wd) {
        this.recognizeButtons(wd);
        JButton b = this.getOriginalCancel(wd);
        Mnemonics.setLocalizedText((AbstractButton)b, (String)this.getBundle("InstallUnitWizardModel_Buttons_Close"));
        wd.setOptions((Object[])new JButton[]{b});
    }

    public void modifyOptionsForStartWizard(WizardDescriptor wd) {
        this.recognizeButtons(wd);
        this.removeFinish(wd);
        Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)NbBundle.getMessage(InstallUnitWizardModel.class, (String)"InstallUnitWizardModel_Buttons_MnemonicNext", (Object)this.getBundle("InstallUnitWizardModel_Buttons_Next")));
    }

    public void modifyOptionsForDoOperation(WizardDescriptor wd) {
        this.recognizeButtons(wd);
        this.removeFinish(wd);
        switch (this.getOperation()) {
            case INSTALL: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Install"));
                break;
            }
            case UPDATE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Update"));
                break;
            }
            case UNINSTALL: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_Uninstall"));
                break;
            }
            case ENABLE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOn"));
                break;
            }
            case DISABLE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOff"));
                break;
            }
            default: {
                assert (false) : "Unknown operationType " + (Object)((Object)this.getOperation());
                break;
            }
        }
    }

    public JButton getCancelButton(WizardDescriptor wd) {
        return this.getOriginalCancel(wd);
    }

    public void modifyOptionsForDisabledCancel(WizardDescriptor wd) {
        this.recognizeButtons(wd);
        Object[] options = wd.getOptions();
        ArrayList<JButton> newOptionsL = new ArrayList<JButton>();
        List<Object> optionsL = Arrays.asList(options);
        for (Object o : optionsL) {
            assert (o instanceof JButton) : o + " instanceof JButton";
            if (!(o instanceof JButton)) continue;
            JButton b = (JButton)o;
            if (b.equals(this.getOriginalCancel(wd))) {
                JButton disabledCancel = new JButton(b.getText());
                disabledCancel.setEnabled(false);
                newOptionsL.add(disabledCancel);
                continue;
            }
            newOptionsL.add(b);
        }
        wd.setOptions(newOptionsL.toArray());
    }

    private void recognizeButtons(WizardDescriptor wd) {
        if (!this.reconized) {
            Object[] options = wd.getOptions();
            assert (options != null && options.length >= 4);
            assert (options[1] instanceof JButton) : options[1] + " instanceof JButton";
            this.originalNext = (JButton)options[1];
            assert (options[2] instanceof JButton) : options[2] + " instanceof JButton";
            this.originalFinish = (JButton)options[2];
            assert (options[3] instanceof JButton) : options[3] + " instanceof JButton";
            this.originalCancel = (JButton)options[3];
            this.reconized = true;
        }
    }

    private JButton getOriginalNext(WizardDescriptor wd) {
        return this.originalNext;
    }

    private JButton getOriginalCancel(WizardDescriptor wd) {
        return this.originalCancel;
    }

    private void removeFinish(WizardDescriptor wd) {
        Object[] options = wd.getOptions();
        ArrayList<JButton> newOptionsL = new ArrayList<JButton>();
        List<Object> optionsL = Arrays.asList(options);
        for (Object o : optionsL) {
            JButton b;
            assert (o instanceof JButton) : o + " instanceof JButton";
            if (!(o instanceof JButton) || (b = (JButton)o).equals(this.originalFinish)) continue;
            newOptionsL.add(b);
        }
        wd.setOptions(newOptionsL.toArray());
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(InstallUnitWizardModel.class, (String)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        UPDATE,
        REVERT,
        ENABLE,
        DISABLE;

    }
}

