/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.wizards.InstallPanel;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UninstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.wizards.UninstallStep");
    private InstallPanel panel;
    private PanelBodyContainer component;
    private UninstallUnitWizardModel model = null;
    private WizardDescriptor wd = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_UNINSTALL = "UninstallStep_Header_Uninstall_Head";
    private static final String CONTENT_UNINSTALL = "UninstallStep_Header_Uninstall_Content";
    private static final String HEAD_DEACTIVATE = "UninstallStep_Header_Deactivate_Head";
    private static final String CONTENT_DEACTIVATE = "UninstallStep_Header_Deactivate_Content";
    private static final String HEAD_ACTIVATE = "UninstallStep_Header_Activate_Head";
    private static final String CONTENT_ACTIVATE = "UninstallStep_Header_Activate_Content";
    private static final String HEAD_DEACTIVATE_DONE = "UninstallStep_Header_DeactivateDone_Head";
    private static final String CONTENT_DEACTIVATE_DONE = "UninstallStep_Header_DeactivateDone_Content";
    private static final String HEAD_ACTIVATE_DONE = "UninstallStep_Header_ActivateDone_Head";
    private static final String CONTENT_ACTIVATE_DONE = "UninstallStep_Header_ActivateDone_Content";
    private static final String HEAD_UNINSTALL_DONE = "UninstallStep_Header_UninstallDone_Head";
    private static final String CONTENT_UNINSTALL_DONE = "UninstallStep_Header_UninstallDone_Content";
    private static final String UNINSTALL_PROGRESS_NAME = "UninstallStep_ProgressName_Uninstall";
    private static final String ACTIVATE_PROGRESS_NAME = "UninstallStep_ProgressName_Activate";
    private static final String DEACTIVATE_PROGRESS_NAME = "UninstallStep_ProgressName_Deactivate";

    public UninstallStep(UninstallUnitWizardModel model) {
        this.model = model;
    }

    public boolean isFinishPanel() {
        return false;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new InstallPanel();
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("run-action".equals(evt.getPropertyName())) {
                        UninstallStep.this.doAction();
                    }
                }
            });
            switch (this.model.getOperation()) {
                case UNINSTALL: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_UNINSTALL), this.getBundle(CONTENT_UNINSTALL), this.panel);
                    break;
                }
                case ENABLE: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_ACTIVATE), this.getBundle(CONTENT_ACTIVATE), this.panel);
                    break;
                }
                case DISABLE: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_DEACTIVATE), this.getBundle(CONTENT_DEACTIVATE), this.panel);
                    break;
                }
                default: {
                    assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                    break;
                }
            }
        }
        return this.component;
    }

    private void doAction() {
        this.handleAction();
        this.presentActionDone();
        this.fireChange();
    }

    private void handleAction() {
        OperationSupport support = (OperationSupport)this.model.getContainer().getSupport();
        assert (support != null);
        ProgressHandle handle = null;
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                handle = ProgressHandleFactory.createHandle((String)this.getBundle(UNINSTALL_PROGRESS_NAME));
                break;
            }
            case ENABLE: {
                handle = ProgressHandleFactory.createHandle((String)this.getBundle(ACTIVATE_PROGRESS_NAME));
                break;
            }
            case DISABLE: {
                handle = ProgressHandleFactory.createHandle((String)this.getBundle(DEACTIVATE_PROGRESS_NAME));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent(handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        this.model.modifyOptionsForDisabledCancel(this.wd);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        try {
            support.doOperation(handle);
        }
        catch (OperationException ex) {
            this.err.log(Level.INFO, ex.getMessage(), ex);
        }
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(this.getBundle("UninstallStep_Done")));
    }

    private void presentActionDone() {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(this.getBundle(HEAD_UNINSTALL_DONE), this.getBundle(CONTENT_UNINSTALL_DONE));
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_ACTIVATE_DONE), this.getBundle(CONTENT_ACTIVATE_DONE));
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_DEACTIVATE_DONE), this.getBundle(CONTENT_DEACTIVATE_DONE));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        this.model.modifyOptionsForDoClose(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallDone_Text"), this.model.getAllUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateDone_Text"), this.model.getAllUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateDone_Text"), this.model.getAllUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
    }

    public void storeSettings(WizardDescriptor wd) {
    }

    public boolean isValid() {
        return false;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        UninstallStep uninstallStep = this;
        synchronized (uninstallStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(InstallStep.class, (String)key);
    }
}

