/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public final class CodeTemplateCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int type, JTextComponent component) {
        return type != 1 || CodeTemplateCompletionProvider.isAbbrevDisabled(component) ? null : new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static boolean isAbbrevDisabled(JTextComponent component) {
        return Abbrev.isAbbrevDisabled((JTextComponent)component);
    }

    private static final class Query
    extends AsyncCompletionQuery
    implements ChangeListener {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private List queryResult;
        private String filterPrefix;

        private Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getSelectionStart();
            Document doc = component.getDocument();
            this.filterPrefix = null;
            if (caretOffset >= this.queryCaretOffset && this.queryAnchorOffset < this.queryCaretOffset) {
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    if (!this.isJavaIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                resultSet.addAllItems(this.getFilteredData(this.queryResult, this.filterPrefix));
            }
            resultSet.finish();
        }

        private boolean isJavaIdentifierPart(CharSequence text) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection data, String prefix) {
            ArrayList<CodeTemplateCompletionItem> ret = new ArrayList<CodeTemplateCompletionItem>();
            Iterator it = data.iterator();
            while (it.hasNext()) {
                CodeTemplateCompletionItem itm = (CodeTemplateCompletionItem)it.next();
                if (!((Object)itm.getInsertPrefix()).toString().startsWith(prefix)) continue;
                ret.add(itm);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CodeTemplateManagerOperation op = CodeTemplateManagerOperation.get(doc);
            String identifierBeforeCursor = null;
            if (doc instanceof AbstractDocument) {
                AbstractDocument adoc = (AbstractDocument)doc;
                adoc.readLock();
                try {
                    if (adoc instanceof BaseDocument) {
                        identifierBeforeCursor = Utilities.getIdentifierBefore((BaseDocument)((BaseDocument)adoc), (int)caretOffset);
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    adoc.readUnlock();
                }
            }
            op.waitLoaded();
            this.queryCaretOffset = caretOffset;
            int n = this.queryAnchorOffset = identifierBeforeCursor != null ? caretOffset - identifierBeforeCursor.length() : caretOffset;
            if (identifierBeforeCursor != null) {
                boolean ignoreCase = !SettingsUtil.getBoolean(this.component.getUI().getEditorKit(this.component).getClass(), (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
                Collection cts = op.findByParametrizedText(identifierBeforeCursor, ignoreCase);
                Collection filters = op.getTemplateFilters(this.component, this.queryAnchorOffset);
                this.queryResult = new ArrayList(cts.size());
                Iterator it = cts.iterator();
                while (it.hasNext()) {
                    CodeTemplate ct = (CodeTemplate)it.next();
                    if (!Query.accept(ct, filters)) continue;
                    this.queryResult.add(new CodeTemplateCompletionItem(ct));
                }
                resultSet.addAllItems((Collection)this.queryResult);
            }
            resultSet.setAnchorOffset(this.queryAnchorOffset);
            resultSet.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent evt) {
            Query query = this;
            synchronized (query) {
                this.notify();
            }
        }

        private static boolean accept(CodeTemplate template, Collection filters) {
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                CodeTemplateFilter filter = (CodeTemplateFilter)it.next();
                if (filter.accept(template)) continue;
                return false;
            }
            return true;
        }
    }
}

