/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.CodeTemplateComparator;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class CodeTemplateManagerOperation
implements LookupListener,
Runnable,
SettingsChangeListener {
    private static Map mime2operation;
    private final CodeTemplateManager manager;
    private final String mimeType;
    private Lookup.Result descriptions;
    private Collection processorFactories;
    private Collection filterFactories;
    private Map abbrev2template;
    private List sortedTemplatesByAbbrev;
    private List unmodSortedTemplatesByAbbrev;
    private List sortedTemplatesByParametrizedText;
    private List selectionTemplates;
    private EventListenerList listenerList = new EventListenerList();
    private boolean settingsListeningInitialized;
    private static final int MATCH_NO = 0;
    private static final int MATCH_IGNORE_CASE = 1;
    private static final int MATCH = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized CodeTemplateManager getManager(Document doc) {
        return CodeTemplateManagerOperation.get(doc).getManager();
    }

    public static synchronized CodeTemplateManagerOperation get(Document doc) {
        boolean mimesEqual;
        String mimeType = (String)doc.getProperty("mimeType");
        CodeTemplateManagerOperation operation = (CodeTemplateManagerOperation)doc.getProperty(CodeTemplateManagerOperation.class);
        boolean bl = mimesEqual = operation != null && CodeTemplateManagerOperation.mimeTypesEqual(mimeType, operation.getMimeType());
        if (!mimesEqual) {
            WeakReference ref = (WeakReference)mime2operation.get(mimeType);
            operation = ref != null ? (CodeTemplateManagerOperation)ref.get() : null;
            if (operation == null) {
                operation = new CodeTemplateManagerOperation(mimeType);
                CodeTemplateApiPackageAccessor.get().createCodeTemplateManager(operation);
                mime2operation.put(mimeType, new WeakReference<CodeTemplateManagerOperation>(operation));
            }
            doc.putProperty(CodeTemplateManagerOperation.class, operation);
        }
        return operation;
    }

    private static boolean mimeTypesEqual(String mimeType1, String mimeType2) {
        return mimeType1 == null && mimeType2 == null || mimeType1 != null && mimeType1.equals(mimeType2);
    }

    private CodeTemplateManagerOperation(String mimeType) {
        this.mimeType = mimeType;
        CodeTemplateManager.class.getName();
        this.manager = CodeTemplateApiPackageAccessor.get().createCodeTemplateManager(this);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public CodeTemplateManager getManager() {
        if (!$assertionsDisabled && this.manager == null) {
            throw new AssertionError();
        }
        return this.manager;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Collection getCodeTemplates() {
        return this.unmodSortedTemplatesByAbbrev;
    }

    public Collection findSelectionTemplates() {
        return this.selectionTemplates;
    }

    public CodeTemplate findByAbbreviation(String abbreviation) {
        return (CodeTemplate)this.abbrev2template.get(abbreviation);
    }

    public Collection findByParametrizedText(String prefix, boolean ignoreCase) {
        int mp;
        int i;
        CodeTemplate t;
        ArrayList<CodeTemplate> result = new ArrayList<CodeTemplate>();
        int low = 0;
        int high = this.sortedTemplatesByParametrizedText.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            t = (CodeTemplate)this.sortedTemplatesByParametrizedText.get(mid);
            int cmp = CodeTemplateManagerOperation.compareTextIgnoreCase(t.getParametrizedText(), prefix);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid;
            break;
        }
        for (i = low - 1; i >= 0 && (mp = CodeTemplateManagerOperation.matchPrefix((t = (CodeTemplate)this.sortedTemplatesByParametrizedText.get(i)).getParametrizedText(), prefix)) != 0; --i) {
            if (mp == 1) {
                if (!ignoreCase) continue;
                result.add(t);
                continue;
            }
            result.add(t);
        }
        for (i = low; i < this.sortedTemplatesByParametrizedText.size() && (mp = CodeTemplateManagerOperation.matchPrefix((t = (CodeTemplate)this.sortedTemplatesByParametrizedText.get(i)).getParametrizedText(), prefix)) != 0; ++i) {
            if (mp == 1) {
                if (!ignoreCase) continue;
                result.add(t);
                continue;
            }
            result.add(t);
        }
        return result;
    }

    public Collection getTemplateFilters(JTextComponent component, int offset) {
        ArrayList<CodeTemplateFilter> result = new ArrayList<CodeTemplateFilter>();
        Iterator it = this.filterFactories.iterator();
        while (it.hasNext()) {
            CodeTemplateFilter.Factory factory = (CodeTemplateFilter.Factory)it.next();
            result.add(factory.createFilter(component, offset));
        }
        return result;
    }

    public void insert(CodeTemplate codeTemplate, JTextComponent component) {
        CodeTemplateInsertHandler handler = new CodeTemplateInsertHandler(codeTemplate, component, this.processorFactories);
        handler.processTemplate();
    }

    private static int matchPrefix(CharSequence text, CharSequence prefix) {
        int i;
        boolean matchCase = true;
        int prefixLength = prefix.length();
        if (prefixLength > text.length()) {
            return 0;
        }
        for (i = 0; i < prefixLength; ++i) {
            char ch2;
            char ch1 = text.charAt(i);
            if (ch1 == (ch2 = prefix.charAt(i))) continue;
            matchCase = false;
            if (Character.toLowerCase(ch1) != Character.toLowerCase(ch2)) break;
        }
        if (i == prefixLength) {
            return matchCase ? 2 : 1;
        }
        return 0;
    }

    private static int compareTextIgnoreCase(CharSequence text1, CharSequence text2) {
        int len = Math.min(text1.length(), text2.length());
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch1 = Character.toLowerCase(text1.charAt(i));
            if (ch1 == (ch2 = Character.toLowerCase(text2.charAt(i)))) continue;
            return ch1 - ch2;
        }
        return text1.length() - text2.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded() {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            return this.descriptions != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLoadedListener(ChangeListener listener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (this.descriptions != null) {
                listener.stateChanged(new ChangeEvent(this));
            } else {
                this.listenerList.add(ChangeListener.class, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLoaded() {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (!this.isLoaded()) {
                try {
                    this.listenerList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(ChangeEvent evt) {
        Object[] listeners;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            listeners = this.listenerList.getListenerList();
        }
        for (int i = 0; i < listeners.length; i += 2) {
            if ((class$javax$swing$event$ChangeListener == null ? CodeTemplateManagerOperation.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener) != listeners[i]) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(evt);
        }
    }

    public void run() {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getMimeType()));
        Lookup.Result result = lookup.lookup(new Lookup.Template(CodeTemplateProcessorFactory.class));
        this.processorFactories = result.allInstances();
        result = lookup.lookup(new Lookup.Template(CodeTemplateFilter.Factory.class));
        this.filterFactories = result.allInstances();
        this.setDescriptions(Lookup.EMPTY.lookup(new Lookup.Template(CodeTemplateDescription.class)));
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.rebuildCodeTemplates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDescriptions(Lookup.Result descriptions) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.descriptions = descriptions;
            this.rebuildCodeTemplates();
            this.fireStateChanged(new ChangeEvent(this.manager));
            this.listenerList.notifyAll();
        }
    }

    private Collection updateDescriptionInstances(Collection descriptionsInstances) {
        descriptionsInstances = new ArrayList<CodeTemplateDescription>();
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)this.mimeType));
        BaseOptions baseOptions = (BaseOptions)lookup.lookup(BaseOptions.class);
        if (baseOptions != null) {
            Map abbrevMap = baseOptions.getAbbrevMap();
            if (abbrevMap != null) {
                Iterator entryIt = abbrevMap.entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry entry = entryIt.next();
                    String abbreviation = (String)entry.getKey();
                    String abbrevText = (String)entry.getValue();
                    String parametrizedText = abbrevText.replaceFirst("([^|]+)[|]([^|]+)", "$1\\${cursor}$2");
                    parametrizedText = parametrizedText.replaceAll("[|]{2}", "|");
                    String desc = abbrevText;
                    int nlInd = abbrevText.indexOf(10);
                    if (nlInd != -1) {
                        desc = abbrevText.substring(0, nlInd) + "...";
                    }
                    StringBuffer htmlText = new StringBuffer();
                    ParametrizedTextParser parser = new ParametrizedTextParser(null, desc);
                    parser.parse();
                    parser.appendHtmlText(htmlText);
                    desc = htmlText.toString();
                    CodeTemplateDescription ctd = new CodeTemplateDescription(abbreviation, desc, parametrizedText, null);
                    descriptionsInstances.add(ctd);
                }
            }
            if (!this.settingsListeningInitialized) {
                this.settingsListeningInitialized = true;
                Settings.addSettingsChangeListener((SettingsChangeListener)this);
            }
        }
        return descriptionsInstances;
    }

    private void rebuildCodeTemplates() {
        Collection descriptionsInstances = this.descriptions.allInstances();
        descriptionsInstances = this.updateDescriptionInstances(descriptionsInstances);
        ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>(descriptionsInstances.size());
        this.selectionTemplates = new ArrayList(descriptionsInstances.size());
        CodeTemplateApiPackageAccessor api = CodeTemplateApiPackageAccessor.get();
        Iterator it = descriptionsInstances.iterator();
        while (it.hasNext()) {
            CodeTemplateDescription description = (CodeTemplateDescription)it.next();
            CodeTemplate ct = api.createCodeTemplate(this, description.getAbbreviation(), description.getDescription(), description.getParametrizedText());
            codeTemplates.add(ct);
            if (description.getParametrizedText().toLowerCase().indexOf("${selection") <= -1) continue;
            this.selectionTemplates.add(ct);
        }
        this.refreshMaps(codeTemplates);
    }

    private void refreshMaps(List codeTemplates) {
        this.abbrev2template = new HashMap(codeTemplates.size());
        this.sortedTemplatesByAbbrev = new ArrayList(codeTemplates.size());
        this.unmodSortedTemplatesByAbbrev = Collections.unmodifiableList(this.sortedTemplatesByAbbrev);
        this.sortedTemplatesByParametrizedText = new ArrayList(codeTemplates.size());
        Iterator it = codeTemplates.iterator();
        while (it.hasNext()) {
            CodeTemplate template = (CodeTemplate)it.next();
            String abbreviation = template.getAbbreviation();
            this.abbrev2template.put(abbreviation, template);
            this.sortedTemplatesByAbbrev.add(template);
            this.sortedTemplatesByParametrizedText.add(template);
        }
        Collections.sort(this.sortedTemplatesByAbbrev, CodeTemplateComparator.BY_ABBREVIATION_IGNORE_CASE);
        Collections.sort(this.sortedTemplatesByParametrizedText, CodeTemplateComparator.BY_PARAMETRIZED_TEXT_IGNORE_CASE);
    }

    public void resultChanged(LookupEvent ev) {
        this.rebuildCodeTemplates();
    }

    public void testInstallProcessorFactory(CodeTemplateProcessorFactory factory) {
        this.processorFactories = Collections.singletonList(factory);
    }

    static {
        $assertionsDisabled = !CodeTemplateManagerOperation.class.desiredAssertionStatus();
        mime2operation = new HashMap(8);
    }
}

