/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ChangeCVSRootAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ExportDiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.AddToRepositoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.UpdateWithDependenciesAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchesMenu;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class Annotator {
    private static MessageFormat uptodateFormat = Annotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = Annotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = Annotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = Annotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = Annotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = Annotator.getFormat("deletedLocallyFormat");
    private static MessageFormat newInRepositoryFormat = Annotator.getFormat("newInRepositoryFormat");
    private static MessageFormat modifiedInRepositoryFormat = Annotator.getFormat("modifiedInRepositoryFormat");
    private static MessageFormat removedInRepositoryFormat = Annotator.getFormat("removedInRepositoryFormat");
    private static MessageFormat conflictFormat = Annotator.getFormat("conflictFormat");
    private static MessageFormat mergeableFormat = Annotator.getFormat("mergeableFormat");
    private static MessageFormat excludedFormat = Annotator.getFormat("excludedFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6622;
    private static final Pattern lessThan = Pattern.compile("<");
    private final FileStatusCache cache;
    private String lastAnnotationsFormat;
    private MessageFormat lastMessageFormat;
    private String lastEmptyAnnotation;
    private static final int STATUS_BADGEABLE = 12;

    Annotator(CvsVersioningSystem cvs) {
        this.cache = cvs.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fields = Annotator.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.endsWith("Format")) continue;
            this.initDefaultColor(name.substring(0, name.length() - 6));
        }
    }

    private void initDefaultColor(String name) {
        String color = System.getProperty("cvs.color." + name);
        if (color == null) {
            return;
        }
        this.setAnnotationColor(name, color);
    }

    private void setAnnotationColor(String name, String colorString) {
        try {
            Field field = Annotator.class.getDeclaredField(name + "Format");
            MessageFormat format = new MessageFormat("<font color=\"" + colorString + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    public String annotateNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        boolean annotationsVisible = CvsModuleConfig.getDefault().getPreferences().getBoolean("textAnnotationsVisible", false);
        if (annotationsVisible && file != null && (status & 0x19DE) != 0) {
            textAnnotation = this.formatAnnotation(info, file);
            if (textAnnotation.equals(this.lastEmptyAnnotation)) {
                textAnnotation = "";
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        switch (status) {
            case 0: 
            case 1: {
                return name;
            }
            case 8: {
                return uptodateFormat.format(new Object[]{name, textAnnotation});
            }
            case 16: {
                return modifiedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 4: {
                return newLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 256: {
                return removedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 2048: {
                return deletedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 512: {
                return newInRepositoryFormat.format(new Object[]{name, textAnnotation});
            }
            case 32: {
                return modifiedInRepositoryFormat.format(new Object[]{name, textAnnotation});
            }
            case 1024: {
                return removedInRepositoryFormat.format(new Object[]{name, textAnnotation});
            }
            case 4096: {
                return addedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 128: {
                return mergeableFormat.format(new Object[]{name, textAnnotation});
            }
            case 64: {
                return conflictFormat.format(new Object[]{name, textAnnotation});
            }
            case 2: {
                return excludedFormat.format(new Object[]{name, textAnnotation});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String formatAnnotation(FileInformation info, File file) {
        String stickyString;
        this.updateMessageFormat();
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        String revisionString = "";
        String binaryString = "";
        Entry entry = info.getEntry(file);
        if (entry != null) {
            revisionString = entry.getRevision();
            binaryString = entry.getOptions();
            if (!"-kb".equals(binaryString)) {
                binaryString = "";
            }
        }
        stickyString = (stickyString = Utils.getSticky(file)) != null ? stickyString.substring(1) : "";
        Object[] arguments = new Object[]{revisionString, statusString, stickyString, binaryString};
        return this.lastMessageFormat.format(arguments, new StringBuffer(), (FieldPosition)null).toString().trim();
    }

    private void updateMessageFormat() {
        String taf = CvsModuleConfig.getDefault().getPreferences().get("annotationsFormat", "[{status}; {tag}]");
        if (this.lastMessageFormat == null || !taf.equals(this.lastAnnotationsFormat)) {
            while (true) {
                this.lastAnnotationsFormat = taf;
                taf = taf.replaceAll("\\{revision}", "{0}").replaceAll("\\{status}", "{1}").replaceAll("\\{tag}", "{2}").replaceAll("\\{binary}", "{3}");
                try {
                    this.lastMessageFormat = new MessageFormat(taf);
                    this.lastEmptyAnnotation = this.lastMessageFormat.format(new Object[]{"", "", "", ""});
                }
                catch (Exception e) {
                    Logger.getLogger(Annotator.class.getName()).log(Level.SEVERE, this.lastAnnotationsFormat, e);
                    taf = "[{status}; {tag}]";
                    continue;
                }
                break;
            }
        }
    }

    private String annotateFolderNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        boolean annotationsVisible = CvsModuleConfig.getDefault().getPreferences().getBoolean("textAnnotationsVisible", false);
        if (annotationsVisible && file != null && (status & 0xFFFFFFFE) != 0) {
            textAnnotation = this.formatAnnotation(info, file);
            if (textAnnotation.equals(this.lastEmptyAnnotation)) {
                textAnnotation = "";
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                return name;
            }
            case 4: 
            case 8: 
            case 4096: {
                return uptodateFormat.format(new Object[]{name, textAnnotation});
            }
            case 2: {
                return excludedFormat.format(new Object[]{name, textAnnotation});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    public String annotateNameHtml(String name, VCSContext context, int includeStatus) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            int status = info.getStatus();
            if ((status & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = file.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])context.getRootFiles().toArray(new File[context.getRootFiles().size()]));
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return Utils.getComparableStatus(a.getStatus()) < Utils.getComparableStatus(b.getStatus());
    }

    Image annotateFolderIcon(Set roots, Image icon) {
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        boolean allExcluded = true;
        boolean modified = false;
        Map<File, FileInformation> map = this.cache.getAllModifiedFiles();
        HashMap<File, FileInformation> modifiedFiles = new HashMap<File, FileInformation>();
        for (File file : map.keySet()) {
            FileInformation info = map.get(file);
            if (info.isDirectory() || (info.getStatus() & 0x19D4) == 0) continue;
            modifiedFiles.put(file, info);
        }
        for (File file : roots) {
            int status;
            FileInformation info;
            if (VersioningSupport.isFlat((File)file)) {
                for (File mf : modifiedFiles.keySet()) {
                    if (!mf.getParentFile().equals(file) || (info = (FileInformation)modifiedFiles.get(mf)).isDirectory()) continue;
                    status = info.getStatus();
                    if (status == 64) {
                        Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                    }
                    modified = true;
                    allExcluded &= config.isExcludedFromCommit(mf);
                }
                continue;
            }
            for (File mf : modifiedFiles.keySet()) {
                if (!Utils.isParentOrEqual(file, mf)) continue;
                info = (FileInformation)modifiedFiles.get(mf);
                status = info.getStatus();
                if (status == 64) {
                    Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                }
                modified = true;
                allExcluded &= config.isExcludedFromCommit(mf);
            }
        }
        if (modified && !allExcluded) {
            Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return null;
    }

    public static Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination destination) {
        ResourceBundle loc = NbBundle.getBundle(Annotator.class);
        Node[] nodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        File[] files = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
        Lookup context = ctx.getElements();
        boolean noneVersioned = Annotator.isNothingVersioned(files);
        boolean onlyFolders = Annotator.onlyFolders(files);
        boolean onlyProjects = Annotator.onlyProjects(nodes);
        ArrayList<Object> actions = new ArrayList<Object>(20);
        if (destination == VCSAnnotator.ActionDestination.MainMenu) {
            actions.add(SystemAction.get(CheckoutAction.class));
            actions.add(SystemAction.get(AddToRepositoryAction.class));
            actions.add(new ChangeCVSRootAction(loc.getString("CTL_MenuItem_ChangeCVSRoot"), ctx));
            actions.add(null);
            actions.add(SystemAction.get(UpdateWithDependenciesAction.class));
            actions.add(null);
            actions.add(SystemAction.get(StatusAction.class));
            actions.add(SystemAction.get(DiffAction.class));
            actions.add(SystemAction.get(UpdateAction.class));
            actions.add(SystemAction.get(CommitAction.class));
            actions.add(null);
            actions.add(SystemAction.get(ExportDiffAction.class));
            actions.add(null);
            actions.add(SystemAction.get(TagAction.class));
            actions.add(new BranchesMenu());
            actions.add(null);
            actions.add(SystemAction.get(AnnotationsAction.class));
            actions.add(new ViewRevisionAction(ctx));
            actions.add(SystemAction.get(SearchHistoryAction.class));
            actions.add(null);
            actions.add(SystemAction.get(GetCleanAction.class));
            actions.add(SystemAction.get(ResolveConflictsAction.class));
            actions.add(SystemAction.get(IgnoreAction.class));
            actions.add(new ExcludeFromCommitAction(ctx));
        } else if (noneVersioned) {
            actions.add(SystemActionBridge.createAction((Action)((AddToRepositoryAction)SystemAction.get(AddToRepositoryAction.class)).createContextAwareInstance(context), (String)loc.getString("CTL_PopupMenuItem_Import"), (Lookup)context));
        } else {
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)loc.getString("CTL_PopupMenuItem_Status"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)loc.getString("CTL_PopupMenuItem_Diff"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(UpdateAction.class), (String)loc.getString("CTL_PopupMenuItem_Update"), (Lookup)context));
            if (onlyProjects) {
                actions.add(new SystemActionBridge((Action)SystemAction.get(UpdateWithDependenciesAction.class), loc.getString("CTL_PopupMenuItem_UpdateWithDeps")));
            }
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)loc.getString("CTL_PopupMenuItem_Commit"), (Lookup)context));
            actions.add(null);
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(TagAction.class), (String)loc.getString("CTL_PopupMenuItem_Tag"), (Lookup)context));
            actions.add(null);
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(BranchAction.class), (String)loc.getString("CTL_PopupMenuItem_Branch"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SwitchBranchAction.class), (String)loc.getString("CTL_PopupMenuItem_SwitchBranch"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(MergeBranchAction.class), (String)loc.getString("CTL_PopupMenuItem_MergeBranch"), (Lookup)context));
            actions.add(null);
            if (!onlyFolders) {
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(AnnotationsAction.class), (String)(((AnnotationsAction)SystemAction.get(AnnotationsAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)context));
            }
            actions.add(new ViewRevisionAction(loc.getString("CTL_PopupMenuItem_ViewRevision"), ctx));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)loc.getString("CTL_PopupMenuItem_SearchHistory"), (Lookup)context));
            actions.add(null);
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(GetCleanAction.class), (String)loc.getString("CTL_PopupMenuItem_GetClean"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)loc.getString("CTL_PopupMenuItem_ResolveConflicts"), (Lookup)context));
            if (!onlyProjects) {
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)(((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(nodes) == 2 ? loc.getString("CTL_PopupMenuItem_Unignore") : loc.getString("CTL_PopupMenuItem_Ignore")), (Lookup)context));
            }
            actions.add(new ExcludeFromCommitAction(ctx));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private static boolean isNothingVersioned(File[] files) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (File file : files) {
            if ((cache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProjects(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyFolders(File[] files) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                return false;
            }
            if (files[i].exists() || cache.getStatus(files[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static MessageFormat getFormat(String key) {
        String format = NbBundle.getMessage(Annotator.class, (String)key);
        return new MessageFormat(format);
    }

    public Image annotateIcon(Image icon, VCSContext context) {
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])context.getRootFiles().toArray(new File[context.getRootFiles().size()]));
        }
        if (!folderAnnotation) {
            return null;
        }
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        boolean isVersioned = false;
        for (File file : context.getRootFiles()) {
            if ((cache.getStatus(file).getStatus() & 0xC) == 0) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return null;
        }
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        boolean allExcluded = true;
        boolean modified = false;
        Map<File, FileInformation> map = cache.getAllModifiedFiles();
        HashMap<File, FileInformation> modifiedFiles = new HashMap<File, FileInformation>();
        for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
            FileInformation info = entry.getValue();
            if (info.isDirectory() || (info.getStatus() & 0x19D4) == 0) continue;
            modifiedFiles.put(entry.getKey(), info);
        }
        for (File file : context.getRootFiles()) {
            int status;
            FileInformation info;
            if (VersioningSupport.isFlat((File)file)) {
                for (File mf : modifiedFiles.keySet()) {
                    if (!mf.getParentFile().equals(file) || (info = (FileInformation)modifiedFiles.get(mf)).isDirectory()) continue;
                    status = info.getStatus();
                    if (status == 64) {
                        Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                    }
                    modified = true;
                    allExcluded &= config.isExcludedFromCommit(mf);
                }
                continue;
            }
            for (File mf : modifiedFiles.keySet()) {
                if (!Utils.isParentOrEqual(file, mf)) continue;
                info = (FileInformation)modifiedFiles.get(mf);
                status = info.getStatus();
                if (status == 64) {
                    Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                }
                modified = true;
                allExcluded &= config.isExcludedFromCommit(mf);
            }
        }
        if (modified && !allExcluded) {
            Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return null;
    }
}

