/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CvsVisibilityQuery
implements VisibilityQueryImplementation,
VersioningListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public CvsVisibilityQuery() {
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
    }

    public boolean isVisible(FileObject fileObject) {
        if (fileObject.isData()) {
            return true;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        return file == null || !CvsVisibilityQuery.isHiddenFolder(file);
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.add(l);
        this.listeners = newList;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.remove(l);
        this.listeners = newList;
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            if (file == null) {
                return;
            }
            File parent = file.getParentFile();
            if (parent == null) {
                return;
            }
            File marker = new File(parent, "CVS/.nb-removed");
            if (marker.exists()) {
                this.fireVisibilityChanged();
            }
        }
    }

    static boolean isHiddenFolder(File file) {
        File marker = new File(file, "CVS/.nb-removed");
        if (marker.exists()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                if (child.lastModified() <= marker.lastModified() || "CVS".equals(child.getName())) continue;
                marker.delete();
                return false;
            }
            return true;
        }
        return false;
    }

    private void fireVisibilityChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }
}

