/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.executor;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CheckoutExecutor
extends ExecutorSupport {
    private Set refreshedFiles;
    private Set expandedModules = new HashSet();

    public CheckoutExecutor(CvsVersioningSystem cvs, CheckoutCommand cmd) {
        this(cvs, cmd, null);
    }

    public CheckoutExecutor(CvsVersioningSystem cvs, CheckoutCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    public Set getExpandedModules() {
        return this.expandedModules;
    }

    public final void moduleExpanded(ModuleExpansionEvent e) {
        String module = e.getModule();
        this.expandedModules.add(module);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        CheckoutCommand xcmd = (CheckoutCommand)this.cmd;
        this.refreshedFiles = new HashSet(this.toRefresh.size());
        for (DefaultFileInfoContainer info : this.toRefresh) {
            int repositoryStatus = 0;
            if ("Changed".equals(info.getType()) || "Added".equals(info.getType())) {
                repositoryStatus = 65536;
            } else if ("Removed".equals(info.getType()) || "To-be-added".equals(info.getType())) {
                repositoryStatus = 0;
            }
            File file = FileUtil.normalizeFile((File)info.getFile());
            this.cache.refreshCached(file, repositoryStatus);
            this.refreshedFiles.add(file);
        }
        File[] files = xcmd.getFiles();
        for (int i = 0; i < files.length; ++i) {
            FileObject fo;
            File file = FileUtil.normalizeFile((File)files[i]);
            this.refreshRecursively(file);
            if (file.isFile()) {
                this.cache.refreshCached(file.getParentFile(), 0);
            }
            if ((fo = FileUtil.toFileObject((File)file)) == null) continue;
            fo.refresh(true);
        }
    }

    private void refreshRecursively(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.refreshRecursively(files[i]);
            }
            this.cache.refreshCached(file, 0);
        } else if (this.cache.getStatus(file.getParentFile()).getStatus() != 8) {
            this.cache.refreshCached(file, 0);
        }
    }
}

