/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class CvsRootRewriter {
    private static final String CVS_FOLDER = "CVS";
    private static final String ROOT_FILE = "Root";
    private final File file;
    private final String newRoot;
    private ProgressHandle handle;

    public CvsRootRewriter(File file, String newRoot) {
        this.file = file;
        this.newRoot = newRoot;
    }

    public void rewrite() {
        StatusDisplayer.getDefault().setStatusText("");
        try {
            Collection toRewrite = this.scanForFiles();
            this.rewriteFolders(toRewrite);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Success"));
        }
        catch (IOException ex) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Failure", (Object)ex.getMessage()));
        }
    }

    private Collection scanForFiles() throws IOException {
        HashSet<File> toRewrite = new HashSet<File>();
        HashSet<File> toScan = new HashSet<File>();
        toScan.add(this.file);
        this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Progress"));
        int i = 0;
        int totalSize = 1;
        this.handle.start(100);
        int lastValue = 0;
        do {
            HashSet<File> toAdd = new HashSet<File>();
            Iterator it = toScan.iterator();
            while (it.hasNext()) {
                File folder = (File)it.next();
                it.remove();
                File rootFile = CvsRootRewriter.getCvsRootFile(folder);
                if (rootFile != null) {
                    this.handle.progress(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Scanning", (Object)folder.getPath()));
                    toRewrite.add(rootFile);
                    toAdd.addAll(Arrays.asList(folder.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory();
                        }
                    })));
                }
                ++i;
            }
            toScan.addAll(toAdd);
            lastValue = Math.max(lastValue, (int)((double)i / (double)(totalSize += toScan.size()) * 50.0));
            this.handle.progress(lastValue);
        } while (!toScan.isEmpty());
        return toRewrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteFolders(Collection toRewrite) {
        int i = 0;
        for (File rootFile : toRewrite) {
            if (rootFile.exists() && rootFile.canWrite()) {
                PrintStream ps = null;
                try {
                    ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(rootFile)));
                    ps.println(this.newRoot);
                }
                catch (IOException ioe) {
                    CvsRootRewriter.notify(ioe);
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            this.handle.progress(NbBundle.getMessage(CvsRootRewriter.class, (String)"MSG_CVSRootRewriter_Rewriting", (Object)rootFile.getPath()), (int)((double)(++i) / (double)toRewrite.size() * 50.0) + 50);
        }
        this.handle.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getCvsRootFile(File folder) throws IOException {
        if (folder == null || !folder.isDirectory()) {
            return null;
        }
        File rootFile = new File(folder, CVS_FOLDER + File.separator + ROOT_FILE);
        File repositoryFile = new File(folder, CVS_FOLDER + File.separator + "Repository");
        if (repositoryFile.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(repositoryFile);
                if (((InputStream)in).read() == 47) {
                    throw new IOException("#68881 Absolute CVS/Repository paths are unsupported.");
                }
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException alreadyClosed) {}
                }
            }
        }
        return rootFile.exists() && !rootFile.isDirectory() ? rootFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getCvsRoot(File folder) throws IOException {
        File rootFile = CvsRootRewriter.getCvsRootFile(folder);
        if (rootFile == null) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(rootFile));
            try {
                String string = reader.readLine();
                return string;
            }
            catch (IOException ex) {
                CvsRootRewriter.notify(ex);
                String string2 = null;
                return string2;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex4) {
                    CvsRootRewriter.notify(ex4);
                }
            }
        }
        catch (FileNotFoundException ex3) {
            CvsRootRewriter.notify(ex3);
            return null;
        }
    }

    private static void notify(Throwable t) {
        ErrorManager.getDefault().notify(65536, t);
    }
}

