/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.executor.CheckoutExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutCompletedPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.ProjectUtilities;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class CheckoutAction
extends SystemAction {
    private static final String SHOW_CHECKOUT_COMPLETED = "checkoutAction.showCheckoutCompleted";

    public CheckoutAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getBundle(CheckoutAction.class).getString("CTL_MenuItem_Checkout_Label");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CheckoutAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        CheckoutWizard wizard = new CheckoutWizard();
        if (!wizard.show()) {
            return;
        }
        final String tag = wizard.getTag();
        final String modules = wizard.getModules();
        final String workDir = wizard.getWorkingDir();
        final String cvsRoot = wizard.getCvsRoot();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CheckoutAction.this.checkout(cvsRoot, modules, tag, workDir, true, null);
            }
        });
    }

    public CheckoutExecutor checkout(String cvsRoot, String modules, String tag, String workingDir, boolean scanProject, ExecutorGroup group) {
        StringTokenizer tokenizer;
        CheckoutCommand cmd = new CheckoutCommand();
        String moduleString = modules;
        if (moduleString == null || moduleString.length() == 0) {
            moduleString = ".";
        }
        if ((tokenizer = new StringTokenizer(moduleString, ",;")).countTokens() == 1) {
            cmd.setModule(moduleString);
        } else {
            ArrayList<String> moduleList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken().trim();
                moduleList.add(s);
            }
            String[] modules2 = moduleList.toArray(new String[moduleList.size()]);
            cmd.setModules(modules2);
        }
        cmd.setDisplayName(NbBundle.getMessage(CheckoutAction.class, (String)"BK1006"));
        if (tag != null) {
            cmd.setCheckoutByRevision(tag);
        } else {
            cmd.setResetStickyOnes(true);
        }
        cmd.setPruneDirectories(true);
        cmd.setRecursive(true);
        File workingFolder = new File(workingDir);
        File[] files = new File[]{workingFolder};
        cmd.setFiles(files);
        CvsVersioningSystem cvs = CvsVersioningSystem.getInstance();
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        gtx.setCVSRoot(cvsRoot);
        boolean execute = false;
        if (group == null) {
            execute = true;
            group = new ExecutorGroup(NbBundle.getMessage(CheckoutAction.class, (String)"BK1013"));
        }
        CheckoutExecutor executor = new CheckoutExecutor(cvs, cmd, gtx);
        group.addExecutor(executor);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean(SHOW_CHECKOUT_COMPLETED, true) && scanProject) {
            group.addBarrier(new CheckoutCompletedController(executor, workingFolder, scanProject));
        }
        if (execute) {
            group.execute();
        }
        return executor;
    }

    private class CheckoutCompletedController
    implements Runnable,
    ActionListener {
        private final CheckoutExecutor executor;
        private final File workingFolder;
        private final boolean openProject;
        private CheckoutCompletedPanel panel;
        private Dialog dialog;
        private Project projectToBeOpened;

        public CheckoutCompletedController(CheckoutExecutor executor, File workingFolder, boolean openProject) {
            this.executor = executor;
            this.workingFolder = workingFolder;
            this.openProject = openProject;
        }

        public void run() {
            String msg;
            if (!this.executor.isSuccessful()) {
                return;
            }
            List checkedOutProjects = new LinkedList();
            File normalizedWorkingFolder = FileUtil.normalizeFile((File)this.workingFolder);
            this.refreshRecursively(normalizedWorkingFolder);
            FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
            if (fo != null) {
                String name = NbBundle.getMessage(CheckoutAction.class, (String)"BK1007");
                this.executor.getGroup().progress(name);
                for (String module : this.executor.getExpandedModules()) {
                    if (".".equals(module)) {
                        checkedOutProjects = ProjectUtilities.scanForProjects(fo);
                        break;
                    }
                    FileObject subfolder = fo.getFileObject(module);
                    if (subfolder == null) continue;
                    this.executor.getGroup().progress(name);
                    checkedOutProjects.addAll(ProjectUtilities.scanForProjects(subfolder));
                }
            }
            this.panel = new CheckoutCompletedPanel();
            this.panel.openButton.addActionListener(this);
            this.panel.createButton.addActionListener(this);
            this.panel.closeButton.addActionListener(this);
            this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.panel.againCheckBox.setVisible(!this.openProject);
            String title = NbBundle.getMessage(CheckoutAction.class, (String)"BK1008");
            DialogDescriptor descriptor = new DialogDescriptor((Object)this.panel, title);
            descriptor.setModal(true);
            this.panel.remove(this.panel.openButton);
            this.panel.remove(this.panel.createButton);
            this.panel.remove(this.panel.closeButton);
            Object[] options = null;
            if (checkedOutProjects.size() > 1) {
                msg = NbBundle.getMessage(CheckoutAction.class, (String)"BK1009", (Object)new Integer(checkedOutProjects.size()));
                this.panel.jLabel1.setText(msg);
                options = new Object[]{this.panel.openButton, this.panel.closeButton};
            } else if (checkedOutProjects.size() == 1) {
                Project project;
                this.projectToBeOpened = project = (Project)checkedOutProjects.iterator().next();
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                String projectName = projectInformation.getDisplayName();
                String msg2 = NbBundle.getMessage(CheckoutAction.class, (String)"BK1011", (Object)projectName);
                this.panel.jLabel1.setText(msg2);
                this.panel.openButton.setText(NbBundle.getMessage(CheckoutAction.class, (String)"BK1012"));
                options = new Object[]{this.panel.openButton, this.panel.closeButton};
            } else {
                msg = NbBundle.getMessage(CheckoutAction.class, (String)"BK1010");
                this.panel.jLabel1.setText(msg);
                options = new Object[]{this.panel.createButton, this.panel.closeButton};
            }
            descriptor.setMessageType(1);
            descriptor.setOptions(options);
            descriptor.setClosingOptions(options);
            descriptor.setHelpCtx(new HelpCtx(CheckoutCompletedPanel.class));
            this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CheckoutAction.class, (String)"ACSD_CheckoutCompleted_Dialog"));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CheckoutCompletedController.this.dialog.setVisible(true);
                }
            });
        }

        private void refreshRecursively(File folder) {
            if (folder == null) {
                return;
            }
            this.refreshRecursively(folder.getParentFile());
            CvsVersioningSystem.getInstance().getStatusCache().refresh(folder, 0);
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            this.dialog.setVisible(false);
            if (this.panel.openButton.equals(src)) {
                if (this.projectToBeOpened == null) {
                    JFileChooser chooser = ProjectChooser.projectChooser();
                    chooser.setCurrentDirectory(this.workingFolder);
                    chooser.setMultiSelectionEnabled(true);
                    chooser.showOpenDialog(null);
                    File[] projectDirs = chooser.getSelectedFiles();
                    for (int i = 0; i < projectDirs.length; ++i) {
                        File projectDir = projectDirs[i];
                        FileObject projectFolder = FileUtil.toFileObject((File)projectDir);
                        if (projectFolder == null) continue;
                        try {
                            Project p = ProjectManager.getDefault().findProject(projectFolder);
                            if (p == null) continue;
                            this.openProject(p);
                            continue;
                        }
                        catch (IOException e1) {
                            ErrorManager err = ErrorManager.getDefault();
                            err.annotate((Throwable)e1, NbBundle.getMessage(CheckoutAction.class, (String)"BK1014", (Object)projectFolder));
                            err.notify((Throwable)e1);
                        }
                    }
                } else {
                    if (this.projectToBeOpened == null) {
                        return;
                    }
                    this.openProject(this.projectToBeOpened);
                }
            } else if (this.panel.createButton.equals(src)) {
                ProjectUtilities.newProjectWizard(this.workingFolder);
            }
            if (this.panel.againCheckBox.isSelected()) {
                CvsModuleConfig.getDefault().getPreferences().putBoolean(CheckoutAction.SHOW_CHECKOUT_COMPLETED, false);
            }
        }

        private void openProject(Project p) {
            Project[] projects = new Project[]{p};
            OpenProjects.getDefault().open(projects, false);
            ContextAwareAction action = (ContextAwareAction)CommonProjectActions.setAsMainProjectAction();
            Lookup ctx = Lookups.singleton((Object)p);
            Action ctxAction = action.createContextAwareInstance(ctx);
            ctxAction.actionPerformed(new ActionEvent(this, 0, ""));
            ProjectUtilities.selectAndExpandProject(p);
        }
    }
}

