/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CommitExecutor
extends ExecutorSupport {
    public static CommitExecutor[] splitCommand(CommitCommand cmd, CvsVersioningSystem cvs, GlobalOptions options) {
        Command[] cmds = new Command[]{};
        ResourceBundle loc = NbBundle.getBundle(CommitExecutor.class);
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(loc.getString("MSG_CommitExecutor_CmdDisplayName"));
        }
        try {
            cmds = CommitExecutor.prepareBasicCommand((BasicCommand)cmd);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        CommitExecutor[] executors = new CommitExecutor[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            Command command = cmds[i];
            executors[i] = new CommitExecutor(cvs, (CommitCommand)command, options);
        }
        return executors;
    }

    private CommitExecutor(CvsVersioningSystem cvs, CommitCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        CommitCommand xcmd = (CommitCommand)this.cmd;
        for (CommitInformation info : this.toRefresh) {
            if (info.getFile() == null) continue;
            int repositoryStatus = 0;
            String type = info.getType();
            if ("Changed".equals(type) || "Added".equals(type)) {
                repositoryStatus = 65536;
            } else if ("Removed".equals(type) || "To-be-added".equals(type)) {
                repositoryStatus = 0;
            }
            this.cache.refreshCached(info.getFile(), repositoryStatus);
        }
        if (this.cmd.hasFailed()) {
            return;
        }
        File[] files = xcmd.getFiles();
        for (int i = 0; i < files.length; ++i) {
            FileObject fo = FileUtil.toFileObject((File)files[i]);
            if (fo == null) continue;
            fo.refresh(true);
        }
    }
}

