/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.NbBundle;

class CommitTableModel
extends AbstractTableModel {
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(5);
    private CommitOptions[] commitOptions;
    private CvsFileNode[] nodes;
    private String[] columns;

    public CommitTableModel() {
        ResourceBundle loc = NbBundle.getBundle(CommitTableModel.class);
        this.columnLabels.put("name", new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        this.columnLabels.put("sticky", new String[]{loc.getString("CTL_CommitTable_Column_Sticky"), loc.getString("CTL_CommitTable_Column_Sticky")});
        this.columnLabels.put("status", new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        this.columnLabels.put("action", new String[]{loc.getString("CTL_CommitTable_Column_Action"), loc.getString("CTL_CommitTable_Column_Action")});
        this.columnLabels.put("path", new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(new String[0]);
        this.setNodes(new CvsFileNode[0]);
    }

    void setNodes(CvsFileNode[] nodes) {
        this.nodes = nodes;
        this.createCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public CommitSettings.CommitFile[] getCommitFiles() {
        CommitSettings.CommitFile[] files = new CommitSettings.CommitFile[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            files[i] = new CommitSettings.CommitFile(this.nodes[i], this.commitOptions[i]);
        }
        return files;
    }

    public String getColumnName(int column) {
        return this.columnLabels.get(this.columns[column])[0];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals("action")) {
            return CommitOptions.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals("action");
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals("name")) {
            return this.nodes[rowIndex].getName();
        }
        if (col.equals("sticky")) {
            String sticky = Utils.getSticky(this.nodes[rowIndex].getFile());
            return sticky == null ? "" : sticky.substring(1);
        }
        if (col.equals("status")) {
            return this.nodes[rowIndex].getInformation().getStatusText();
        }
        if (col.equals("action")) {
            return this.commitOptions[rowIndex];
        }
        if (col.equals("path")) {
            return Utils.getRelativePath(this.nodes[rowIndex].getFile());
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (!col.equals("action")) {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.commitOptions[rowIndex] = (CommitOptions)aValue;
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    private void createCommitOptions() {
        boolean excludeNew = CvsModuleConfig.getDefault().getPreferences().getBoolean("excludeNewFiles", false);
        this.commitOptions = new CommitOptions[this.nodes.length];
        block4: for (int i = 0; i < this.nodes.length; ++i) {
            CvsFileNode node = this.nodes[i];
            if (CvsModuleConfig.getDefault().isExcludedFromCommit(node.getFile())) {
                this.commitOptions[i] = CommitOptions.EXCLUDE;
                continue;
            }
            switch (node.getInformation().getStatus()) {
                case 4: {
                    this.commitOptions[i] = excludeNew ? CommitOptions.EXCLUDE : this.getDefaultCommitOptions(node.getFile());
                    continue block4;
                }
                case 256: 
                case 2048: {
                    this.commitOptions[i] = CommitOptions.COMMIT_REMOVE;
                    continue block4;
                }
                default: {
                    this.commitOptions[i] = CommitOptions.COMMIT;
                }
            }
        }
    }

    CommitSettings.CommitFile getCommitFile(int row) {
        return new CommitSettings.CommitFile(this.nodes[row], this.commitOptions[row]);
    }

    private CommitOptions getDefaultCommitOptions(File file) {
        KeywordSubstitutionOptions options = CvsVersioningSystem.getInstance().getDefaultKeywordSubstitution(file);
        return options == KeywordSubstitutionOptions.BINARY ? CommitOptions.ADD_BINARY : CommitOptions.ADD_TEXT;
    }
}

