/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffMainPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DiffExecutor {
    private final Context context;
    private final String contextName;

    public DiffExecutor(Context context, String contextName) {
        this.context = context;
        this.contextName = contextName;
    }

    public DiffExecutor(String contextName) {
        this.contextName = contextName;
        this.context = null;
    }

    public void showRemoteDiff(ExecutorGroup group) {
        this.showDiff(1, group);
    }

    public void showAllDiff(ExecutorGroup group) {
        this.showDiff(2, group);
    }

    public void showLocalDiff(ExecutorGroup group) {
        this.showDiff(0, group);
    }

    public void showDiff(File file, String rev1, String rev2) {
        DiffMainPanel panel = new DiffMainPanel(file, rev1, rev2);
        this.openDiff(panel, null);
    }

    private void showDiff(int type, ExecutorGroup group) {
        VersionsCache.getInstance().purgeVolatileRevisions();
        DiffMainPanel panel = new DiffMainPanel(this.context, type, this.contextName, group);
        this.openDiff(panel, group);
    }

    private void openDiff(final JComponent c, final ExecutorGroup group) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffTopComponent tc = new DiffTopComponent(c);
                tc.setName(NbBundle.getMessage(DiffExecutor.class, (String)"CTL_DiffPanel_Title", (Object)DiffExecutor.this.contextName));
                tc.open();
                tc.requestActive();
                tc.setGroup(group);
            }
        });
    }

    public static File[] getModifiedFiles(Context context, int includeStatus) {
        CvsFileTableModel model = CvsVersioningSystem.getInstance().getFileTableModel(context, includeStatus);
        CvsFileNode[] nodes = model.getNodes();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < nodes.length; ++i) {
            File file = nodes[i].getFile();
            if (CvsModuleConfig.getDefault().isExcludedFromCommit(file)) continue;
            files.add(file);
        }
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] rootFiles = context.getRootFiles();
        for (int i = 0; i < rootFiles.length; ++i) {
            File file = rootFiles[i];
            if (!file.isFile() || (cache.getStatus(file).getStatus() & includeStatus) == 0 || files.contains(file)) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiffTopComponent
    extends TopComponent
    implements DiffSetupSource {
        public DiffTopComponent() {
        }

        public DiffTopComponent(JComponent c) {
            this.setLayout(new BorderLayout());
            c.putClientProperty(TopComponent.class, this);
            this.add(c, "Center");
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_Diff_Top_Component"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_Diff_Top_Component"));
        }

        public UndoRedo getUndoRedo() {
            DiffMainPanel mainPanel = (DiffMainPanel)this.getComponent(0);
            return mainPanel.getUndoRedo();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected void componentClosed() {
            ((DiffMainPanel)this.getComponent(0)).componentClosed();
            super.componentClosed();
        }

        protected String preferredID() {
            return "DiffExecutorTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }

        protected void componentActivated() {
            super.componentActivated();
            DiffMainPanel mainPanel = (DiffMainPanel)this.getComponent(0);
            mainPanel.requestActive();
        }

        @Override
        public Collection<Setup> getSetups() {
            DiffSetupSource mainPanel = (DiffSetupSource)((Object)this.getComponent(0));
            return mainPanel.getSetups();
        }

        @Override
        public String getSetupDisplayName() {
            DiffSetupSource mainPanel = (DiffSetupSource)((Object)this.getComponent(0));
            return mainPanel.getSetupDisplayName();
        }

        public void setGroup(ExecutorGroup group) {
            DiffMainPanel mainPanel = (DiffMainPanel)this.getComponent(0);
            mainPanel.setGroup(group);
        }
    }
}

