/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffStreamSource;
import org.openide.util.NbBundle;

public final class Setup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_CURRENT = "";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String firstRevision;
    private final String secondRevision;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private String title;

    public Setup(File baseFile, int type) {
        String secondTitle;
        String firstTitle;
        String revision;
        this.baseFile = baseFile;
        FileInformation info = CvsVersioningSystem.getInstance().getStatusCache().getStatus(baseFile);
        int status = info.getStatus();
        Entry entry = info.getEntry(baseFile);
        String string = revision = entry != null ? entry.getRevision() : null;
        if (revision != null && revision.charAt(0) == '-') {
            revision = revision.substring(1);
        }
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        if (type == 2 && status == 128) {
            this.firstRevision = REVISION_HEAD;
            firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), revision);
        } else if (status == 4 || status == 4096 || status == 512) {
            this.firstRevision = null;
            firstTitle = loc.getString("MSG_DiffPanel_NoBaseRevision");
        } else {
            this.firstRevision = revision;
            firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), revision);
        }
        if (status == 64) {
            this.secondRevision = REVISION_CURRENT;
            secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalConflict"), revision);
        } else if (status == 4 || status == 4096) {
            this.secondRevision = REVISION_CURRENT;
            secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
        } else if (status == 2048 || status == 256) {
            this.secondRevision = null;
            secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
        } else if (status == 512) {
            this.secondRevision = REVISION_HEAD;
            secondTitle = loc.getString("MSG_DiffPanel_RemoteNew");
        } else if (status == 1024) {
            this.secondRevision = null;
            secondTitle = loc.getString("MSG_DiffPanel_RemoteDeleted");
        } else if (status == 32) {
            this.secondRevision = REVISION_HEAD;
            secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), revision);
        } else if (type == 1) {
            this.secondRevision = REVISION_HEAD;
            secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), revision);
        } else {
            this.secondRevision = REVISION_CURRENT;
            secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalModified"), revision);
        }
        this.firstSource = new DiffStreamSource(baseFile, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(baseFile, this.secondRevision, secondTitle);
        this.title = "<html>" + CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(baseFile, info);
    }

    public Setup(File baseFile, String firstRevision, String secondRevision) {
        this.baseFile = baseFile;
        this.firstRevision = firstRevision;
        this.secondRevision = secondRevision;
        this.firstSource = new DiffStreamSource(baseFile, firstRevision, firstRevision);
        this.secondSource = new DiffStreamSource(baseFile, secondRevision, secondRevision);
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setView(DiffController view) {
        this.view = view;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    public String toString() {
        return this.title;
    }

    static String getDisplayedRevision(File baseFile, String revision) {
        if (revision == REVISION_CURRENT) {
            FileInformation info = CvsVersioningSystem.getInstance().getStatusCache().getStatus(baseFile);
            return NbBundle.getMessage(Setup.class, (String)"MSG_LocalRevision", (Object)info.getEntry(baseFile).getRevision());
        }
        return revision;
    }

    void initSources(ExecutorGroup group) throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init(group);
        }
        if (this.secondSource != null) {
            this.secondSource.init(group);
        }
    }
}

