/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.log;

import java.io.File;
import java.io.IOException;
import javax.swing.JEditorPane;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateCommand;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationBar;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationBarManager;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogExecutor;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class AnnotationsAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] activatedNodes) {
        if (this.visible(activatedNodes)) {
            return "CTL_MenuItem_HideAnnotations";
        }
        return "CTL_MenuItem_Annotations";
    }

    public boolean enable(Node[] nodes) {
        return super.enable(nodes) && this.activatedEditorCookie(nodes) != null;
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(Node[] nodes) {
        if (this.visible(nodes)) {
            JEditorPane pane = this.activatedEditorPane(nodes);
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            EditorCookie ec = this.activatedEditorCookie(nodes);
            if (ec != null) {
                File file = this.activatedFile(nodes);
                CvsVersioningSystem cvss = CvsVersioningSystem.getInstance();
                AdminHandler entries = cvss.getAdminHandler();
                JEditorPane[] panes = ec.getOpenedPanes();
                if (panes == null) {
                    ec.open();
                }
                if ((panes = ec.getOpenedPanes()) == null) {
                    return;
                }
                final JEditorPane currentPane = panes[0];
                AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
                AnnotateCommand annotate = new AnnotateCommand();
                try {
                    Entry entry = entries.getEntry(file);
                    if (entry == null) {
                        return;
                    }
                    String revision = entry.getRevision();
                    annotate.setAnnotateByRevision(revision);
                    File[] cmdFiles = new File[]{file};
                    annotate.setFiles(cmdFiles);
                    ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(AnnotationsAction.class, (String)"BK0001"));
                    AnnotationsExecutor executor = new AnnotationsExecutor(cvss, annotate);
                    executor.addLogOutputListener(ab);
                    group.addExecutor(executor);
                    LogCommand log = new LogCommand();
                    log.setFiles(cmdFiles);
                    log.setNoTags(true);
                    LogExecutor lexecutor = new LogExecutor(cvss, log);
                    lexecutor.addLogOutputListener(ab);
                    group.addExecutor(lexecutor);
                    group.addCancellable(new Cancellable(){

                        public boolean cancel() {
                            AnnotationBarManager.hideAnnotationBar(currentPane);
                            return true;
                        }
                    });
                    group.execute();
                }
                catch (IOException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, NbBundle.getMessage(AnnotationsAction.class, (String)"BK0002", (Object)file));
                    err.notify((Throwable)e);
                }
            }
        }
    }

    public boolean visible(Node[] nodes) {
        JEditorPane currentPane = this.activatedEditorPane(nodes);
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodes) {
        JEditorPane[] panes;
        EditorCookie ec = this.activatedEditorCookie(nodes);
        if (ec != null && (panes = ec.getOpenedPanes()) != null && panes.length > 0) {
            return panes[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodes) {
        if (nodes == null) {
            nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodes.length == 1) {
            Node node = nodes[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodes) {
        Node node;
        DataObject dobj;
        if (nodes.length == 1 && (dobj = (DataObject)(node = nodes[0]).getCookie(DataObject.class)) != null) {
            FileObject fo = dobj.getPrimaryFile();
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }
}

