/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogOutputListener;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class LogExecutor
extends ExecutorSupport {
    private final List listeners = new ArrayList(1);

    public static LogExecutor[] splitCommand(LogCommand cmd, GlobalOptions options) {
        Command[] cmds = new Command[]{};
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage(LogExecutor.class, (String)"MSG_LogExecutor_CmdDisplayName"));
        }
        try {
            cmds = LogExecutor.prepareBasicCommand((BasicCommand)cmd);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        LogExecutor[] executors = new LogExecutor[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            Command command = cmds[i];
            executors[i] = new LogExecutor(CvsVersioningSystem.getInstance(), (LogCommand)command, options);
        }
        return executors;
    }

    public LogExecutor(CvsVersioningSystem cvs, LogCommand cmd) {
        this(cvs, cmd, null);
    }

    public LogExecutor(CvsVersioningSystem cvs, LogCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    protected void commandFinished(ClientRuntime.Result result) {
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        super.fileInfoGenerated(e);
        LogInformation li = (LogInformation)e.getInfoContainer();
        List revisions = li.getRevisionList();
        Iterator rit = revisions.iterator();
        HashMap<String, String> messages = new HashMap<String, String>(revisions.size());
        while (rit.hasNext()) {
            LogInformation.Revision rev = (LogInformation.Revision)rit.next();
            String message = rev.getMessage();
            String revId = rev.getNumber();
            messages.put(revId, message);
        }
        for (LogOutputListener listener : this.listeners) {
            listener.commitMessages(messages);
        }
    }

    public void addLogOutputListener(LogOutputListener listener) {
        this.listeners.add(listener);
    }

    public List getLogEntries() {
        return this.toRefresh;
    }

    protected boolean logCommandOutput() {
        return false;
    }
}

