/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.project;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.ImportExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.ImportPanel;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.AbstractStep;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public final class AddToRepositoryAction
extends NodeAction
implements ChangeListener {
    private static final String RECENT_ROOTS = "addToRepositoryAction.recentRoots";
    private WizardDescriptor wizard;
    private WizardDescriptor.Iterator wizardIterator;
    private RepositoryStep repositoryStep;
    private ImportStep importStep;

    public AddToRepositoryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0006");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length == 1) {
            FileInformation status;
            FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
            File dir = this.lookupImportDirectory(nodes[0]);
            if (dir != null && dir.isDirectory() && ((status = cache.getStatus(dir)).getStatus() & 0xFFFFFFFE) == 0) {
                FileObject fo = FileUtil.toFileObject((File)dir);
                Project p = FileOwnerQuery.getOwner((FileObject)fo);
                if (p == null) {
                    return true;
                }
                FileObject projectDir = p.getProjectDirectory();
                return !FileUtil.isParentOf((FileObject)projectDir, (FileObject)fo);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodes) {
        File importDirectory;
        if (nodes.length == 1 && (importDirectory = this.lookupImportDirectory(nodes[0])) != null) {
            File parent = importDirectory.getParentFile();
            File parent_cvsRoot = new File(parent, "CVS/Root");
            File parent_cvsRepo = new File(parent, "CVS/Repository");
            String cvsRoot = null;
            String cvsRepository = null;
            if (parent_cvsRepo.isFile() && parent_cvsRoot.isFile()) {
                ErrorManager err;
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(parent_cvsRoot));
                    cvsRoot = r.readLine();
                }
                catch (IOException e) {
                    err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0016"));
                    err.notify((Throwable)e);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException alreadyClosed) {}
                    }
                }
                try {
                    r = new BufferedReader(new FileReader(parent_cvsRepo));
                    cvsRepository = r.readLine();
                }
                catch (IOException e) {
                    err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0017"));
                    err.notify((Throwable)e);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException alreadyClosed) {}
                    }
                }
            }
            String prefRoot = cvsRoot != null ? cvsRoot : NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0008");
            String prefModule = cvsRepository != null ? cvsRepository + "/" + importDirectory.getName() : importDirectory.getName();
            this.wizardIterator = this.panelIterator(prefRoot, prefModule, importDirectory.getAbsolutePath());
            this.wizard = new WizardDescriptor(this.wizardIterator);
            this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0015"), NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0014")});
            this.wizard.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            this.wizard.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            this.wizard.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            this.wizard.setTitleFormat(new MessageFormat("{0}"));
            String title = NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0007");
            this.wizard.setTitle(title);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)this.wizard);
            if (result == DialogDescriptor.OK_OPTION) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        AddToRepositoryAction.this.async(importDirectory);
                    }
                });
            }
        }
    }

    private void async(File importDirectory) {
        boolean checkout = this.importStep.getCheckout();
        String logMessage = this.importStep.getMessage();
        String module = this.importStep.getModule();
        String vendorTag = "default_vendor";
        String releaseTag = "default_release";
        String selectedRoot = this.repositoryStep.getCvsRoot();
        String folder = this.importStep.getFolder();
        File dir = new File(folder);
        Utils.insert((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)RECENT_ROOTS, (String)selectedRoot, (int)8);
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0019"));
        try {
            group.progress(NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0020"));
            final Thread thread = Thread.currentThread();
            group.addCancellable(new Cancellable(){

                public boolean cancel() {
                    thread.interrupt();
                    return true;
                }
            });
            this.prepareIgnore(dir);
        }
        catch (IOException e) {
            group.executed();
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0021"));
            err.notify((Throwable)e);
            return;
        }
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        gtx.setCVSRoot(selectedRoot);
        ImportCommand importCommand = new ImportCommand();
        importCommand.setModule(module);
        importCommand.setLogMessage(logMessage);
        importCommand.setVendorTag(vendorTag);
        importCommand.setReleaseTag(releaseTag);
        importCommand.setImportDirectory(importDirectory.getPath());
        new ImportExecutor(importCommand, gtx, checkout, folder, group);
        group.execute();
    }

    public boolean cancel() {
        return true;
    }

    private File lookupImportDirectory(Node node) {
        File importDirectory = null;
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            if (groups.length == 1) {
                FileObject root = groups[0].getRootFolder();
                importDirectory = FileUtil.toFile((FileObject)root);
            } else {
                importDirectory = FileUtil.toFile((FileObject)project.getProjectDirectory());
            }
        } else {
            File f;
            FileObject fo = null;
            Collection fileObjects = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (fileObjects.size() > 0) {
                fo = (FileObject)fileObjects.iterator().next();
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    fo = dataObject.getPrimaryFile();
                }
            }
            if (fo != null && (f = FileUtil.toFile((FileObject)fo)) != null && f.isDirectory()) {
                importDirectory = f;
            }
        }
        return importDirectory;
    }

    private WizardDescriptor.Iterator panelIterator(String root, String module, String folder) {
        this.repositoryStep = new RepositoryStep();
        this.repositoryStep.initPreferedCvsRoot(root);
        this.repositoryStep.addChangeListener(this);
        this.importStep = new ImportStep(module, folder);
        this.importStep.addChangeListener(this);
        final WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this.repositoryStep, this.importStep};
        WizardDescriptor.ArrayIterator ret = new WizardDescriptor.ArrayIterator(panels){

            public WizardDescriptor.Panel current() {
                WizardDescriptor.Panel ret = super.current();
                for (int i = 0; i < panels.length; ++i) {
                    if (panels[i] != ret) continue;
                    AddToRepositoryAction.this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(i));
                }
                return ret;
            }
        };
        return ret;
    }

    private void setErrorMessage(String msg) {
        if (this.wizard != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)msg);
        }
    }

    public void stateChanged(ChangeEvent e) {
        AbstractStep step = (AbstractStep)this.wizardIterator.current();
        this.setErrorMessage(step.getErrorMessage());
    }

    private static String checkInput(ImportPanel importPanel) {
        boolean valid = true;
        File file = new File(importPanel.folderTextField.getText());
        if (!(valid &= file.isDirectory())) {
            return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0022");
        }
        if (!(valid &= !new File(file, "CVS").exists())) {
            return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0023");
        }
        if (!(valid &= importPanel.commentTextArea.getText().trim().length() > 0)) {
            return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0024");
        }
        String module = importPanel.moduleTextField.getText().trim();
        if (!(valid &= module.length() > 0)) {
            return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0025");
        }
        valid &= module.indexOf(" ") == -1;
        if (!(valid &= !".".equals(module.trim()))) {
            return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK0026");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareIgnore(File dir) throws IOException {
        File[] projectMeta = dir.listFiles();
        HashSet<String> ignored = new HashSet<String>();
        for (int i = 0; i < projectMeta.length; ++i) {
            if (Thread.interrupted()) {
                return false;
            }
            File file = projectMeta[i];
            String name = file.getName();
            int sharability = SharabilityQuery.getSharability((File)file);
            if (sharability == 2) {
                if (".cvsignore".equals(name)) continue;
                ignored.add(name);
                continue;
            }
            if (sharability != 3) continue;
            assert (file.isDirectory()) : file;
            this.prepareIgnore(file);
        }
        if (ignored.size() > 0) {
            File cvsIgnore = new File(dir, ".cvsignore");
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(cvsIgnore);
                PrintWriter pw = new PrintWriter(out);
                for (String name : ignored) {
                    pw.println(name);
                }
                pw.close();
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException alreadyClosed) {}
                }
            }
        }
        return true;
    }

    protected boolean asynchronous() {
        return false;
    }

    class ImportStep
    extends AbstractStep
    implements ActionListener {
        private final String module;
        private final String folder;
        private ImportPanel importPanel;

        public ImportStep(String module, String folder) {
            this.module = module;
            this.folder = folder;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ImportStep.class);
        }

        protected JComponent createComponent() {
            this.importPanel = new ImportPanel();
            this.importPanel.moduleTextField.setText(this.module);
            this.importPanel.folderTextField.setText(this.folder);
            DocumentListener validation = new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    String s = AddToRepositoryAction.checkInput(ImportStep.this.importPanel);
                    if (s == null) {
                        ImportStep.this.valid();
                    } else {
                        ImportStep.this.invalid(s);
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                    String s = AddToRepositoryAction.checkInput(ImportStep.this.importPanel);
                    if (s == null) {
                        ImportStep.this.valid();
                    } else {
                        ImportStep.this.invalid(s);
                    }
                }
            };
            this.importPanel.moduleTextField.getDocument().addDocumentListener(validation);
            this.importPanel.commentTextArea.getDocument().addDocumentListener(validation);
            this.importPanel.folderTextField.getDocument().addDocumentListener(validation);
            this.importPanel.folderButton.addActionListener(this);
            this.importPanel.moduleButton.addActionListener(this);
            String s = AddToRepositoryAction.checkInput(this.importPanel);
            if (s == null) {
                this.valid();
            } else {
                this.invalid(s);
            }
            return this.importPanel;
        }

        protected void validateBeforeNext() {
        }

        public boolean getCheckout() {
            return this.importPanel.checkoutCheckBox.isSelected();
        }

        public String getMessage() {
            return this.importPanel.commentTextArea.getText();
        }

        public String getModule() {
            return this.importPanel.moduleTextField.getText();
        }

        public String getFolder() {
            return this.importPanel.folderTextField.getText();
        }

        private File defaultWorkingDirectory() {
            File projectFolder;
            File defaultDir = null;
            String current = this.importPanel.folderTextField.getText();
            if (current != null && !current.trim().equals("")) {
                File currentFile;
                for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
                }
                if (currentFile != null) {
                    defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
                }
            }
            if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
                defaultDir = projectFolder;
            }
            if (defaultDir == null) {
                defaultDir = new File(System.getProperty("user.home"));
            }
            return defaultDir;
        }

        public void actionPerformed(ActionEvent e) {
            CVSRoot root;
            ModuleSelector selector;
            String path;
            if (e.getSource() == this.importPanel.folderButton) {
                File defaultDir = this.defaultWorkingDirectory();
                JFileChooser fileChooser = new JFileChooser(defaultDir);
                fileChooser.setDialogTitle(NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK1017"));
                fileChooser.setMultiSelectionEnabled(false);
                FileFilter[] old = fileChooser.getChoosableFileFilters();
                for (int i = 0; i < old.length; ++i) {
                    FileFilter fileFilter = old[i];
                    fileChooser.removeChoosableFileFilter(fileFilter);
                }
                fileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }

                    public String getDescription() {
                        return NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK1018");
                    }
                });
                fileChooser.setFileSelectionMode(1);
                fileChooser.showDialog(this.importPanel, NbBundle.getMessage(AddToRepositoryAction.class, (String)"BK1019"));
                File f = fileChooser.getSelectedFile();
                if (f != null) {
                    this.importPanel.folderTextField.setText(f.getAbsolutePath());
                }
            } else if (e.getSource() == this.importPanel.moduleButton && (path = (selector = new ModuleSelector()).selectRepositoryPath(root = CVSRoot.parse((String)AddToRepositoryAction.this.repositoryStep.getCvsRoot()))) != null) {
                this.importPanel.moduleTextField.setText(path);
            }
        }
    }
}

