/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergePanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.RTagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MergeBranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_MergeBranch";
    }

    protected int getFileEnabledStatus() {
        return 1208;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    public void performCvsAction(Node[] nodes) {
        Context context = this.getContext(nodes);
        String title = MessageFormat.format(NbBundle.getBundle(MergeBranchAction.class).getString("CTL_MergeBranchDialog_Title"), this.getContextDisplayName(nodes));
        MergePanel settings = new MergePanel(context.getFiles());
        JButton merge = new JButton(NbBundle.getMessage(MergeBranchAction.class, (String)"CTL_MergeBranchDialog_Action_Merge"));
        settings.putClientProperty("OKButton", merge);
        merge.setToolTipText(NbBundle.getMessage(MergeBranchAction.class, (String)"TT_MergeBranchDialog_Action_Merge"));
        JButton cancel = new JButton(NbBundle.getMessage(MergeBranchAction.class, (String)"CTL_MergeBranchDialog_Action_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergeBranchAction.class, (String)"ACSD_MergeBranchDialog_Action_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)settings, title, true, new Object[]{merge, cancel}, (Object)merge, 0, new HelpCtx(MergeBranchAction.class), null);
        descriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergeBranchAction.class, (String)"ACSD_MergeBranchDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != merge) {
            return;
        }
        settings.saveSettings();
        RequestProcessor.getDefault().post((Runnable)new MergeBranchExecutor(context, settings, this.getRunningName(nodes), this.getContextDisplayName(nodes)));
    }

    protected boolean asynchronous() {
        return false;
    }

    private static class MergeBranchExecutor
    implements Runnable {
        private final Context context;
        private final MergePanel settings;
        private final String contextName;
        private String temporaryTag;
        private String name;

        public MergeBranchExecutor(Context context, MergePanel settings, String name, String contextName) {
            this.context = context;
            this.settings = settings;
            this.name = name;
            this.contextName = contextName;
        }

        public void run() {
            final ExecutorGroup group = new ExecutorGroup(this.name);
            if (this.settings.isTaggingAfterMerge()) {
                this.temporaryTag = this.settings.getAfterMergeTagName() + "_tempheadmarker";
                final ExecutorSupport[] tmpTagging = this.tagHeadTemporary();
                group.addExecutors(tmpTagging);
                Runnable cleanup = new Runnable(){

                    public void run() {
                        if (tmpTagging == null || ExecutorSupport.wait(tmpTagging)) {
                            group.addCleanups(MergeBranchExecutor.this.removeTagHeadTemporary());
                        }
                    }
                };
                group.addBarrier(cleanup);
                group.addExecutors(this.update());
                group.addBarrier(null);
                group.addExecutors(this.tag());
            } else {
                group.addExecutors(this.update());
            }
            group.execute();
        }

        private UpdateExecutor[] update() {
            UpdateCommand cmd = new UpdateCommand();
            String headTag = this.temporaryTag != null ? this.temporaryTag : (this.settings.isMergingFromTrunk() ? "HEAD" : (this.settings.isMergingFromBranch() ? this.settings.getBranchName() : this.settings.getEndTagName()));
            GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
            if (this.context.getExclusions().size() > 0) {
                options.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
            }
            if (this.settings.isUsingMergeTag()) {
                cmd.setMergeRevision1(this.settings.getMergeTagName());
                cmd.setMergeRevision2(headTag);
            } else {
                cmd.setMergeRevision1(headTag);
            }
            cmd.setFiles(this.context.getRootFiles());
            cmd.setBuildDirectories(true);
            cmd.setPruneDirectories(true);
            return UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options, this.contextName);
        }

        private RTagExecutor[] tag() {
            RtagCommand cmd = new RtagCommand();
            cmd.setOverrideExistingTag(true);
            cmd.setTagByRevision(this.temporaryTag);
            cmd.setTag(this.settings.getAfterMergeTagName());
            return RTagExecutor.splitCommand(cmd, this.context.getFiles(), null);
        }

        private RTagExecutor[] tagHeadTemporary() {
            RtagCommand cmd = new RtagCommand();
            cmd.setOverrideExistingTag(true);
            cmd.setTagByRevision(this.settings.isMergingFromTrunk() ? "HEAD" : this.settings.getBranchName());
            cmd.setTag(this.temporaryTag);
            return RTagExecutor.splitCommand(cmd, this.context.getFiles(), null);
        }

        private RTagExecutor[] removeTagHeadTemporary() {
            RtagCommand cmd = new RtagCommand();
            cmd.setDeleteTag(true);
            cmd.setTag(this.temporaryTag);
            return RTagExecutor.splitCommand(cmd, this.context.getFiles(), null);
        }
    }
}

