/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class MergePanel
extends JPanel
implements DocumentListener {
    private final File[] roots;
    private JButton browseAfterMergeTag;
    private JButton browseBranch;
    private JButton browseEndTag;
    private JButton browseStartTag;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox cbTagAfterMerge;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JRadioButton rbFromBranchRoot;
    private JRadioButton rbFromTag;
    private JRadioButton rbToBranchHead;
    private JRadioButton rbToHEAD;
    private JRadioButton rbToTag;
    private JTextField tfAfterMergeTagName;
    private JTextField tfBranch;
    private JTextField tfCurrentBranch;
    private JTextField tfEndTag;
    private JTextField tfStartTag;

    public MergePanel(File[] roots) {
        this.roots = roots;
        this.initComponents();
        this.rbFromBranchRoot.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("MergeBranchSettings.mergeFromBranchRoot", true));
        this.rbFromTag.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("MergeBranchSettings.mergeFromTag", false));
        this.rbToHEAD.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("MergeBranchSettings.mergeToHEAD", true));
        this.rbToBranchHead.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("MergeBranchSettings.mergeToBranchHead", false));
        this.rbToTag.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("MergeBranchSettings.mergeToTag", false));
        this.tfEndTag.setText(CvsModuleConfig.getDefault().getPreferences().get("MergeBranchSettings.mergeToTagName", ""));
        this.cbTagAfterMerge.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("MergeBranchSettings.tagAfterMerge", false));
        this.tfAfterMergeTagName.setText(CvsModuleConfig.getDefault().getPreferences().get("MergeBranchSettings.afterMergeTagName", NbBundle.getMessage(MergePanel.class, (String)"BK1003")));
        this.tfBranch.setText(CvsModuleConfig.getDefault().getPreferences().get("MergeBranchSettings.branchName", NbBundle.getMessage(MergePanel.class, (String)"BK1001")));
        this.tfBranch.getDocument().addDocumentListener(this);
        this.tfStartTag.setText(CvsModuleConfig.getDefault().getPreferences().get("MergeBranchSettings.mergeStartTag", NbBundle.getMessage(MergePanel.class, (String)"BK1002")));
        this.tfCurrentBranch.setText(this.detectCurrentWorkingBranch());
        this.refreshComponents();
        this.tfAfterMergeTagName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                MergePanel.this.onTagNameChange(MergePanel.this.tfAfterMergeTagName.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                MergePanel.this.onTagNameChange(MergePanel.this.tfAfterMergeTagName.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                MergePanel.this.onTagNameChange(MergePanel.this.tfAfterMergeTagName.getText());
            }
        });
        this.cbTagAfterMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergePanel.this.onTagNameChange(MergePanel.this.tfAfterMergeTagName.getText());
            }
        });
    }

    public void saveSettings() {
        CvsModuleConfig.getDefault().getPreferences().putBoolean("MergeBranchSettings.mergeFromBranchRoot", this.rbFromBranchRoot.isSelected());
        CvsModuleConfig.getDefault().getPreferences().putBoolean("MergeBranchSettings.mergeFromTag", this.rbFromTag.isSelected());
        CvsModuleConfig.getDefault().getPreferences().putBoolean("MergeBranchSettings.mergeToHEAD", this.rbToHEAD.isSelected());
        CvsModuleConfig.getDefault().getPreferences().putBoolean("MergeBranchSettings.mergeToBranchHead", this.rbToBranchHead.isSelected());
        CvsModuleConfig.getDefault().getPreferences().putBoolean("MergeBranchSettings.mergeToTag", this.rbToTag.isSelected());
        CvsModuleConfig.getDefault().getPreferences().put("MergeBranchSettings.mergeToTagName", this.tfEndTag.getText());
        CvsModuleConfig.getDefault().getPreferences().putBoolean("MergeBranchSettings.tagAfterMerge", this.cbTagAfterMerge.isSelected());
        CvsModuleConfig.getDefault().getPreferences().put("MergeBranchSettings.afterMergeTagName", this.tfAfterMergeTagName.getText());
        CvsModuleConfig.getDefault().getPreferences().put("MergeBranchSettings.branchName", this.tfBranch.getText());
        CvsModuleConfig.getDefault().getPreferences().put("MergeBranchSettings.mergeStartTag", this.tfStartTag.getText());
    }

    private void refreshComponents() {
        this.tfStartTag.setEnabled(this.rbFromTag.isSelected());
        this.browseStartTag.setEnabled(this.rbFromTag.isSelected());
        this.tfBranch.setEnabled(this.rbToBranchHead.isSelected());
        this.browseBranch.setEnabled(this.rbToBranchHead.isSelected());
        this.tfEndTag.setEnabled(this.rbToTag.isSelected());
        this.browseEndTag.setEnabled(this.rbToTag.isSelected());
        this.cbTagAfterMerge.setEnabled(!this.rbToTag.isSelected());
        this.tfAfterMergeTagName.setEnabled(this.cbTagAfterMerge.isSelected());
        this.browseAfterMergeTag.setEnabled(this.cbTagAfterMerge.isSelected());
        String format = this.isMergingFromTrunk() ? ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Trunk") : ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Branch");
        this.cbTagAfterMerge.setText(MessageFormat.format(format, this.tfBranch.getText()));
    }

    public void changedUpdate(DocumentEvent e) {
        this.refreshComponents();
    }

    public void insertUpdate(DocumentEvent e) {
        this.refreshComponents();
    }

    public void removeUpdate(DocumentEvent e) {
        this.refreshComponents();
    }

    public boolean isMergingFromTrunk() {
        return this.rbToHEAD.isSelected();
    }

    public String getBranchName() {
        return this.tfBranch.getText();
    }

    private void onTagNameChange(String text) {
        JButton dd = (JButton)this.getClientProperty("OKButton");
        if (dd != null) {
            dd.setEnabled(!this.cbTagAfterMerge.isSelected() || Utils.isTagValid(text));
        }
    }

    private String browseBranches() {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector selector = new BranchSelector();
                return selector.selectTag(this.roots[i]);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }

    private String detectCurrentWorkingBranch() {
        String sticky;
        File root = this.roots[0];
        if (root.isFile()) {
            Entry entry = null;
            try {
                entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(root);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (entry != null) {
                String sticky2 = entry.getStickyInformation();
                if (sticky2 != null) {
                    return sticky2;
                }
            } else {
                root = root.getParentFile();
            }
        }
        if (root.isDirectory() && (sticky = CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(root)) != null && sticky.startsWith("T")) {
            return sticky.substring(1);
        }
        return NbBundle.getBundle(MergePanel.class).getString("MSG_MergeBranchForm_Trunk");
    }

    public boolean isTaggingAfterMerge() {
        return this.cbTagAfterMerge.isSelected() && !this.rbToTag.isSelected();
    }

    public String getAfterMergeTagName() {
        return this.tfAfterMergeTagName.getText();
    }

    public boolean isMergingFromBranch() {
        return this.rbToBranchHead.isSelected();
    }

    public String getEndTagName() {
        return this.tfEndTag.getText();
    }

    public boolean isUsingMergeTag() {
        return this.rbFromTag.isSelected();
    }

    public String getMergeTagName() {
        return this.tfStartTag.getText();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.tfCurrentBranch = new JTextField();
        this.jLabel2 = new JLabel();
        this.rbFromBranchRoot = new JRadioButton();
        this.rbFromTag = new JRadioButton();
        this.tfStartTag = new JTextField();
        this.browseStartTag = new JButton();
        this.jLabel3 = new JLabel();
        this.rbToHEAD = new JRadioButton();
        this.rbToBranchHead = new JRadioButton();
        this.rbToTag = new JRadioButton();
        this.tfEndTag = new JTextField();
        this.browseEndTag = new JButton();
        this.browseBranch = new JButton();
        this.tfBranch = new JTextField();
        this.cbTagAfterMerge = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.tfAfterMergeTagName = new JTextField();
        this.browseAfterMergeTag = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.jLabel1.text"));
        this.tfCurrentBranch.setEditable(false);
        this.tfCurrentBranch.setText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.tfCurrentBranch.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.jLabel2.text"));
        this.buttonGroup1.add(this.rbFromBranchRoot);
        Mnemonics.setLocalizedText((AbstractButton)this.rbFromBranchRoot, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.rbFromBranchRoot.text"));
        this.rbFromBranchRoot.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbFromBranchRoot.setMargin(new Insets(0, 0, 0, 0));
        this.rbFromBranchRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.rbFromBranchRootActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbFromTag);
        Mnemonics.setLocalizedText((AbstractButton)this.rbFromTag, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.rbFromTag.text"));
        this.rbFromTag.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbFromTag.setMargin(new Insets(0, 0, 0, 0));
        this.rbFromTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.rbFromTagActionPerformed(evt);
            }
        });
        this.tfStartTag.setText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.tfStartTag.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseStartTag, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.browseStartTag.text"));
        this.browseStartTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.browseStartTagActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.jLabel3.text"));
        this.buttonGroup2.add(this.rbToHEAD);
        Mnemonics.setLocalizedText((AbstractButton)this.rbToHEAD, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.rbToHEAD.text"));
        this.rbToHEAD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbToHEAD.setMargin(new Insets(0, 0, 0, 0));
        this.rbToHEAD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.rbToHEADActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.rbToBranchHead);
        Mnemonics.setLocalizedText((AbstractButton)this.rbToBranchHead, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.rbToBranchHead.text"));
        this.rbToBranchHead.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbToBranchHead.setMargin(new Insets(0, 0, 0, 0));
        this.rbToBranchHead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.rbToBranchHeadActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.rbToTag);
        Mnemonics.setLocalizedText((AbstractButton)this.rbToTag, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.rbToTag.text"));
        this.rbToTag.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbToTag.setMargin(new Insets(0, 0, 0, 0));
        this.rbToTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.rbToTagActionPerformed(evt);
            }
        });
        this.tfEndTag.setText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.tfEndTag.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseEndTag, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.browseEndTag.text"));
        this.browseEndTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.browseEndTagActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browseBranch, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.browseBranch.text"));
        this.browseBranch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.browseBranchActionPerformed(evt);
            }
        });
        this.tfBranch.setText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.tfBranch.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbTagAfterMerge, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.cbTagAfterMerge.text"));
        this.cbTagAfterMerge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbTagAfterMerge.setMargin(new Insets(0, 0, 0, 0));
        this.cbTagAfterMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.cbTagAfterMergeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.jLabel4.text"));
        this.tfAfterMergeTagName.setText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.tfAfterMergeTagName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseAfterMergeTag, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.browseAfterMergeTag.text"));
        this.browseAfterMergeTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.browseAfterMergeTagActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.tfAfterMergeTagName, -1, 289, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseAfterMergeTag).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.tfCurrentBranch, -1, 178, Short.MAX_VALUE)).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.rbFromTag).addPreferredGap(0).add((Component)this.tfStartTag, -1, 257, Short.MAX_VALUE)).add((Component)this.rbFromBranchRoot)))).addPreferredGap(0).add((Component)this.browseStartTag).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addContainerGap(434, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rbToHEAD).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rbToTag).add((Component)this.rbToBranchHead)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.tfEndTag, -1, 257, Short.MAX_VALUE).add(2, (Component)this.tfBranch, -1, 257, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.browseBranch).add((Component)this.browseEndTag)).addContainerGap()))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbTagAfterMerge).addContainerGap(290, Short.MAX_VALUE)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.tfCurrentBranch, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.rbFromBranchRoot).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rbFromTag).add((Component)this.tfStartTag, -2, -1, -2).add((Component)this.browseStartTag)).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.rbToHEAD).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rbToBranchHead).add((Component)this.tfBranch, -2, -1, -2).add((Component)this.browseBranch)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rbToTag).add((Component)this.tfEndTag, -2, -1, -2).add((Component)this.browseEndTag)).addPreferredGap(0).add((Component)this.cbTagAfterMerge).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.tfAfterMergeTagName, -2, -1, -2).add((Component)this.browseAfterMergeTag)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cbTagAfterMergeActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void rbToTagActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void rbToBranchHeadActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void rbToHEADActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void rbFromBranchRootActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void rbFromTagActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void browseAfterMergeTagActionPerformed(ActionEvent evt) {
        String tag = this.browseBranches();
        if (tag != null) {
            this.tfAfterMergeTagName.setText(tag);
        }
    }

    private void browseEndTagActionPerformed(ActionEvent evt) {
        String tag = this.browseBranches();
        if (tag != null) {
            this.tfEndTag.setText(tag);
        }
    }

    private void browseBranchActionPerformed(ActionEvent evt) {
        String tag = this.browseBranches();
        if (tag != null) {
            this.tfBranch.setText(tag);
        }
    }

    private void browseStartTagActionPerformed(ActionEvent evt) {
        String tag = this.browseBranches();
        if (tag != null) {
            this.tfStartTag.setText(tag);
        }
    }
}

