/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class TagExecutor
extends ExecutorSupport {
    public static TagExecutor[] splitCommand(TagCommand cmd, CvsVersioningSystem cvs, GlobalOptions options) {
        Command[] cmds = new Command[]{};
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage(TagExecutor.class, (String)"MSG_TagExecutor_CmdDisplayName"));
        }
        try {
            cmds = TagExecutor.prepareBasicCommand((BasicCommand)cmd);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        TagExecutor[] executors = new TagExecutor[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            Command command = cmds[i];
            executors[i] = new TagExecutor(cvs, (TagCommand)command, options);
        }
        return executors;
    }

    private TagExecutor(CvsVersioningSystem cvs, TagCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        HashSet<File> parents = new HashSet<File>();
        for (DefaultFileInfoContainer info : this.toRefresh) {
            File file = info.getFile();
            this.cache.refreshCached(file, 0);
            parents.add(file.getParentFile());
        }
        this.toRefresh.clear();
        for (File dir : parents) {
            this.cache.refreshCached(dir, 0);
        }
    }
}

