/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;

public class TagSettings
extends JPanel
implements DocumentListener {
    private final File[] roots;
    private JCheckBox cbCheckModified;
    private JCheckBox cbDeleteTag;
    private JCheckBox cbMoveTag;
    private JButton jButton1;
    private JLabel nameLabel;
    private JTextField tfName;

    public TagSettings(File[] roots) {
        this.roots = roots;
        this.initComponents();
        this.tfName.getDocument().addDocumentListener(this);
    }

    void refreshComponents() {
        this.cbMoveTag.setEnabled(!this.cbDeleteTag.isSelected());
        this.cbDeleteTag.setEnabled(!this.cbMoveTag.isSelected());
        this.cbCheckModified.setEnabled(!this.cbDeleteTag.isSelected());
        JButton okButton = (JButton)this.getClientProperty("OKButton");
        if (okButton != null) {
            okButton.setEnabled(Utils.isTagValid(this.tfName.getText()));
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.refreshComponents();
    }

    public void removeUpdate(DocumentEvent e) {
        this.refreshComponents();
    }

    public void changedUpdate(DocumentEvent e) {
        this.refreshComponents();
    }

    public void setCommand(TagCommand cmd) {
        this.cbMoveTag.setSelected(cmd.isOverrideExistingTag());
        this.cbCheckModified.setSelected(cmd.isCheckThatUnmodified());
        this.cbDeleteTag.setSelected(cmd.isDeleteTag());
        this.tfName.setText(cmd.getTag());
    }

    public void updateCommand(TagCommand cmd) {
        cmd.setOverrideExistingTag(this.cbMoveTag.isSelected());
        cmd.setCheckThatUnmodified(this.cbCheckModified.isSelected());
        cmd.setDeleteTag(this.cbDeleteTag.isSelected());
        cmd.setTag(this.tfName.getText());
    }

    private void initComponents() {
        this.cbCheckModified = new JCheckBox();
        this.cbMoveTag = new JCheckBox();
        this.nameLabel = new JLabel();
        this.tfName = new JTextField();
        this.jButton1 = new JButton();
        this.cbDeleteTag = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.cbCheckModified, (String)bundle.getString("CTL_TagForm_EnsureUptodate"));
        this.cbCheckModified.setToolTipText(bundle.getString("TT_TagForm_EnsureUptodate"));
        this.cbCheckModified.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagSettings.this.cbCheckModifiedActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMoveTag, (String)bundle.getString("CTL_TagForm_MoveExisting"));
        this.cbMoveTag.setToolTipText(bundle.getString("TT_TagForm_MoveExisting"));
        this.cbMoveTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagSettings.this.cbMoveTagActionPerformed(evt);
            }
        });
        this.nameLabel.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)bundle.getString("CTL_TagForm_TagName"));
        this.tfName.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)bundle.getString("CTL_BrowseTag"));
        this.jButton1.setToolTipText(bundle.getString("TT_BrowseTag"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagSettings.this.onBrowseTag(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbDeleteTag, (String)bundle.getString("CTL_TagForm_DeleteExisting"));
        this.cbDeleteTag.setToolTipText(bundle.getString("TT_TagForm_DeleteExisting"));
        this.cbDeleteTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagSettings.this.cbDeleteTagActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbMoveTag, -1, 195, Short.MAX_VALUE).add(159, 159, 159)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.tfName, -1, 212, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbCheckModified, -1, -1, Short.MAX_VALUE).add(159, 159, 159)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbDeleteTag, -1, 195, Short.MAX_VALUE).add(159, 159, 159)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.jButton1).add((Component)this.tfName, -2, -1, -2)).addPreferredGap(0).add((Component)this.cbCheckModified, -2, 23, -2).addPreferredGap(0).add((Component)this.cbMoveTag).addPreferredGap(0).add((Component)this.cbDeleteTag)));
    }

    private void cbDeleteTagActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void cbMoveTagActionPerformed(ActionEvent evt) {
        this.refreshComponents();
    }

    private void onBrowseTag(ActionEvent evt) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector selector = new BranchSelector();
                String tag = selector.selectTag(this.roots[i]);
                if (tag != null) {
                    this.tfName.setText(tag);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    private void cbCheckModifiedActionPerformed(ActionEvent evt) {
    }
}

