/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GetCleanAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_GetClean";
    }

    protected boolean enable(Node[] nodes) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodes), 6612).getNodes().length > 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(final Node[] nodes) {
        if (!GetCleanAction.confirmed(null, null)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                GetCleanAction.this.revertModifications(nodes);
            }
        });
    }

    private static boolean confirmed(File file, String revision) {
        String message = file == null || revision == null ? NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Prompt") : NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Prompt2", (Object)file.getName(), (Object)revision);
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)message, NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Title"), 0, 2, null, null);
        Object option = DialogDisplayer.getDefault().notify(descriptor);
        return option == NotifyDescriptor.YES_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertModifications(Node[] nodes) {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Progress"));
        try {
            int i;
            group.progress(NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_ProgressPrepare"));
            FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
            File[] files = cache.listFiles(this.getContext(nodes), 2512);
            for (i = 0; i < files.length; ++i) {
                File file = files[i];
                GetCleanAction.rollback(file, "*", group);
            }
            for (i = 0; i < files.length; ++i) {
                GetCleanAction.refresh(files[i]);
            }
        }
        finally {
            group.executed();
        }
    }

    public static void rollback(File file, String revision) {
        if (!GetCleanAction.confirmed(file, revision)) {
            return;
        }
        GetCleanAction.rollback(file, revision, null);
        GetCleanAction.refresh(file);
    }

    private static void refresh(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            fo.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rollback(File file, String revision, ExecutorGroup group) {
        block27: {
            FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
            AdminHandler ah = CvsVersioningSystem.getInstance().getAdminHandler();
            Entry entry = null;
            try {
                entry = ah.getEntry(file);
            }
            catch (IOException e) {
                // empty catch block
            }
            if ((entry == null || entry.isNewUserFile()) && revision.equals("*")) {
                GetCleanAction.backup(file, entry);
                file.delete();
                return;
            }
            try {
                File cleanFile = VersionsCache.getInstance().getRemoteFile(file, revision, group);
                if (cleanFile != null) {
                    FileObject target;
                    GetCleanAction.backup(file, entry);
                    if (!file.exists()) {
                        File dir = file.getParentFile();
                        FileObject folder = Utils.mkfolders(dir);
                        target = folder.createData(file.getName());
                    } else {
                        target = FileUtil.toFileObject((File)file);
                    }
                    FileInputStream in = null;
                    OutputStream out = null;
                    FileLock lock = null;
                    try {
                        in = new FileInputStream(cleanFile);
                        lock = target.lock();
                        out = target.getOutputStream(lock);
                        GetCleanAction.copyStream(in, out);
                    }
                    finally {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException alreadyClosed) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException alreadyClosed) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                    if (entry != null && entry.isUserFileToBeRemoved()) {
                        entry.setRevision(entry.getRevision().substring(1));
                        ah.setEntry(file, entry);
                    }
                    cache.refresh(file, revision == "*" ? 65536 : 0);
                    break block27;
                }
                if (group.isCancelled()) {
                    return;
                }
                Logger.getLogger(GetCleanAction.class.getName()).severe("Unable to revert changes in " + file.getName() + "; checkout failed");
            }
            catch (Exception e) {
                if (e.getCause() instanceof InterruptedException) break block27;
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int n;
        while ((n = in.read(buffer, 0, 4096)) >= 0) {
            out.write(buffer, 0, n);
        }
        return;
    }

    private static void backup(File file, Entry entry) {
        if (!file.isFile()) {
            return;
        }
        try {
            File backup = entry != null ? new File(file.getParentFile(), ".#" + file.getName() + "." + entry.getRevision()) : new File(file.getParentFile(), ".#" + file.getName() + "." + "LOCAL");
            FileUtils.copyFile((File)file, (File)backup);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

