/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffStreamSource;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffResultsView
implements AncestorListener,
PropertyChangeListener {
    private final SearchHistoryPanel parent;
    private DiffTreeTable treeView;
    private JSplitPane diffView;
    private ShowDiffTask currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    private DiffView currentDiff;
    private int currentDifferenceIndex;
    private int currentIndex;
    private boolean dividerSet;
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel parent, List results) {
        this.parent = parent;
        this.treeView = new DiffTreeTable();
        this.treeView.setResults(results);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            final Node[] nodes = (Node[])evt.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodes.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodes.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    if (DiffResultsView.this.treeView.getSelection().length == 0) {
                        return;
                    }
                    SearchHistoryPanel.ResultsContainer container1 = (SearchHistoryPanel.ResultsContainer)nodes[0].getLookup().lookup(SearchHistoryPanel.ResultsContainer.class);
                    SearchHistoryPanel.DispRevision r1 = (SearchHistoryPanel.DispRevision)nodes[0].getLookup().lookup(SearchHistoryPanel.DispRevision.class);
                    try {
                        if (r1 == null || !r1.isBranchRoot()) {
                            DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                            if (nodes.length == 1) {
                                if (container1 != null) {
                                    DiffResultsView.this.showContainerDiff(container1, DiffResultsView.this.onSelectionshowLastDifference);
                                } else if (r1 != null) {
                                    DiffResultsView.this.showRevisionDiff(r1, DiffResultsView.this.onSelectionshowLastDifference);
                                }
                            } else if (nodes.length == 2) {
                                String revision2;
                                SearchHistoryPanel.DispRevision r2 = (SearchHistoryPanel.DispRevision)nodes[1].getLookup().lookup(SearchHistoryPanel.DispRevision.class);
                                if (r2.isBranchRoot()) {
                                    throw new Exception();
                                }
                                if (r2.getRevision().getLogInfoHeader() != r1.getRevision().getLogInfoHeader()) {
                                    throw new Exception();
                                }
                                String revision1 = r1.getRevision().getNumber();
                                if (SearchHistoryPanel.compareRevisions(revision1, revision2 = r2.getRevision().getNumber()) == 1) {
                                    revision2 = r1.getRevision().getNumber();
                                    revision1 = r2.getRevision().getNumber();
                                }
                                DiffResultsView.this.showDiff(r1.getRevision().getLogInfoHeader(), revision1, revision2, false);
                            }
                        } else {
                            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        }
                    }
                    catch (Exception e) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void showDiffError(String s) {
        this.setBottomComponent((Component)new NoContentPanel(s));
    }

    private void setBottomComponent(Component component) {
        int dl = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiff(LogInformation header, String revision1, String revision2, boolean showLastDifference) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            this.currentTask = new ShowDiffTask(header, revision1, revision2, showLastDifference);
            this.currentShowDiffTask = RequestProcessor.getDefault().create((Runnable)this.currentTask);
            this.currentShowDiffTask.schedule(0);
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    private void setDiffIndex(int idx, boolean showLastDifference) {
        this.currentIndex = idx;
        this.onSelectionshowLastDifference = showLastDifference;
        this.treeView.setSelection(idx);
    }

    private void showRevisionDiff(SearchHistoryPanel.DispRevision rev, boolean showLastDifference) {
        String revision1;
        String revision2 = rev.getRevision().getNumber();
        if (revision2 == "") {
            SearchHistoryPanel.ResultsContainer container = this.findParent(rev);
            SearchHistoryPanel.DispRevision newest = container.getRevisions().get(1);
            revision1 = newest.getRevision().getNumber();
        } else {
            revision1 = Utils.previousRevision(revision2);
        }
        this.showDiff(rev.getRevision().getLogInfoHeader(), revision1, revision2, showLastDifference);
    }

    private SearchHistoryPanel.ResultsContainer findParent(SearchHistoryPanel.DispRevision rev) {
        List results = this.parent.getDispResults();
        for (Object o : results) {
            SearchHistoryPanel.ResultsContainer container;
            if (!(o instanceof SearchHistoryPanel.ResultsContainer) || !(container = (SearchHistoryPanel.ResultsContainer)o).getRevisions().contains(rev)) continue;
            return container;
        }
        return null;
    }

    private void showContainerDiff(SearchHistoryPanel.ResultsContainer container, boolean showLastDifference) {
        List<SearchHistoryPanel.DispRevision> revs = container.getRevisions();
        SearchHistoryPanel.DispRevision newest = revs.get(1);
        this.showDiff(newest.getRevision().getLogInfoHeader(), container.getEldestRevision(), newest.getRevision().getNumber(), showLastDifference);
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(SearchHistoryPanel.DispRevision revision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(revision);
    }

    void select(SearchHistoryPanel.ResultsContainer container) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(container);
    }

    List<Object> getSelection() {
        Node[] nodes = ExplorerManager.find((Component)((Object)this.treeView)).getSelectedNodes();
        ArrayList<Object> selection = new ArrayList<Object>(nodes.length);
        for (Node node : nodes) {
            RevisionNode rnode = (RevisionNode)node;
            if (rnode.getContainer() != null) {
                selection.add(rnode.getContainer());
                continue;
            }
            selection.add(rnode.getDispRevision());
        }
        return selection;
    }

    JComponent getCurrentDiffComponent() {
        return (JComponent)(this.currentDiff == null ? null : this.currentDiff.getComponent());
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    implements Runnable,
    Cancellable {
        private final LogInformation header;
        private final String revision1;
        private final String revision2;
        private boolean showLastDifference;
        private volatile boolean cancelled;
        private Thread thread;

        public ShowDiffTask(LogInformation header, String revision1, String revision2, boolean showLastDifference) {
            this.header = header;
            this.revision1 = revision1;
            this.revision2 = revision2;
            this.showLastDifference = showLastDifference;
        }

        public void run() {
            DiffResultsView.this.parent.getUndoRedo().setDiffView(null);
            this.thread = Thread.currentThread();
            final Diff diff = Diff.getDefault();
            final DiffStreamSource s1 = new DiffStreamSource(this.header.getFile(), this.revision1, this.revision1 == "" ? NbBundle.getMessage(DiffResultsView.class, (String)"LBL_DiffPanel_LocalCopy") : this.revision1);
            final DiffStreamSource s2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2 == "" ? NbBundle.getMessage(DiffResultsView.class, (String)"LBL_DiffPanel_LocalCopy") : this.revision2);
            s1.getMIMEType();
            if (this.cancelled) {
                return;
            }
            s2.getMIMEType();
            if (this.cancelled) {
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.cancelled) {
                            return;
                        }
                        DiffView view = diff.createDiff((StreamSource)s1, (StreamSource)s2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = view;
                            DiffResultsView.this.parent.getUndoRedo().setDiffView((JComponent)DiffResultsView.this.currentDiff.getComponent());
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getComponent());
                            if (DiffResultsView.this.currentDiff.getDifferenceCount() > 0) {
                                DiffResultsView.this.currentDifferenceIndex = ShowDiffTask.this.showLastDifference ? DiffResultsView.this.currentDiff.getDifferenceCount() - 1 : 0;
                                DiffResultsView.this.currentDiff.setCurrentDifference(DiffResultsView.this.currentDifferenceIndex);
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            });
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            return true;
        }
    }
}

