/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.ui.history.TooltipWindow;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends TreeTableView
implements MouseListener,
MouseMotionListener {
    private RevisionsRootNode rootNode;
    private List results;

    public DiffTreeTable() {
        this.treeTable.setShowHorizontalLines(true);
        this.treeTable.setShowVerticalLines(false);
        this.setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.tree.setCellRenderer(renderer);
        this.treeTable.addMouseListener(this);
        this.treeTable.addMouseMotionListener(this);
    }

    private SearchHistoryPanel.DispRevision getRevisionWithTagsAt(Point p) {
        SearchHistoryPanel.DispRevision drev = this.getRevisionWithPropertyAt(p, "tagsRevision");
        if (drev != null && drev.getBranches() != null && drev.getBranches().size() + drev.getTags().size() > 1) {
            return drev;
        }
        return null;
    }

    private SearchHistoryPanel.DispRevision getRevisionWithPropertyAt(Point p, String property) {
        int row = this.treeTable.rowAtPoint(p);
        int column = this.treeTable.columnAtPoint(p);
        if (row == -1 || column == -1) {
            return null;
        }
        Object o = this.treeTable.getValueAt(row, column);
        if (o instanceof Node.Property) {
            Node.Property tags = (Node.Property)o;
            return (SearchHistoryPanel.DispRevision)tags.getValue(property);
        }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
        Window w;
        Point p = e.getPoint();
        SearchHistoryPanel.DispRevision drev = this.getRevisionWithTagsAt(p);
        if (drev != null) {
            w = SwingUtilities.windowForComponent(this.treeTable);
            SwingUtilities.convertPointToScreen(p, this.treeTable);
            p.x += 10;
            p.y += 10;
            SummaryView.showAllTags(w, p, drev);
        }
        if ((drev = this.getRevisionWithPropertyAt(p, "messageRevision")) != null) {
            w = SwingUtilities.windowForComponent(this.treeTable);
            SwingUtilities.convertPointToScreen(p, this.treeTable);
            if ((p.x -= 150) < 0) {
                p.x = 10;
            }
            p.y += this.treeTable.getRowHeight() * 3 / 2;
            this.showMessage(w, p, drev);
        }
    }

    private void showMessage(Window w, Point p, SearchHistoryPanel.DispRevision drev) {
        final JTextPane tp = new JTextPane();
        tp.setBackground(SummaryView.darker(UIManager.getColor("List.background")));
        tp.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 0));
        tp.setEditable(false);
        Style headerStyle = tp.addStyle("headerStyle", null);
        StyleConstants.setBold(headerStyle, true);
        Document doc = tp.getDocument();
        try {
            doc.insertString(doc.getLength(), NbBundle.getMessage(DiffTreeTable.class, (String)"CTL_MessageWindow_Title") + "\n\n", headerStyle);
            doc.insertString(doc.getLength(), drev.getRevision().getMessage() + "\n", null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(DiffTreeTable.class.getName()).log(Level.WARNING, "Internal error creating commit message popup", e);
        }
        Dimension dim = tp.getPreferredSize();
        tp.setPreferredSize(new Dimension(dim.width * 7 / 6, dim.height));
        JScrollPane jsp = new JScrollPane(tp);
        jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        TooltipWindow ttw = new TooltipWindow(w, jsp);
        ttw.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                tp.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        ttw.show(p);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getRevisionWithTagsAt(e.getPoint()) != null || this.getRevisionWithPropertyAt(e.getPoint(), "messageRevision") != null) {
            this.treeTable.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.treeTable.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void setupColumns() {
        Node.Property[] columns;
        ResourceBundle loc = NbBundle.getBundle(DiffTreeTable.class);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
            columns = new Node.Property[6];
            columns[4] = new ColumnDescriptor("tags", List.class, loc.getString("LBL_DiffTree_Column_Tags"), loc.getString("LBL_DiffTree_Column_Tags_Desc"));
            columns[5] = new ColumnDescriptor("message", String.class, loc.getString("LBL_DiffTree_Column_Message"), loc.getString("LBL_DiffTree_Column_Message_Desc"));
        } else {
            columns = new Node.Property[5];
            columns[4] = new ColumnDescriptor("message", String.class, loc.getString("LBL_DiffTree_Column_Message"), loc.getString("LBL_DiffTree_Column_Message_Desc"));
        }
        columns[0] = new ColumnDescriptor("name", String.class, "", "");
        columns[0].setValue("TreeColumnTTV", (Object)Boolean.TRUE);
        columns[1] = new ColumnDescriptor("location", String.class, loc.getString("LBL_DiffTree_Column_Location"), loc.getString("LBL_DiffTree_Column_Location_Desc"));
        columns[2] = new ColumnDescriptor("date", String.class, loc.getString("LBL_DiffTree_Column_Time"), loc.getString("LBL_DiffTree_Column_Time_Desc"));
        columns[3] = new ColumnDescriptor("username", String.class, loc.getString("LBL_DiffTree_Column_Username"), loc.getString("LBL_DiffTree_Column_Username_Desc"));
        this.setProperties(columns);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int width = DiffTreeTable.this.getWidth();
                if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
                    if (DiffTreeTable.this.treeTable.getColumnModel().getColumnCount() != 6) {
                        return;
                    }
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(width * 15 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(width * 15 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(5).setPreferredWidth(width * 40 / 100);
                } else {
                    if (DiffTreeTable.this.treeTable.getColumnModel().getColumnCount() != 5) {
                        return;
                    }
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(width * 20 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(width * 40 / 100);
                }
            }
        });
    }

    void setSelection(int idx) {
        this.treeTable.getSelectionModel().setValueIsAdjusting(false);
        this.treeTable.scrollRectToVisible(this.treeTable.getCellRect(idx, 1, true));
        this.treeTable.getSelectionModel().setSelectionInterval(idx, idx);
    }

    void setSelection(SearchHistoryPanel.ResultsContainer container) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, container);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void setSelection(SearchHistoryPanel.DispRevision revision) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, revision);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Node getNode(Node node, Object obj) {
        Object object = node.getLookup().lookup(obj.getClass());
        if (obj.equals(object)) {
            return node;
        }
        Enumeration children = node.getChildren().nodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Node result = this.getNode(child, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int[] getSelection() {
        return this.treeTable.getSelectedRows();
    }

    public int getRowCount() {
        return this.treeTable.getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        em.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List results) {
        this.results = results;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        if (em != null) {
            em.setRootContext((Node)this.rootNode);
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object key) {
            RevisionNode node = key instanceof SearchHistoryPanel.ResultsContainer ? new RevisionNode((SearchHistoryPanel.ResultsContainer)key) : new RevisionNode((SearchHistoryPanel.DispRevision)key);
            return new Node[]{node};
        }
    }
}

