/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ViewRevisionAction
extends AbstractAction
implements Runnable {
    private final VCSContext ctx;
    private ViewRevisionPanel settings;

    public ViewRevisionAction(VCSContext ctx) {
        this(Utils.getActionName(ViewRevisionAction.class, (String)"CTL_MenuItem_ViewRevision", (VCSContext)ctx), ctx);
    }

    public ViewRevisionAction(String name, VCSContext ctx) {
        super(name);
        this.ctx = ctx;
    }

    public boolean isEnabled() {
        return this.ctx.getRootFiles().size() > 0;
    }

    public void actionPerformed(ActionEvent e) {
        String title = NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Title", (Object)Utils.getContextDisplayName((VCSContext)this.ctx));
        this.settings = new ViewRevisionPanel(this.ctx);
        JButton view = new JButton(NbBundle.getMessage(ViewRevisionAction.class, (String)"CTL_ViewRevisionDialog_Action_View"));
        this.settings.putClientProperty("OKButton", view);
        this.settings.refreshComponents();
        view.setToolTipText(NbBundle.getMessage(ViewRevisionAction.class, (String)"TT_ViewRevisionDialog_Action_View"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.settings, title, true, new Object[]{view, DialogDescriptor.CANCEL_OPTION}, (Object)view, 0, new HelpCtx(ViewRevisionAction.class), null);
        descriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ViewRevisionAction.class, (String)"ACSD_ViewRevisionDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != view) {
            return;
        }
        this.settings.saveSettings();
        Utils.createTask((Runnable)this).schedule(0);
    }

    public void run() {
        String revision = this.settings.getRevision();
        File tempFolder = Utils.getTempFolder();
        for (File file : this.ctx.getRootFiles()) {
            if (file.isDirectory()) continue;
            try {
                ViewRevisionAction.view(file, revision, tempFolder);
            }
            catch (Exception e) {}
        }
    }

    public static void view(File base, final String revision, File tempFolder) throws Exception {
        if (tempFolder == null) {
            tempFolder = Utils.getTempFolder();
        }
        File original = VersionsCache.getInstance().getRemoteFile(base, revision, null);
        File daoFile = new File(tempFolder, base.getName());
        daoFile.deleteOnExit();
        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(daoFile), (InputStream)new FileInputStream(original));
        final FileObject fo = FileUtil.toFileObject((File)daoFile);
        DataObject dao = DataObject.find((FileObject)fo);
        EditorCookie ec = (EditorCookie)dao.getCookie(EditorCookie.class);
        if (ec != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Utils.openFile((FileObject)fo, (String)revision);
                }
            });
        }
    }
}

