/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashSet;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.net.SocketFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ExtConnection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.PasswordsFile;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.SSHConnection;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.AbstractStep;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RootWizard;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
ActionListener,
DocumentListener {
    private static final String USE_INTERNAL_SSH = "repositoryStep.useInternalSSH";
    private static final String EXT_COMMAND = "repositoryStep.extCommand";
    private static final String RECENT_ROOTS = "repositoryStep.recentRoots";
    private RequestProcessor.Task updatePasswordTask;
    private volatile boolean passwordExpected;
    private ProgressHandle progress;
    private JComponent progressComponent;
    private JLabel progressLabel;
    private volatile boolean internalDocumentChange;
    private Thread backgroundValidationThread;
    private RepositoryPanel repositoryPanel;
    private String scrambledPassword;
    private final String initialCvsRoot;
    private String preferedCvsRoot;

    public RepositoryStep() {
        this.initialCvsRoot = null;
    }

    public RepositoryStep(String root) {
        this.initialCvsRoot = root;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(RepositoryStep.class);
    }

    public void initPreferedCvsRoot(String root) {
        this.preferedCvsRoot = root;
    }

    protected JComponent createComponent() {
        this.repositoryPanel = new RepositoryPanel();
        this.repositoryPanel.extSshRadioButton.addActionListener(this);
        this.repositoryPanel.internalSshRadioButton.addActionListener(this);
        this.repositoryPanel.extCommandTextField.getDocument().addDocumentListener(this);
        this.repositoryPanel.extPasswordField.getDocument().addDocumentListener(this);
        this.repositoryPanel.passwordTextField.getDocument().addDocumentListener(this);
        RequestProcessor requestProcessor = new RequestProcessor();
        this.updatePasswordTask = requestProcessor.create(new Runnable(){

            public void run() {
                String cvsRoot = RepositoryStep.this.selectedCvsRoot();
                String password = PasswordsFile.findPassword((String)cvsRoot);
                if (password != null && RepositoryStep.this.passwordExpected) {
                    String fakePasswordWithProperLen = new String(password).substring(1);
                    RepositoryStep.this.scrambledPassword = password;
                    RepositoryStep.this.internalDocumentChange = true;
                    ((RepositoryStep)RepositoryStep.this).repositoryPanel.passwordTextField.setText(fakePasswordWithProperLen);
                    RepositoryStep.this.internalDocumentChange = false;
                    RepositoryStep.this.cancelPasswordUpdate();
                }
            }
        });
        LinkedHashSet<String> recentRoots = new LinkedHashSet<String>();
        if (this.preferedCvsRoot != null) {
            recentRoots.add(this.preferedCvsRoot);
        }
        recentRoots.addAll(Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)RECENT_ROOTS));
        if (this.initialCvsRoot != null) {
            recentRoots.add(this.initialCvsRoot);
        }
        for (String next : PasswordsFile.listRoots((String)":pserver:")) {
            if (recentRoots.contains(next)) continue;
            recentRoots.add(next);
        }
        String user = System.getProperty("user.name", "");
        if (user.length() > 0) {
            user = user + "@";
        }
        recentRoots.add(":pserver:" + user);
        recentRoots.add(":ext:" + user);
        recentRoots.add(":fork:");
        recentRoots.add(":local:");
        DefaultComboBoxModel rootsModel = new DefaultComboBoxModel(new Vector(recentRoots));
        this.repositoryPanel.rootComboBox.setModel(rootsModel);
        this.repositoryPanel.rootComboBox.addActionListener(this);
        Component editor = this.repositoryPanel.rootComboBox.getEditor().getEditorComponent();
        JTextComponent textEditor = (JTextComponent)editor;
        if (recentRoots.size() == 0) {
            textEditor.setText(":pserver:" + user);
        } else {
            this.validateCvsRoot();
            CVSRoot root = this.getCVSRoot();
            this.schedulePasswordUpdate();
        }
        textEditor.selectAll();
        textEditor.getDocument().addDocumentListener(this);
        boolean useInternalSsh = CvsModuleConfig.getDefault().getPreferences().getBoolean(USE_INTERNAL_SSH, true);
        this.repositoryPanel.internalSshRadioButton.setSelected(useInternalSsh);
        this.repositoryPanel.extSshRadioButton.setSelected(!useInternalSsh);
        String extCommand = CvsModuleConfig.getDefault().getPreferences().get(EXT_COMMAND, "");
        this.repositoryPanel.extCommandTextField.setText(extCommand);
        this.repositoryPanel.proxyConfigurationButton.addActionListener(this);
        this.repositoryPanel.editButton.addActionListener(this);
        this.valid();
        this.onCvsRootChange();
        if (this.initialCvsRoot != null) {
            boolean chooserVisible = false;
            this.repositoryPanel.headerLabel.setVisible(chooserVisible);
            this.repositoryPanel.rootsLabel.setVisible(chooserVisible);
            this.repositoryPanel.rootComboBox.setVisible(chooserVisible);
            this.repositoryPanel.descLabel.setVisible(chooserVisible);
            this.repositoryPanel.editButton.setVisible(chooserVisible);
        }
        return this.repositoryPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        if (!this.validateCvsRoot()) {
            return;
        }
        final CVSRoot root = this.getCVSRoot();
        this.backgroundValidationThread = Thread.currentThread();
        final String[] invalidMsg = new String[1];
        Runnable worker = new Runnable(){

            private void fail(String msg) {
                invalidMsg[0] = msg;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String host = root.getHostName();
                String userName = root.getUserName();
                int port = root.getPort();
                Socket sock = null;
                Object connection = null;
                try {
                    if (root.isLocal()) {
                        LocalConnection lconnection = new LocalConnection();
                        lconnection.setRepository(root.getRepository());
                        lconnection.verify();
                    } else {
                        RepositoryStep.this.invalid(null);
                        RepositoryStep.this.progress(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2011"));
                        SocketFactory factory = SocketFactory.getDefault();
                        if ("pserver".equals(root.getMethod())) {
                            port = port == 0 ? 2401 : port;
                            InetSocketAddress target = new InetSocketAddress(host, port);
                            sock = factory.createSocket();
                            sock.connect(target, 5000);
                            sock.close();
                            RepositoryStep.this.progress(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2010"));
                            PServerConnection pconnection = new PServerConnection(root, factory);
                            String password = RepositoryStep.this.getScrambledPassword();
                            pconnection.setEncodedPassword(password);
                            pconnection.verify();
                        } else if ("ext".equals(root.getMethod())) {
                            if (((RepositoryStep)RepositoryStep.this).repositoryPanel.internalSshRadioButton.isSelected()) {
                                port = port == 0 ? 22 : port;
                                String password = ((RepositoryStep)RepositoryStep.this).repositoryPanel.extPasswordField.getText();
                                SSHConnection sshConnection = new SSHConnection(factory, host, port, userName, password);
                                sshConnection.setRepository(root.getRepository());
                                sshConnection.verify();
                            } else {
                                String command = ((RepositoryStep)RepositoryStep.this).repositoryPanel.extCommandTextField.getText();
                                String userOption = "";
                                if (userName != null) {
                                    userOption = " -l " + userName;
                                }
                                String cvs_server = System.getenv("CVS_SERVER") != null ? System.getenv("CVS_SERVER") + " server" : "cvs server";
                                command = command + " " + host + userOption + " " + cvs_server;
                                ExtConnection econnection = new ExtConnection(command);
                                econnection.setRepository(root.getRepository());
                                econnection.verify();
                            }
                        } else assert (false) : "Login check implemented only for pserver";
                    }
                }
                catch (IOException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, NbBundle.getMessage(RepositoryStep.class, (String)"BK2019"));
                    err.notify(1, (Throwable)e);
                    String msg = NbBundle.getMessage(CheckoutWizard.class, (String)"BK1001", (Object)host);
                    this.fail(msg);
                }
                catch (AuthenticationException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, "Connection authentification verification failed.");
                    err.notify(1, (Throwable)e);
                    String msg = e.getLocalizedMessage() != null && e.getLocalizedMessage().startsWith("<") ? e.getLocalizedMessage() : (root.isLocal() ? NbBundle.getMessage(CheckoutWizard.class, (String)"BK1004") : NbBundle.getMessage(CheckoutWizard.class, (String)"BK1002"));
                    this.fail(msg);
                }
                finally {
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (IOException e) {}
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        Thread workerThread = new Thread(worker, "CVS I/O Probe ");
        workerThread.start();
        try {
            workerThread.join();
            if (invalidMsg[0] == null) {
                this.valid();
                this.storeValidValues();
            } else {
                this.valid(invalidMsg[0]);
            }
            this.backgroundValidationThread = null;
        }
        catch (InterruptedException e) {
            try {
                this.invalid(NbBundle.getMessage(RepositoryStep.class, (String)"BK2023"));
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "Passing interrupt to possibly uninterruptible nested thread: " + workerThread);
                workerThread.interrupt();
                err.notify(1, (Throwable)e);
                this.backgroundValidationThread = null;
            }
            catch (Throwable throwable) {
                this.backgroundValidationThread = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RepositoryStep.this.validationDone();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void progress(String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
    }

    private void validationDone() {
        this.progress.finish();
        this.repositoryPanel.jPanel1.remove(this.progressComponent);
        this.repositoryPanel.jPanel1.revalidate();
        this.repositoryPanel.jPanel1.repaint();
        this.editable(true);
    }

    private void editable(boolean editable) {
        this.repositoryPanel.rootComboBox.setEditable(editable);
        this.repositoryPanel.passwordTextField.setEditable(editable);
        this.repositoryPanel.extCommandTextField.setEditable(editable);
        this.repositoryPanel.extPasswordField.setEditable(editable);
        this.repositoryPanel.proxyConfigurationButton.setEnabled(editable);
        this.repositoryPanel.extREmemberPasswordCheckBox.setEnabled(editable);
        this.repositoryPanel.internalSshRadioButton.setEnabled(editable);
        this.repositoryPanel.extSshRadioButton.setEnabled(editable);
    }

    void storeValidValues() {
        String root = this.selectedCvsRoot();
        CVSRoot cvsRoot = CVSRoot.parse((String)root);
        if (root.startsWith(":pserver:")) {
            try {
                PasswordsFile.storePassword((String)root, (String)this.getScrambledPassword());
            }
            catch (IOException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, NbBundle.getMessage(RepositoryStep.class, (String)"BK2020"));
                err.notify((Throwable)e);
            }
        } else if (root.startsWith(":ext:")) {
            boolean internalSsh = this.repositoryPanel.internalSshRadioButton.isSelected();
            CvsModuleConfig.ExtSettings extSettings = new CvsModuleConfig.ExtSettings();
            extSettings.extUseInternalSsh = internalSsh;
            extSettings.extPassword = this.repositoryPanel.extPasswordField.getText();
            extSettings.extRememberPassword = this.repositoryPanel.extREmemberPasswordCheckBox.isSelected();
            extSettings.extCommand = this.repositoryPanel.extCommandTextField.getText();
            CvsModuleConfig.getDefault().getPreferences().putBoolean(USE_INTERNAL_SSH, internalSsh);
            CvsModuleConfig.getDefault().getPreferences().put(EXT_COMMAND, extSettings.extCommand);
            CvsModuleConfig.getDefault().setExtSettingsFor(cvsRoot, extSettings);
        }
        Utils.insert((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)RECENT_ROOTS, (String)root, (int)8);
    }

    private boolean validateCvsRoot() {
        String cvsRoot = this.selectedCvsRoot();
        String errorMessage = null;
        boolean supportedMethod = false;
        if (cvsRoot != null) {
            supportedMethod |= cvsRoot.startsWith(":pserver:");
            supportedMethod |= cvsRoot.startsWith(":local:");
            supportedMethod |= cvsRoot.startsWith(":fork:");
            supportedMethod |= cvsRoot.startsWith(":ext:");
        }
        if (!supportedMethod) {
            errorMessage = NbBundle.getMessage(CheckoutWizard.class, (String)"BK1000");
        } else {
            try {
                CVSRoot.parse((String)cvsRoot);
            }
            catch (IllegalArgumentException ex) {
                errorMessage = NbBundle.getMessage(RepositoryStep.class, (String)"BK2021") + ex.getLocalizedMessage();
            }
        }
        if (errorMessage != null) {
            this.invalid(errorMessage);
        }
        return errorMessage == null;
    }

    private void onCvsRootChange() {
        if (this.validateCvsRoot()) {
            this.valid();
            CVSRoot root = this.getCVSRoot();
            if ("ext".equals(root.getMethod()) && CvsModuleConfig.getDefault().hasExtSettingsFor(root)) {
                CvsModuleConfig.ExtSettings extSettings = CvsModuleConfig.getDefault().getExtSettingsFor(root);
                this.repositoryPanel.internalSshRadioButton.setSelected(extSettings.extUseInternalSsh);
                this.repositoryPanel.extPasswordField.setText(extSettings.extPassword);
                this.repositoryPanel.extREmemberPasswordCheckBox.setSelected(extSettings.extRememberPassword);
                this.repositoryPanel.extCommandTextField.setText(extSettings.extCommand);
            }
            this.repositoryPanel.extPasswordField.setEditable(root.getPassword() == null);
            this.repositoryPanel.passwordTextField.setEditable(root.getPassword() == null);
            if (root.getPassword() != null) {
                if ("ext".equals(root.getMethod())) {
                    this.repositoryPanel.extPasswordField.setText(root.getPassword());
                } else if ("pserver".equals(root.getMethod())) {
                    this.repositoryPanel.passwordTextField.setText(root.getPassword());
                }
            } else {
                this.schedulePasswordUpdate();
            }
        }
        this.updateVisibility();
        this.updateLabel();
    }

    private void updateLabel() {
        String cvsRoot = this.selectedCvsRoot();
        if (cvsRoot.startsWith(":pserver:")) {
            this.repositoryPanel.descLabel.setText("(:pserver:username@hostname:/repository_path)");
        } else if (cvsRoot.startsWith(":local:")) {
            this.repositoryPanel.descLabel.setText("(:local:/repository_path)");
        } else if (cvsRoot.startsWith(":fork:")) {
            this.repositoryPanel.descLabel.setText("(:fork:/repository_path)");
        } else if (cvsRoot.startsWith(":ext:")) {
            this.repositoryPanel.descLabel.setText("(:ext:username@hostname:/repository_path)");
        } else {
            this.repositoryPanel.descLabel.setText(NbBundle.getMessage(CheckoutWizard.class, (String)"BK1014"));
        }
    }

    private void updateVisibility() {
        String root = this.selectedCvsRoot();
        boolean showPserverFields = root.startsWith(":pserver:");
        boolean showExtFields = root.startsWith(":ext:");
        this.repositoryPanel.passwordTextField.setVisible(showPserverFields);
        this.repositoryPanel.pPaswordLabel.setVisible(showPserverFields);
        this.repositoryPanel.internalSshRadioButton.setVisible(showExtFields);
        this.repositoryPanel.extSshRadioButton.setVisible(showExtFields);
        this.repositoryPanel.extPasswordLabel5.setVisible(showExtFields);
        this.repositoryPanel.extPasswordField.setVisible(showExtFields);
        this.repositoryPanel.extPasswordField.setEnabled(this.repositoryPanel.internalSshRadioButton.isSelected());
        this.repositoryPanel.extREmemberPasswordCheckBox.setVisible(showExtFields);
        this.repositoryPanel.extREmemberPasswordCheckBox.setEnabled(this.repositoryPanel.internalSshRadioButton.isSelected());
        this.repositoryPanel.extCommandLabel.setVisible(showExtFields);
        this.repositoryPanel.extCommandTextField.setVisible(showExtFields);
        this.repositoryPanel.extCommandTextField.setEnabled(this.repositoryPanel.extSshRadioButton.isSelected());
        this.repositoryPanel.proxyConfigurationButton.setVisible(showPserverFields || showExtFields);
        this.repositoryPanel.proxyConfigurationButton.setEnabled(!this.repositoryPanel.extSshRadioButton.isSelected());
        this.repositoryPanel.browseButton.setVisible(showExtFields);
        this.repositoryPanel.browseButton.setEnabled(this.repositoryPanel.extSshRadioButton.isSelected());
    }

    private String selectedCvsRoot() {
        if (this.initialCvsRoot != null) {
            return this.initialCvsRoot;
        }
        final String[] cvsRoot = new String[1];
        try {
            Runnable awt = new Runnable(){

                public void run() {
                    cvsRoot[0] = (String)((RepositoryStep)RepositoryStep.this).repositoryPanel.rootComboBox.getEditor().getItem();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                awt.run();
            } else {
                SwingUtilities.invokeAndWait(awt);
            }
            String root = cvsRoot[0].trim();
            try {
                return CVSRoot.parse((String)root).toString();
            }
            catch (Exception e) {
                return root;
            }
        }
        catch (InterruptedException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify((Throwable)e);
        }
        return null;
    }

    private CVSRoot getCVSRoot() {
        try {
            String root = this.selectedCvsRoot();
            return CVSRoot.parse((String)root);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private void schedulePasswordUpdate() {
        String root = this.selectedCvsRoot();
        if (root.startsWith(":pserver:")) {
            this.passwordExpected = true;
            this.updatePasswordTask.schedule(10);
        }
    }

    private void cancelPasswordUpdate() {
        this.passwordExpected = false;
    }

    private void onPasswordChange() {
        this.cancelPasswordUpdate();
        this.scrambledPassword = null;
        if (this.validateCvsRoot()) {
            this.valid();
        }
    }

    private void setValid() {
        this.valid();
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
        if (this.validateCvsRoot()) {
            this.valid();
        }
    }

    private void editRoot() {
        String root = this.selectedCvsRoot();
        if ((root = RootWizard.editCvsRoot(root)) != null) {
            this.repositoryPanel.rootComboBox.setSelectedItem(root);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.repositoryPanel.proxyConfigurationButton == e.getSource()) {
            this.onProxyConfiguration();
        } else if (this.repositoryPanel.rootComboBox == e.getSource()) {
            this.onCvsRootChange();
        } else if (this.repositoryPanel.editButton == e.getSource()) {
            this.editRoot();
        } else if (this.repositoryPanel.extSshRadioButton == e.getSource()) {
            this.setValid();
            this.validateCvsRoot();
            this.updateVisibility();
        } else if (this.repositoryPanel.internalSshRadioButton == e.getSource()) {
            this.setValid();
            this.validateCvsRoot();
            this.updateVisibility();
        } else assert (false) : "Unexpected event source: " + e.getSource();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    private void textChanged(final DocumentEvent e) {
        if (this.internalDocumentChange) {
            return;
        }
        Runnable awt = new Runnable(){

            public void run() {
                if (e.getDocument() == ((RepositoryStep)RepositoryStep.this).repositoryPanel.passwordTextField.getDocument()) {
                    RepositoryStep.this.onPasswordChange();
                } else if (e.getDocument() == ((JTextComponent)((RepositoryStep)RepositoryStep.this).repositoryPanel.rootComboBox.getEditor().getEditorComponent()).getDocument()) {
                    RepositoryStep.this.onCvsRootChange();
                } else if (e.getDocument() == ((RepositoryStep)RepositoryStep.this).repositoryPanel.extPasswordField.getDocument()) {
                    RepositoryStep.this.setValid();
                    RepositoryStep.this.validateCvsRoot();
                } else if (e.getDocument() == ((RepositoryStep)RepositoryStep.this).repositoryPanel.extCommandTextField.getDocument()) {
                    RepositoryStep.this.setValid();
                    RepositoryStep.this.validateCvsRoot();
                }
            }
        };
        SwingUtilities.invokeLater(awt);
    }

    public void prepareValidation() {
        this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CheckoutWizard.class, (String)"BK2012"));
        JComponent bar = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progress);
        JButton stopButton = new JButton(NbBundle.getMessage(RepositoryStep.class, (String)"BK2022"));
        stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RepositoryStep.this.backgroundValidationThread != null) {
                    RepositoryStep.this.backgroundValidationThread.interrupt();
                }
            }
        });
        this.progressComponent = new JPanel();
        this.progressComponent.setLayout(new BorderLayout(6, 0));
        this.progressLabel = new JLabel();
        this.progressComponent.add((Component)this.progressLabel, "North");
        this.progressComponent.add((Component)bar, "Center");
        this.progressComponent.add((Component)stopButton, "After");
        this.progress.start();
        this.repositoryPanel.jPanel1.setLayout(new BorderLayout());
        this.repositoryPanel.jPanel1.add((Component)this.progressComponent, "South");
        this.repositoryPanel.jPanel1.revalidate();
        this.editable(false);
    }

    private String getPassword() {
        return new String(this.repositoryPanel.passwordTextField.getPassword());
    }

    public String getCvsRoot() {
        return this.selectedCvsRoot();
    }

    public String getScrambledPassword() {
        if (this.scrambledPassword == null) {
            String plainPassword = this.getPassword();
            this.scrambledPassword = StandardScrambler.getInstance().scramble(plainPassword);
        }
        return this.scrambledPassword;
    }
}

