/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CvsRootPanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class RootWizard
implements ActionListener,
DocumentListener {
    private final RepositoryStep repositoryStep;
    private final CvsRootPanel rootPanel;
    private DialogDescriptor dd;

    private RootWizard(RepositoryStep step) {
        this.repositoryStep = step;
        this.rootPanel = null;
    }

    private RootWizard(CvsRootPanel rootPanel) {
        this.repositoryStep = null;
        this.rootPanel = rootPanel;
    }

    public static RootWizard configureRoot(String root) {
        RepositoryStep step = new RepositoryStep(root);
        step.applyStandaloneLayout();
        return new RootWizard(step);
    }

    public static String editCvsRoot(String root) {
        CvsRootPanel rootPanel = new CvsRootPanel();
        RootWizard wizard = new RootWizard(rootPanel);
        return wizard.customizeRoot(root);
    }

    private String customizeRoot(String root) {
        String access = "pserver";
        String host = "";
        String port = "";
        String user = System.getProperty("user.name");
        String repository = "";
        try {
            CVSRoot cvsRoot = CVSRoot.parse((String)root);
            access = cvsRoot.getMethod();
            host = cvsRoot.getHostName();
            int portG = cvsRoot.getPort();
            if (portG > 0) {
                port = "" + portG;
            }
            user = cvsRoot.getUserName();
            repository = cvsRoot.getRepository();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        this.rootPanel.accessComboBox.setSelectedItem(access);
        this.rootPanel.hostTextField.setText(host);
        this.rootPanel.portTextField.setText(port);
        this.rootPanel.userTextField.setText(user);
        this.rootPanel.repositoryTextField.setText(repository);
        this.rootPanel.accessComboBox.addActionListener(this);
        this.rootPanel.userTextField.getDocument().addDocumentListener(this);
        this.rootPanel.hostTextField.getDocument().addDocumentListener(this);
        this.rootPanel.userTextField.getDocument().addDocumentListener(this);
        this.rootPanel.portTextField.getDocument().addDocumentListener(this);
        this.rootPanel.repositoryTextField.getDocument().addDocumentListener(this);
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.dd = new DialogDescriptor((Object)this.rootPanel, NbBundle.getMessage(RootWizard.class, (String)"BK2024"));
        this.dd.setHelpCtx(new HelpCtx(CvsRootPanel.class));
        this.dd.setModal(true);
        this.rootPanel.setPreferredSize(this.rootPanel.getPreferredSize());
        this.updateVisibility();
        this.checkInput();
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RootWizard.class, (String)"ACSD_CvsRootPanel"));
        d.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(this.dd.getValue())) {
            try {
                String ret = this.collectRoot();
                CVSRoot cvsRoot = CVSRoot.parse((String)ret);
                return ret;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private void updateVisibility() {
        String access = (String)this.rootPanel.accessComboBox.getSelectedItem();
        boolean hostVisible = "pserver".equals(access) || "ext".equals(access);
        this.rootPanel.userLabel.setVisible(hostVisible);
        this.rootPanel.userTextField.setVisible(hostVisible);
        this.rootPanel.hostLabel.setVisible(hostVisible);
        this.rootPanel.hostTextField.setVisible(hostVisible);
        this.rootPanel.portLabel.setVisible(hostVisible);
        this.rootPanel.portTextField.setVisible(hostVisible);
    }

    private String collectRoot() throws IllegalArgumentException {
        String s;
        String method = (String)this.rootPanel.accessComboBox.getSelectedItem();
        boolean hasHost = "pserver".equals(method) || "ext".equals(method);
        StringBuffer sb = new StringBuffer(":");
        sb.append(method);
        sb.append(":");
        if (hasHost) {
            int portp;
            s = this.rootPanel.userTextField.getText();
            if ("".equals(s.trim())) {
                throw new IllegalArgumentException();
            }
            sb.append(s);
            sb.append("@");
            s = this.rootPanel.hostTextField.getText();
            if ("".equals(s.trim())) {
                throw new IllegalArgumentException();
            }
            sb.append(s);
            sb.append(":");
            String portS = this.rootPanel.portTextField.getText();
            if (!"".equals(portS.trim()) && (portp = Integer.parseInt(portS)) > 0) {
                sb.append(portS);
            }
        }
        if ("".equals((s = this.rootPanel.repositoryTextField.getText()).trim())) {
            throw new IllegalArgumentException();
        }
        sb.append(s);
        return sb.toString();
    }

    private void checkInput() {
        try {
            String ret = this.collectRoot();
            CVSRoot cvsRoot = CVSRoot.parse((String)ret);
            this.dd.setValid(true);
        }
        catch (IllegalArgumentException ex) {
            this.dd.setValid(false);
        }
    }

    public JPanel getPanel() {
        RepositoryPanel repositoryPanel = (RepositoryPanel)this.repositoryStep.getComponent();
        return repositoryPanel;
    }

    public String commit(boolean validate) {
        if (validate) {
            this.repositoryStep.prepareValidation();
            this.repositoryStep.validateBeforeNext();
            if (!this.repositoryStep.isValid()) {
                return this.repositoryStep.getErrorMessage();
            }
        }
        this.repositoryStep.storeValidValues();
        return null;
    }

    public boolean isValid() {
        return this.repositoryStep.isValid();
    }

    public void addChangeListener(ChangeListener l) {
        this.repositoryStep.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.repositoryStep.removeChangeListener(l);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateVisibility();
        this.checkInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }
}

