/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.print.Pageable;
import java.text.AttributedCharacterIterator;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openide.options.SystemOption;
import org.openide.text.Annotation;
import org.openide.text.BackwardPosition;
import org.openide.text.DefaultPrintable;

public final class NbDocument {
    public static final Object GUARDED = new AttributeSet.CharacterAttribute(){};
    private static final SimpleAttributeSet ATTR_ADD = new SimpleAttributeSet();
    private static final SimpleAttributeSet ATTR_REMOVE = new SimpleAttributeSet();
    public static final String BREAKPOINT_STYLE_NAME = "NbBreakpointStyle";
    public static final String ERROR_STYLE_NAME = "NbErrorStyle";
    public static final String CURRENT_STYLE_NAME = "NbCurrentStyle";
    public static final String NORMAL_STYLE_NAME = "NbNormalStyle";
    @Deprecated
    public static final Colors COLORS;

    private NbDocument() {
    }

    public static Element findLineRootElement(StyledDocument doc) {
        NbDocument.checkDocParameter(doc);
        Element e = doc.getParagraphElement(0).getParentElement();
        if (e == null) {
            e = doc.getDefaultRootElement();
        }
        return e;
    }

    public static int findLineNumber(StyledDocument doc, int offset) {
        return new DocumentRenderer(0, doc, offset).renderToInt();
    }

    public static int findLineColumn(StyledDocument doc, int offset) {
        return new DocumentRenderer(1, doc, offset).renderToInt();
    }

    public static int findLineOffset(StyledDocument doc, int lineNumber) {
        return new DocumentRenderer(2, doc, lineNumber).renderToInt();
    }

    public static Position createPosition(Document doc, int offset, Position.Bias bias) throws BadLocationException {
        NbDocument.checkDocParameter(doc);
        if (doc instanceof PositionBiasable) {
            return ((PositionBiasable)doc).createPosition(offset, bias);
        }
        if (bias == Position.Bias.Forward) {
            return doc.createPosition(offset);
        }
        return BackwardPosition.create(doc, offset);
    }

    public static void markGuarded(StyledDocument doc, int offset, int len) {
        NbDocument.checkDocParameter(doc);
        doc.setCharacterAttributes(offset, len, ATTR_ADD, false);
    }

    public static void unmarkGuarded(StyledDocument doc, int offset, int len) {
        NbDocument.checkDocParameter(doc);
        doc.setCharacterAttributes(offset, len, ATTR_REMOVE, false);
    }

    public static void insertGuarded(StyledDocument doc, int offset, String txt) throws BadLocationException {
        NbDocument.checkDocParameter(doc);
        doc.insertString(offset, txt, ATTR_ADD);
    }

    @Deprecated
    public static void markBreakpoint(StyledDocument doc, int offset) {
        NbDocument.checkDocParameter(doc);
        Style bp = doc.getStyle(BREAKPOINT_STYLE_NAME);
        if (bp == null) {
            bp = doc.addStyle(BREAKPOINT_STYLE_NAME, null);
            if (bp == null) {
                return;
            }
            bp.addAttribute(StyleConstants.ColorConstants.Background, Color.red);
            bp.addAttribute(StyleConstants.ColorConstants.Foreground, Color.white);
        }
        doc.setLogicalStyle(offset, bp);
    }

    @Deprecated
    public static void markError(StyledDocument doc, int offset) {
        NbDocument.checkDocParameter(doc);
        Style bp = doc.getStyle(ERROR_STYLE_NAME);
        if (bp == null) {
            bp = doc.addStyle(ERROR_STYLE_NAME, null);
            if (bp == null) {
                return;
            }
            bp.addAttribute(StyleConstants.ColorConstants.Background, Color.green);
            bp.addAttribute(StyleConstants.ColorConstants.Foreground, Color.black);
        }
        doc.setLogicalStyle(offset, bp);
    }

    @Deprecated
    public static void markCurrent(StyledDocument doc, int offset) {
        NbDocument.checkDocParameter(doc);
        Style bp = doc.getStyle(CURRENT_STYLE_NAME);
        if (bp == null) {
            bp = doc.addStyle(CURRENT_STYLE_NAME, null);
            if (bp == null) {
                return;
            }
            bp.addAttribute(StyleConstants.ColorConstants.Background, Color.blue);
            bp.addAttribute(StyleConstants.ColorConstants.Foreground, Color.white);
        }
        doc.setLogicalStyle(offset, bp);
    }

    @Deprecated
    public static void markNormal(StyledDocument doc, int offset) {
        NbDocument.checkDocParameter(doc);
        Style st = doc.getStyle(NORMAL_STYLE_NAME);
        if (st == null) {
            st = doc.addStyle(NORMAL_STYLE_NAME, null);
        }
        if (st != null) {
            doc.setLogicalStyle(offset, st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAtomic(StyledDocument doc, Runnable run) {
        NbDocument.checkDocParameter(doc);
        if (doc instanceof WriteLockable) {
            ((WriteLockable)((Object)doc)).runAtomic(run);
        } else {
            StyledDocument styledDocument = doc;
            synchronized (styledDocument) {
                run.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAtomicAsUser(StyledDocument doc, Runnable run) throws BadLocationException {
        NbDocument.checkDocParameter(doc);
        if (doc instanceof WriteLockable) {
            ((WriteLockable)((Object)doc)).runAtomicAsUser(run);
        } else {
            StyledDocument styledDocument = doc;
            synchronized (styledDocument) {
                run.run();
            }
        }
    }

    private static void checkDocParameter(Document doc) {
        if (doc == null) {
            throw new NullPointerException("Invalid doc parameter. Document may not be null!");
        }
    }

    public static Object findPageable(StyledDocument doc) {
        if (doc instanceof Pageable) {
            return doc;
        }
        if (doc instanceof java.awt.print.Printable) {
            return doc;
        }
        return new DefaultPrintable(doc);
    }

    public static void addAnnotation(final StyledDocument doc, final Position startPos, final int length, final Annotation annotation) {
        if (!(doc instanceof Annotatable)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ((Annotatable)((Object)doc)).addAnnotation(startPos, length, annotation);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((Annotatable)((Object)doc)).addAnnotation(startPos, length, annotation);
                }
            });
        }
    }

    public static void removeAnnotation(final StyledDocument doc, final Annotation annotation) {
        if (!(doc instanceof Annotatable)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ((Annotatable)((Object)doc)).removeAnnotation(annotation);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((Annotatable)((Object)doc)).removeAnnotation(annotation);
                }
            });
        }
    }

    static {
        ATTR_ADD.addAttribute(GUARDED, Boolean.TRUE);
        ATTR_REMOVE.addAttribute(GUARDED, Boolean.FALSE);
        COLORS = new Colors();
    }

    public static interface Annotatable
    extends Document {
        public void addAnnotation(Position var1, int var2, Annotation var3);

        public void removeAnnotation(Annotation var1);
    }

    @Deprecated
    public static final class Colors
    extends SystemOption {
        public static final String PROP_BREAKPOINT = "NbBreakpointStyle";
        public static final String PROP_ERROR = "NbErrorStyle";
        public static final String PROP_CURRENT = "NbCurrentStyle";
        static final long serialVersionUID = -9152250591365746193L;

        public void setBreakpoint(Color c) {
        }

        public Color getBreakpoint() {
            return new Color(127, 127, 255);
        }

        public void setError(Color c) {
        }

        public Color getError() {
            return Color.red;
        }

        public void setCurrent(Color c) {
        }

        public Color getCurrent() {
            return Color.magenta;
        }

        public String displayName() {
            return "COLORS";
        }
    }

    public static interface CustomEditor
    extends Document {
        public Component createEditor(JEditorPane var1);
    }

    public static interface CustomToolbar
    extends Document {
        public JToolBar createToolbar(JEditorPane var1);
    }

    private static final class DocumentRenderer
    implements Runnable {
        private static final int FIND_LINE_NUMBER = 0;
        private static final int FIND_LINE_COLUMN = 1;
        private static final int FIND_LINE_OFFSET = 2;
        private StyledDocument doc;
        private int opCode;
        private int argInt;
        private int retInt;

        DocumentRenderer(int opCode, StyledDocument doc, int argInt) {
            this.opCode = opCode;
            this.doc = doc;
            this.argInt = argInt;
        }

        int renderToInt() {
            this.doc.render(this);
            return this.retInt;
        }

        public void run() {
            switch (this.opCode) {
                case 0: {
                    Element paragraphsParent = NbDocument.findLineRootElement(this.doc);
                    this.retInt = paragraphsParent.getElementIndex(this.argInt);
                    break;
                }
                case 1: {
                    Element paragraphsParent = NbDocument.findLineRootElement(this.doc);
                    int indx = paragraphsParent.getElementIndex(this.argInt);
                    this.retInt = this.argInt - paragraphsParent.getElement(indx).getStartOffset();
                    break;
                }
                case 2: {
                    Element paragraphsParent = NbDocument.findLineRootElement(this.doc);
                    Element line = paragraphsParent.getElement(this.argInt);
                    if (line == null) {
                        throw new IndexOutOfBoundsException("Index=" + this.argInt + " is out of bounds.");
                    }
                    this.retInt = line.getStartOffset();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static interface PositionBiasable
    extends Document {
        public Position createPosition(int var1, Position.Bias var2) throws BadLocationException;
    }

    public static interface Printable
    extends Document {
        public AttributedCharacterIterator[] createPrintIterators();
    }

    public static interface WriteLockable
    extends Document {
        public void runAtomic(Runnable var1);

        public void runAtomicAsUser(Runnable var1) throws BadLocationException;
    }
}

