/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.netbeans.libs.freemarker.FreemarkerFactory;
import org.netbeans.libs.freemarker.RsrcLoader;
import org.openide.filesystems.FileObject;

class FreemarkerEngine
extends AbstractScriptEngine {
    public static final String STRING_OUTPUT_MODE = "com.sun.script.freemarker.stringOut";
    public static final String FREEMARKER_CONFIG = "com.sun.script.freemarker.config";
    public static final String FREEMARKER_PROPERTIES = "com.sun.script.freemarker.properties";
    public static final String FREEMARKER_TEMPLATE_DIR = "com.sun.script.freemarker.template.dir";
    public static final String FREEMARKER_TEMPLATE = "org.openide.filesystems.FileObject";
    private volatile ScriptEngineFactory factory;
    private volatile Configuration conf;

    public FreemarkerEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public FreemarkerEngine() {
        this((ScriptEngineFactory)null);
    }

    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        this.initFreeMarkerConfiguration(ctx);
        String fileName = FreemarkerEngine.getFilename(ctx);
        boolean outputAsString = FreemarkerEngine.isStringOutputMode(ctx);
        Writer out = outputAsString ? new StringWriter() : ctx.getWriter();
        try {
            Template template = new Template(fileName, reader, this.conf);
            template.process(null, out);
            out.flush();
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        return outputAsString ? out.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            FreemarkerEngine freemarkerEngine = this;
            synchronized (freemarkerEngine) {
                if (this.factory == null) {
                    this.factory = new FreemarkerFactory();
                }
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private static String getFilename(ScriptContext ctx) {
        Object tfo = ctx.getAttribute(FREEMARKER_TEMPLATE);
        if (tfo instanceof FileObject) {
            return ((FileObject)tfo).getPath();
        }
        Object fileName = ctx.getAttribute("javax.script.filename");
        if (fileName != null) {
            return fileName.toString();
        }
        return "unknown";
    }

    private static boolean isStringOutputMode(ScriptContext ctx) {
        Object flag = ctx.getAttribute(STRING_OUTPUT_MODE);
        if (flag != null) {
            return flag.equals(Boolean.TRUE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFreeMarkerConfiguration(ScriptContext ctx) {
        if (this.conf == null) {
            FreemarkerEngine freemarkerEngine = this;
            synchronized (freemarkerEngine) {
                if (this.conf != null) {
                    return;
                }
                Object cfg = ctx.getAttribute(FREEMARKER_CONFIG);
                if (cfg instanceof Configuration) {
                    this.conf = (Configuration)cfg;
                    return;
                }
                Object tfo = ctx.getAttribute(FREEMARKER_TEMPLATE);
                FileObject fo = tfo instanceof FileObject ? (FileObject)tfo : null;
                RsrcLoader tmpConf = new RsrcLoader(fo, ctx);
                try {
                    FreemarkerEngine.initConfProps(tmpConf, ctx);
                    FreemarkerEngine.initTemplateDir(tmpConf, fo, ctx);
                }
                catch (RuntimeException rexp) {
                    throw rexp;
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
                this.conf = tmpConf;
            }
        }
    }

    private static void initConfProps(Configuration conf, ScriptContext ctx) {
        try {
            Properties props = null;
            Object tmp = ctx.getAttribute(FREEMARKER_PROPERTIES);
            if (props instanceof Properties) {
                props = (Properties)tmp;
            } else {
                File propsFile;
                String propsName = System.getProperty(FREEMARKER_PROPERTIES);
                if (propsName != null && (propsFile = new File(propsName)).exists() && propsFile.canRead()) {
                    props = new Properties();
                    props.load(new FileInputStream(propsFile));
                }
            }
            if (props != null) {
                Set<Object> keys = props.keySet();
                for (Object obj : keys) {
                    if (!(obj instanceof String)) continue;
                    String key = (String)obj;
                    try {
                        conf.setSetting(key, props.get(key).toString());
                    }
                    catch (TemplateException te) {}
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static void initTemplateDir(Configuration conf, FileObject fo, ScriptContext ctx) {
        try {
            String dirName;
            Object tmp = ctx.getAttribute(FREEMARKER_TEMPLATE_DIR);
            if (tmp != null) {
                dirName = tmp.toString();
            } else {
                if (fo != null) {
                    return;
                }
                tmp = System.getProperty(FREEMARKER_TEMPLATE_DIR);
                dirName = tmp == null ? "." : tmp.toString();
            }
            File dir = new File(dirName);
            if (dir.exists() && dir.isDirectory()) {
                conf.setDirectoryForTemplateLoading(dir);
            }
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
    }
}

