/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sysopen;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class SystemOpenAction
extends AbstractAction
implements ContextAwareAction {
    public SystemOpenAction() {
        super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
    }

    public void actionPerformed(ActionEvent e) {
        new ContextAction(Utilities.actionsGlobalContext()).actionPerformed(e);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new ContextAction(context);
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private static final Performer performer;
        private final Set<File> files = new HashSet<File>();

        public ContextAction(Lookup context) {
            super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
            for (DataObject d : context.lookupAll(DataObject.class)) {
                File f = FileUtil.toFile((FileObject)d.getPrimaryFile());
                if (f == null) {
                    this.files.clear();
                    break;
                }
                this.files.add(f);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (performer == null) {
                return;
            }
            for (File f : this.files) {
                try {
                    performer.open(f);
                }
                catch (IOException x) {
                    Logger.getLogger(SystemOpenAction.class.getName()).log(Level.INFO, null, x);
                }
            }
        }

        public JMenuItem getPopupPresenter() {
            class Menu
            extends JMenuItem
            implements DynamicMenuContent {
                public Menu() {
                    super(ContextAction.this);
                }

                public JComponent[] getMenuPresenters() {
                    if (performer != null && !ContextAction.this.files.isEmpty()) {
                        return new JComponent[]{this};
                    }
                    return new JComponent[0];
                }

                public JComponent[] synchMenuPresenters(JComponent[] items) {
                    return this.getMenuPresenters();
                }
            }
            return new Menu();
        }

        static {
            Performer _performer = null;
            try {
                Class<?> desktop = Class.forName("java.awt.Desktop");
                if (((Boolean)desktop.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    final Object desktopInstance = desktop.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    Class<?> action = Class.forName("java.awt.Desktop$Action");
                    if (((Boolean)desktop.getMethod("isSupported", action).invoke(desktopInstance, action.getField("OPEN").get(null))).booleanValue()) {
                        final Method open = desktop.getMethod("open", File.class);
                        _performer = new Performer(){

                            public void open(File f) throws IOException {
                                try {
                                    open.invoke(desktopInstance, f);
                                }
                                catch (InvocationTargetException x) {
                                    throw (IOException)x.getTargetException();
                                }
                                catch (Exception x) {
                                    throw (IOException)new IOException(x.toString()).initCause(x);
                                }
                            }
                        };
                    }
                }
            }
            catch (ClassNotFoundException x) {
            }
            catch (Exception x) {
                Logger.getLogger(SystemOpenAction.class.getName()).log(Level.WARNING, null, x);
            }
            performer = _performer;
        }

        private static interface Performer {
            public void open(File var1) throws IOException;
        }
    }
}

