/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.highlights.spi.DefaultHighlight;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHolder
implements ChangeListener,
PropertyChangeListener {
    static final Map<Severity, Coloring> COLORINGS = new EnumMap<Severity, Coloring>(Severity.class);
    private Map<ErrorDescription, List<Integer>> errors2Lines;
    private Map<Integer, List<ErrorDescription>> line2Errors;
    private Map<Integer, List<Highlight>> line2Highlights;
    private Map<Integer, ParseErrorAnnotation> line2Annotations;
    private Map<String, List<ErrorDescription>> layer2Errors;
    private Set<JEditorPane> openedComponents;
    private EditorCookie.Observable editorCookie;
    private FileObject file;
    private DataObject od;
    private Document doc;
    private static Map<FileObject, AnnotationHolder> file2Holder;
    Attacher attacher = new NbDocumentAttacher();
    private static final RequestProcessor INSTANCE;

    public static synchronized AnnotationHolder getInstance(FileObject file) {
        if (file == null) {
            return null;
        }
        AnnotationHolder result = file2Holder.get(file);
        if (result == null) {
            try {
                DataObject od = DataObject.find((FileObject)file);
                EditorCookie.Observable editorCookie = (EditorCookie.Observable)od.getCookie(EditorCookie.Observable.class);
                if (editorCookie == null) {
                    Logger.getLogger("global").log(Level.WARNING, "No EditorCookie.Observable for file: " + FileUtil.getFileDisplayName((FileObject)file));
                } else {
                    StyledDocument doc = editorCookie.getDocument();
                    if (doc != null) {
                        result = new AnnotationHolder(file, od, doc, editorCookie);
                        file2Holder.put(file, result);
                    }
                }
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        return result;
    }

    static synchronized Collection<FileObject> coveredFiles() {
        return new ArrayList<FileObject>(file2Holder.keySet());
    }

    private AnnotationHolder(FileObject file, DataObject od, Document doc, EditorCookie.Observable editorCookie) throws IOException {
        if (file == null) {
            return;
        }
        this.init();
        this.file = file;
        this.od = od;
        this.doc = doc;
        editorCookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)editorCookie));
        this.editorCookie = editorCookie;
        this.propertyChange(null);
        Logger.getLogger("TIMER").log(Level.FINE, "Annotation Holder", new Object[]{file, this});
    }

    private synchronized void init() {
        this.errors2Lines = new HashMap<ErrorDescription, List<Integer>>();
        this.line2Errors = new HashMap<Integer, List<ErrorDescription>>();
        this.line2Highlights = new HashMap<Integer, List<Highlight>>();
        this.line2Annotations = new HashMap<Integer, ParseErrorAnnotation>();
        this.layer2Errors = new HashMap<String, List<ErrorDescription>>();
        this.openedComponents = new HashSet<JEditorPane>();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.updateVisibleRanges();
    }

    void attachAnnotation(int line, ParseErrorAnnotation a) throws BadLocationException {
        this.attacher.attachAnnotation(line, a);
    }

    void detachAnnotation(Annotation a) {
        this.attacher.detachAnnotation(a);
    }

    private synchronized void clearAll() {
        for (ParseErrorAnnotation a : this.line2Annotations.values()) {
            this.detachAnnotation(a);
        }
        file2Holder.remove(this.file);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditorPane[] panes = AnnotationHolder.this.editorCookie.getOpenedPanes();
                if (panes == null) {
                    AnnotationHolder.this.clearAll();
                    return;
                }
                HashSet<JEditorPane> addedPanes = new HashSet<JEditorPane>(Arrays.asList(panes));
                HashSet removedPanes = new HashSet(AnnotationHolder.this.openedComponents);
                removedPanes.removeAll(addedPanes);
                addedPanes.removeAll(AnnotationHolder.this.openedComponents);
                for (JEditorPane pane : addedPanes) {
                    Container parent = pane.getParent();
                    if (!(parent instanceof JViewport)) continue;
                    JViewport viewport = (JViewport)parent;
                    viewport.addChangeListener(WeakListeners.change((ChangeListener)AnnotationHolder.this, (Object)viewport));
                }
                AnnotationHolder.this.openedComponents.removeAll(removedPanes);
                AnnotationHolder.this.openedComponents.addAll(addedPanes);
                AnnotationHolder.this.updateVisibleRanges();
            }
        });
    }

    private void updateVisibleRanges() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final ArrayList<int[]> visibleRanges = new ArrayList<int[]>();
                AnnotationHolder annotationHolder = AnnotationHolder.this;
                synchronized (annotationHolder) {
                    for (JEditorPane pane : AnnotationHolder.this.openedComponents) {
                        Container parent = pane.getParent();
                        if (!(parent instanceof JViewport)) continue;
                        JViewport viewport = (JViewport)parent;
                        Point start = viewport.getViewPosition();
                        Dimension size = viewport.getExtentSize();
                        Point end = new Point(start.x + size.width, start.y + size.height);
                        int startPosition = pane.viewToModel(start);
                        int endPosition = pane.viewToModel(end);
                        int startLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)pane.getDocument()), (int)startPosition);
                        int endLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)pane.getDocument()), (int)endPosition);
                        visibleRanges.add(new int[]{startLine, endLine});
                    }
                }
                INSTANCE.post(new Runnable(){

                    public void run() {
                        for (int[] span : visibleRanges) {
                            AnnotationHolder.this.updateAnnotations(span[0], span[1]);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotations(int startLine, int endLine) {
        ArrayList<ErrorDescription> errorsToUpdate = new ArrayList<ErrorDescription>();
        AnnotationHolder annotationHolder = this;
        synchronized (annotationHolder) {
            for (int cntr = startLine; cntr <= endLine; ++cntr) {
                List<ErrorDescription> errors = this.line2Errors.get(cntr);
                if (errors == null) continue;
                errorsToUpdate.addAll(errors);
            }
        }
        for (ErrorDescription e : errorsToUpdate) {
            LazyFixList l = e.getFixes();
            if (!l.probablyContainsFixes() || l.isComputed()) continue;
            l.getFixes();
        }
    }

    private List<ErrorDescription> getErrorsForLayer(String layer) {
        List<ErrorDescription> errors = this.layer2Errors.get(layer);
        if (errors == null) {
            errors = new ArrayList<ErrorDescription>();
            this.layer2Errors.put(layer, errors);
        }
        return errors;
    }

    private List<ErrorDescription> getErrorsForLine(Integer line) {
        List<ErrorDescription> errors = this.line2Errors.get(line);
        if (errors == null) {
            errors = new ArrayList<ErrorDescription>();
            this.line2Errors.put(line, errors);
        }
        return errors;
    }

    private List<ErrorDescription> filter(List<ErrorDescription> errors, boolean onlyErrors) {
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        for (ErrorDescription e : errors) {
            if (e.getSeverity() == Severity.ERROR) {
                if (!onlyErrors) continue;
                result.add(e);
                continue;
            }
            if (onlyErrors) continue;
            result.add(e);
        }
        return result;
    }

    private void concatDescription(List<ErrorDescription> errors, StringBuffer description) {
        boolean first = true;
        for (ErrorDescription e : errors) {
            if (!first) {
                description.append("\n\n");
            }
            description.append(e.getDescription());
            first = false;
        }
    }

    private List<LazyFixList> computeFixes(List<ErrorDescription> errors) {
        ArrayList<LazyFixList> result = new ArrayList<LazyFixList>();
        for (ErrorDescription e : errors) {
            result.add(e.getFixes());
        }
        return result;
    }

    private void updateAnnotationOnLine(Integer line) throws BadLocationException {
        Severity mostImportantSeverity;
        List<ErrorDescription> errorDescriptions = this.getErrorsForLine(line);
        if (errorDescriptions.isEmpty()) {
            Annotation ann = this.line2Annotations.remove(line);
            this.detachAnnotation(ann);
            return;
        }
        List<ErrorDescription> trueErrors = this.filter(errorDescriptions, true);
        List<ErrorDescription> others = this.filter(errorDescriptions, false);
        boolean hasErrors = !trueErrors.isEmpty();
        StringBuffer description = new StringBuffer();
        this.concatDescription(trueErrors, description);
        if (!trueErrors.isEmpty() && !others.isEmpty()) {
            description.append("\n\n");
        }
        this.concatDescription(others, description);
        if (hasErrors) {
            mostImportantSeverity = Severity.ERROR;
        } else {
            mostImportantSeverity = Severity.HINT;
            for (ErrorDescription e : others) {
                if (mostImportantSeverity.compareTo(e.getSeverity()) <= 0) continue;
                mostImportantSeverity = e.getSeverity();
            }
        }
        LazyFixList fixes = ErrorDescriptionFactory.lazyListForDelegates(this.computeFixes(hasErrors ? trueErrors : others));
        ParseErrorAnnotation pea = new ParseErrorAnnotation(mostImportantSeverity, fixes, description.toString(), line, this);
        Annotation previous = this.line2Annotations.put(line, pea);
        if (previous != null) {
            this.detachAnnotation(previous);
        }
        this.attachAnnotation(line, pea);
    }

    private void doUpdateHighlight(FileObject file) {
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        for (List<Highlight> hls : this.line2Highlights.values()) {
            highlights.addAll(hls);
        }
        Highlighter.getDefault().setHighlights(file, AnnotationHolder.class.getName(), highlights);
    }

    void updateHighlightsOnLine(Integer line) throws IOException {
        List<ErrorDescription> errorDescriptions = this.getErrorsForLine(line);
        if (errorDescriptions.isEmpty()) {
            this.line2Highlights.remove(line);
            return;
        }
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        try {
            AnnotationHolder.computeHighlights(this.doc, line, errorDescriptions, highlights);
            this.line2Highlights.put(line, highlights);
        }
        catch (BadLocationException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static void computeHighlights(Document doc, Integer line, List<ErrorDescription> errorDescriptions, List<Highlight> highlights) throws IOException, BadLocationException {
        for (Severity s : Arrays.asList(new Severity[]{Severity.ERROR, Severity.WARNING, Severity.VERIFIER})) {
            c = AnnotationHolder.COLORINGS.get((Object)s);
            filteredDescriptions = new ArrayList<ErrorDescription>();
            for (ErrorDescription e : errorDescriptions) {
                if (e.getSeverity() != s) continue;
                filteredDescriptions.add(e);
            }
            currentHighlights = new ArrayList<DefaultHighlight>();
            for (ErrorDescription e : filteredDescriptions) {
                h = new DefaultHighlight(c, e.getRange().getBegin().getPosition(), e.getRange().getEnd().getPosition());
                it = currentHighlights.iterator();
                block16: while (it.hasNext() && h != null) {
                    hl = (Highlight)it.next();
                    switch (AnnotationHolder.detectCollisions(hl, (Highlight)h)) {
                        case 0: {
                            ** GOTO lbl29
                        }
                        case 1: {
                            it.remove();
                            ** GOTO lbl29
                        }
                        case 2: {
                            h = null;
                            break block16;
                        }
                        case 3: 
                        case 4: {
                            start = Math.min(hl.getStart(), h.getStart());
                            end = Math.max(hl.getEnd(), h.getEnd());
                            h = new DefaultHighlight(c, doc.createPosition(start), doc.createPosition(end));
                            it.remove();
                        }
lbl29:
                        // 4 sources

                        default: {
                            continue block16;
                        }
                    }
                }
                if (h == null) continue;
                currentHighlights.add(h);
            }
            block17: while (!currentHighlights.isEmpty()) {
                lowerIt = currentHighlights.iterator();
                while (lowerIt.hasNext()) {
                    current /* !! */  = (Highlight)lowerIt.next();
                    lowerIt.remove();
                    higherIt = highlights.iterator();
                    while (higherIt.hasNext() && current /* !! */  != null) {
                        higher = higherIt.next();
                        switch (AnnotationHolder.detectCollisions(higher, current /* !! */ )) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                currentStart = higher.getEnd() + 1;
                                currentEnd = higher.getStart() - 1;
                                if (currentStart < doc.getLength() && currentStart < current /* !! */ .getEnd()) {
                                    currentHighlights.add(new DefaultHighlight(current /* !! */ .getColoring(), doc.createPosition(currentStart), doc.createPosition(current /* !! */ .getEnd())));
                                }
                                if (currentEnd >= doc.getLength() || current /* !! */ .getStart() >= currentEnd) continue block17;
                                currentHighlights.add(new DefaultHighlight(current /* !! */ .getColoring(), doc.createPosition(current /* !! */ .getStart()), doc.createPosition(currentEnd)));
                                continue block17;
                            }
                            case 2: {
                                current /* !! */  = null;
                                break;
                            }
                            case 3: {
                                currentStart = higher.getEnd() + 1;
                                if (currentStart < doc.getLength() && currentStart < current /* !! */ .getEnd()) {
                                    current /* !! */  = new DefaultHighlight(current /* !! */ .getColoring(), doc.createPosition(currentStart), doc.createPosition(current /* !! */ .getEnd()));
                                    break;
                                }
                                current /* !! */  = null;
                                break;
                            }
                            case 4: {
                                currentEnd = higher.getStart() - 1;
                                current /* !! */  = currentEnd < doc.getLength() && current /* !! */ .getStart() < currentEnd ? new DefaultHighlight(current /* !! */ .getColoring(), doc.createPosition(current /* !! */ .getStart()), doc.createPosition(currentEnd)) : null;
                            }
                        }
                    }
                    if (current /* !! */  == null) continue;
                    highlights.add(current /* !! */ );
                }
            }
        }
    }

    private static int detectCollisions(Highlight h1, Highlight h2) {
        if (h2.getEnd() < h1.getStart()) {
            return 0;
        }
        if (h1.getEnd() < h2.getStart()) {
            return 0;
        }
        if (h2.getStart() < h1.getStart() && h2.getEnd() > h1.getEnd()) {
            return 1;
        }
        if (h1.getStart() < h2.getStart() && h1.getEnd() > h2.getEnd()) {
            return 2;
        }
        if (h1.getStart() < h2.getStart()) {
            return 3;
        }
        return 4;
    }

    public synchronized void setErrorDescriptions(final String layer, final Collection<? extends ErrorDescription> errors) {
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    AnnotationHolder.this.setErrorDescriptionsImpl(AnnotationHolder.this.file, layer, errors);
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.WARNING, e.getMessage(), e);
                }
            }
        });
    }

    private synchronized void setErrorDescriptionsImpl(FileObject file, String layer, Collection<? extends ErrorDescription> errors) throws IOException {
        long start;
        block15: {
            start = System.currentTimeMillis();
            if (file != null) break block15;
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + layer, new Object[]{file, end - start});
            return;
        }
        try {
            List<ErrorDescription> layersErrors = this.getErrorsForLayer(layer);
            HashSet<Integer> primaryLines = new HashSet<Integer>();
            HashSet<Integer> allLines = new HashSet<Integer>();
            for (ErrorDescription ed : layersErrors) {
                List<Integer> list = this.errors2Lines.remove(ed);
                assert (list != null);
                boolean first = true;
                for (Integer line : list) {
                    this.getErrorsForLine(line).remove(ed);
                    if (first) {
                        primaryLines.add(line);
                    }
                    allLines.add(line);
                    first = false;
                }
            }
            ArrayList<ErrorDescription> validatedErrors = new ArrayList<ErrorDescription>();
            for (ErrorDescription errorDescription : errors) {
                if (errorDescription.getRange() == null) continue;
                validatedErrors.add(errorDescription);
                ArrayList<Integer> lines = new ArrayList<Integer>();
                int startLine = errorDescription.getRange().getBegin().getLine();
                int endLine = errorDescription.getRange().getEnd().getLine();
                for (int cntr = startLine; cntr <= endLine; ++cntr) {
                    lines.add(cntr);
                }
                this.errors2Lines.put(errorDescription, lines);
                boolean first = true;
                for (Integer line : lines) {
                    this.getErrorsForLine(line).add(errorDescription);
                    if (first) {
                        primaryLines.add(line);
                    }
                    allLines.add(line);
                    first = false;
                }
            }
            layersErrors.clear();
            layersErrors.addAll(validatedErrors);
            for (Integer n : primaryLines) {
                this.updateAnnotationOnLine(n);
            }
            for (Integer n : allLines) {
                this.updateHighlightsOnLine(n);
            }
            this.doUpdateHighlight(file);
            this.updateVisibleRanges();
        }
        catch (BadLocationException ex) {
            try {
                throw (IOException)new IOException().initCause(ex);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + layer, new Object[]{file, end - start});
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + layer, new Object[]{file, end - start});
    }

    public synchronized boolean hasErrors() {
        for (ErrorDescription e : this.errors2Lines.keySet()) {
            if (e.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public synchronized List<ErrorDescription> getErrors() {
        return new ArrayList<ErrorDescription>(this.errors2Lines.keySet());
    }

    public synchronized List<Annotation> getAnnotations() {
        return new ArrayList<Annotation>(this.line2Annotations.values());
    }

    static {
        COLORINGS.put(Severity.DISABLED, new Coloring());
        COLORINGS.put(Severity.ERROR, new Coloring(null, 0, null, null, null, null, new Color(255, 0, 0)));
        COLORINGS.put(Severity.WARNING, new Coloring(null, 0, null, null, null, null, new Color(192, 192, 0)));
        COLORINGS.put(Severity.VERIFIER, new Coloring(null, 0, null, null, null, null, new Color(255, 213, 85)));
        COLORINGS.put(Severity.HINT, new Coloring());
        COLORINGS.put(Severity.TODO, new Coloring(Font.decode(null).deriveFont(1), 2, Color.BLUE, null));
        file2Holder = new HashMap<FileObject, AnnotationHolder>();
        INSTANCE = new RequestProcessor("AnnotationHolder");
    }

    static interface Attacher {
        public void attachAnnotation(int var1, ParseErrorAnnotation var2) throws BadLocationException;

        public void detachAnnotation(Annotation var1);
    }

    final class LineAttacher
    implements Attacher {
        LineAttacher() {
        }

        public void attachAnnotation(int line, ParseErrorAnnotation a) throws BadLocationException {
            LineCookie lc = (LineCookie)AnnotationHolder.this.od.getCookie(LineCookie.class);
            Line lineRef = lc.getLineSet().getCurrent(line);
            a.attach((Annotatable)lineRef);
        }

        public void detachAnnotation(Annotation a) {
            a.detach();
        }
    }

    final class NbDocumentAttacher
    implements Attacher {
        NbDocumentAttacher() {
        }

        public void attachAnnotation(int line, ParseErrorAnnotation a) throws BadLocationException {
            Position lineStart = AnnotationHolder.this.doc.createPosition(NbDocument.findLineOffset((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (int)line));
            NbDocument.addAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Position)lineStart, (int)-1, (Annotation)a);
        }

        public void detachAnnotation(Annotation a) {
            if (AnnotationHolder.this.doc != null) {
                NbDocument.removeAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Annotation)a);
            }
        }
    }
}

