/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.modules.editor.hints.StaticFixList;
import org.netbeans.modules.editor.hints.borrowed.ListCompletionView;
import org.netbeans.modules.editor.hints.borrowed.ScrollCompletionPane;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class HintsUI
implements MouseListener,
KeyListener,
ChangeListener,
AWTEventListener {
    private static HintsUI INSTANCE;
    private static final String POPUP_NAME = "hintsPopup";
    static Logger UI_GESTURES_LOGGER;
    private JTextComponent comp;
    private LazyFixList hints = new StaticFixList();
    private Popup listPopup;
    private JLabel hintIcon;
    private ScrollCompletionPane hintListComponent;
    private JLabel errorTooltip;
    private PopupFactory pf = null;
    private ChangeInfo changes;
    private static String[] c;
    private static String[] tags;

    public static synchronized HintsUI getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new HintsUI();
        }
        return INSTANCE;
    }

    private HintsUI() {
        Registry.addChangeListener((ChangeListener)this);
        this.stateChanged(null);
    }

    public JTextComponent getComponent() {
        return this.comp;
    }

    public void setHints(LazyFixList hints, JTextComponent comp, boolean showPopup) {
        boolean show;
        if (this.hints.equals(hints) && this.comp == comp) {
            return;
        }
        if (comp != this.comp || !this.hints.equals(hints) && comp != null) {
            this.removePopups();
        }
        boolean bl = show = hints != null && comp != null;
        if (!show && this.comp != null) {
            this.removePopups();
        }
        this.hints = hints == null ? new StaticFixList() : hints;
        this.setComponent(comp);
        if (show) {
            this.showHints();
            if (showPopup) {
                this.showPopup();
            }
        }
    }

    public void setComponent(JTextComponent comp) {
        boolean change;
        boolean bl = change = this.comp != comp;
        if (change) {
            this.unregister();
            this.comp = comp;
            this.register();
        }
    }

    private void register() {
        if (this.comp == null) {
            return;
        }
        this.comp.addKeyListener(this);
    }

    private void unregister() {
        if (this.comp == null) {
            return;
        }
        this.comp.removeKeyListener(this);
    }

    public void removePopups() {
        if (this.comp == null) {
            return;
        }
        this.removeIconHint();
        this.removePopup();
    }

    private void removeIconHint() {
        Container c;
        if (this.hintIcon != null && (c = this.hintIcon.getParent()) != null) {
            Rectangle bds = this.hintIcon.getBounds();
            c.remove(this.hintIcon);
            c.repaint(bds.x, bds.y, bds.width, bds.height);
        }
    }

    private void removePopup() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.listPopup != null) {
            this.listPopup.hide();
            if (this.hintListComponent != null) {
                this.hintListComponent.getView().removeMouseListener(this);
            }
            if (this.errorTooltip != null) {
                this.errorTooltip.removeMouseListener(this);
            }
            this.hintListComponent = null;
            this.errorTooltip = null;
            this.listPopup = null;
            if (this.hintIcon != null) {
                this.hintIcon.setToolTipText(NbBundle.getMessage(HintsUI.class, (String)"HINT_Bulb"));
            }
        }
    }

    boolean isKnownComponent(Component c) {
        return c != null && (c == this.comp || c == this.hintIcon || c == this.hintListComponent || c instanceof Container && ((Container)c).isAncestorOf(this.hintListComponent));
    }

    private void showHints() {
        if (this.comp == null || !this.comp.isDisplayable() || !this.comp.isShowing()) {
            return;
        }
        this.configureBounds(this.getHintIcon());
    }

    private void configureBounds(JComponent jc) {
        JRootPane pane = this.comp.getRootPane();
        JLayeredPane lp = pane.getLayeredPane();
        Rectangle r = null;
        try {
            int pos = javax.swing.text.Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            r = this.comp.modelToView(pos);
        }
        catch (BadLocationException e) {
            this.setHints(null, null, false);
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        Point p = new Point(r.x - this.comp.getX(), r.y);
        Dimension d = jc.getPreferredSize();
        SwingUtilities.convertPointToScreen(p, this.comp);
        SwingUtilities.convertPointFromScreen(p, lp);
        jc.setBounds(p.x, p.y, d.width, d.height);
        lp.add((Component)jc, JLayeredPane.POPUP_LAYER);
        jc.setVisible(true);
        jc.repaint();
    }

    private JLabel getHintIcon() {
        if (this.hintIcon == null) {
            this.hintIcon = new JLabel();
            this.hintIcon.addMouseListener(this);
            this.hintIcon.setToolTipText(NbBundle.getMessage(HintsUI.class, (String)"HINT_Bulb"));
        }
        String iconBase = "org/netbeans/modules/editor/hints/resources/error.png";
        this.hintIcon.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)iconBase)));
        return this.hintIcon;
    }

    public void showPopup() {
        if (this.comp == null || this.hints.isComputed() && this.hints.getFixes().isEmpty()) {
            return;
        }
        if (this.hintIcon != null) {
            this.hintIcon.setToolTipText(null);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        assert (this.hintListComponent == null);
        this.hintListComponent = new ScrollCompletionPane(this.comp, this.hints, null, null);
        this.hintListComponent.getView().addMouseListener(this);
        this.hintListComponent.setName(POPUP_NAME);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        try {
            int pos = javax.swing.text.Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            Rectangle r = this.comp.modelToView(pos);
            Point p = new Point(r.x + 5, r.y + 20);
            SwingUtilities.convertPointToScreen(p, this.comp);
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, p.x, p.y);
            this.listPopup.show();
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify((Throwable)ble);
            this.setHints(null, null, false);
        }
    }

    public void showPopup(LazyFixList fixes, String description, JTextComponent component, Point position) {
        this.setHints(null, null, false);
        this.setComponent(component);
        if (this.comp == null || fixes == null) {
            return;
        }
        this.hints = fixes;
        Point p = new Point(position);
        SwingUtilities.convertPointToScreen(p, this.comp);
        if (this.hintIcon != null) {
            this.hintIcon.setToolTipText(null);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        if (!fixes.isComputed() || fixes.getFixes().isEmpty()) {
            assert (this.listPopup == null);
            this.errorTooltip = new JLabel("<html>" + this.translate(description));
            this.errorTooltip.setBorder(new LineBorder(Color.BLACK));
            this.errorTooltip.addMouseListener(this);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.errorTooltip, p.x, p.y);
        } else {
            assert (this.hintListComponent == null);
            this.hintListComponent = new ScrollCompletionPane(this.comp, fixes, null, null);
            this.hintListComponent.getView().addMouseListener(this);
            this.hintListComponent.setName(POPUP_NAME);
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, p.x, p.y);
        }
        this.listPopup.show();
    }

    private PopupFactory getPopupFactory() {
        if (this.pf == null) {
            this.pf = PopupFactory.getSharedInstance();
        }
        return this.pf;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.hintListComponent || e.getSource() instanceof ListCompletionView) {
            Fix f = null;
            Object selected = this.hintListComponent.getView().getSelectedValue();
            if (selected instanceof Fix) {
                f = (Fix)selected;
            }
            if (f != null) {
                JTextComponent c = this.comp;
                this.invokeHint(f);
                this.setHints(null, null, false);
                this.setComponent(c);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof JLabel && !this.isPopupActive()) {
            this.showPopup();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public boolean isActive() {
        boolean bulbShowing = this.hintIcon != null && this.hintIcon.isShowing();
        boolean popupShowing = this.hintListComponent != null && this.hintListComponent.isShowing();
        return bulbShowing || popupShowing;
    }

    public boolean isPopupActive() {
        return this.hintListComponent != null && this.hintListComponent.isShowing();
    }

    private ParseErrorAnnotation findAnnotation(Document doc, AnnotationDesc desc, int lineNum) {
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        AnnotationHolder annotations = AnnotationHolder.getInstance(od.getPrimaryFile());
        for (Annotation a : annotations.getAnnotations()) {
            ParseErrorAnnotation pa;
            if (!(a instanceof ParseErrorAnnotation) || lineNum != (pa = (ParseErrorAnnotation)a).getLineNumber() || !org.openide.util.Utilities.compareObjects((Object)desc.getShortDescription(), (Object)a.getShortDescription())) continue;
            return pa;
        }
        return null;
    }

    boolean invokeDefaultAction() {
        if (this.comp == null) {
            Logger.getLogger(HintsUI.class.getName()).log(Level.WARNING, "HintsUI.invokeDefaultAction called, but comp == null");
            return false;
        }
        Document doc = this.comp.getDocument();
        if (doc instanceof BaseDocument) {
            Annotations annotations = ((BaseDocument)doc).getAnnotations();
            try {
                Rectangle carretRectangle = this.comp.modelToView(this.comp.getCaretPosition());
                int line = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)this.comp.getCaretPosition());
                AnnotationDesc desc = annotations.getActiveAnnotation(line);
                Point p = this.comp.modelToView(Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)line)).getLocation();
                p.y += carretRectangle.height;
                ParseErrorAnnotation annotation = this.findAnnotation(doc, desc, line);
                if (annotation == null) {
                    return false;
                }
                this.showPopup(annotation.getFixes(), annotation.getDescription(), this.comp, p);
                return true;
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent e) {
        InputMap input;
        Object actionTag;
        boolean popupShowing;
        boolean errorTooltipShowing;
        if (this.comp == null) {
            return;
        }
        boolean bulbShowing = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl = errorTooltipShowing = this.errorTooltip != null && this.errorTooltip.isShowing();
        if (errorTooltipShowing) {
            this.removePopup();
            return;
        }
        boolean bl2 = popupShowing = this.hintListComponent != null && this.hintListComponent.isShowing();
        if (e.getKeyCode() == 10) {
            if (e.getModifiersEx() == 192 || e.getModifiersEx() == 512) {
                if (!popupShowing) {
                    this.invokeDefaultAction();
                    e.consume();
                }
            } else if (e.getModifiersEx() == 0 && popupShowing) {
                Fix f = null;
                Object selected = this.hintListComponent.getView().getSelectedValue();
                if (selected instanceof Fix) {
                    f = (Fix)selected;
                }
                if (f != null) {
                    this.invokeHint(f);
                }
                e.consume();
            }
        } else if (e.getKeyCode() == 27) {
            if (popupShowing) {
                this.removePopup();
            }
        } else if (popupShowing && (actionTag = (input = this.hintListComponent.getInputMap()).get(KeyStroke.getKeyStrokeForEvent(e))) != null) {
            Action a = this.hintListComponent.getActionMap().get(actionTag);
            a.actionPerformed(null);
            e.consume();
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeHint(final Fix f) {
        if (UI_GESTURES_LOGGER.isLoggable(Level.FINE)) {
            LogRecord rec = new LogRecord(Level.FINE, "GEST_HINT_INVOKED");
            rec.setResourceBundle(NbBundle.getBundle(HintsUI.class));
            rec.setParameters(new Object[]{f.getText()});
            UI_GESTURES_LOGGER.log(rec);
        }
        this.removePopups();
        JTextComponent component = this.comp;
        Cursor cur = component.getCursor();
        component.setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.Task t = null;
        try {
            t = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    HintsUI.this.changes = f.implement();
                }
            });
            if (t == null) return;
        }
        catch (Throwable throwable) {
            if (t == null) throw throwable;
            t.addTaskListener(new TaskListener(component, cur){
                final /* synthetic */ JTextComponent val$component;
                final /* synthetic */ Cursor val$cur;
                {
                    this.val$component = jTextComponent;
                    this.val$cur = cursor;
                }

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            HintsUI.open(HintsUI.this.changes, val$component);
                            val$component.setCursor(val$cur);
                        }
                    });
                }
            });
            throw throwable;
        }
        t.addTaskListener(new /* invalid duplicate definition of identical inner class */);
    }

    private static void open(ChangeInfo changes, JTextComponent component) {
        JTextComponent c = component;
        if (changes != null && changes.size() > 0) {
            ChangeInfo.Change change = changes.get(0);
            FileObject file = change.getFileObject();
            if (file != null) {
                try {
                    DataObject dob = DataObject.find((FileObject)file);
                    EditCookie ck = (EditCookie)dob.getCookie(EditCookie.class);
                    if (ck != null) {
                        ck.edit();
                    } else {
                        OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
                        oc.open();
                    }
                    EditorCookie edit = (EditorCookie)dob.getCookie(EditorCookie.class);
                    JEditorPane[] panes = edit.getOpenedPanes();
                    if (panes == null || panes.length <= 0) {
                        return;
                    }
                    c = panes[0];
                }
                catch (DataObjectNotFoundException donfe) {
                    ErrorManager.getDefault().notify((Throwable)donfe);
                    return;
                }
            }
            Position start = change.getStart();
            Position end = change.getEnd();
            if (start != null) {
                c.setSelectionStart(start.getOffset());
            }
            if (end != null) {
                c.setSelectionEnd(end.getOffset());
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTextComponent active = Registry.getMostActiveComponent();
        if (this.getComponent() != active) {
            this.setHints(null, null, false);
            this.setComponent(active);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Component comp;
        Container par;
        MouseEvent mv;
        if (aWTEvent instanceof MouseEvent && (mv = (MouseEvent)aWTEvent).getID() == 500 && mv.getClickCount() > 0 && (par = SwingUtilities.getAncestorNamed(POPUP_NAME, comp = (Component)aWTEvent.getSource())) == null) {
            this.removePopup();
        }
    }

    private String translate(String input) {
        for (int cntr = 0; cntr < c.length; ++cntr) {
            input = input.replaceAll(c[cntr], tags[cntr]);
        }
        return input;
    }

    static {
        UI_GESTURES_LOGGER = Logger.getLogger("org.netbeans.ui.editor.hints");
        c = new String[]{"&", "<", ">", "\n", "\""};
        tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};
    }
}

