/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakSet;

public class PersistentCache {
    private static PersistentCache INSTANCE = new PersistentCache();
    private static Map<FileObject, Set<FileObject>> fo2ContainedErrorFiles = new WeakHashMap<FileObject, Set<FileObject>>();
    private static Set<FileObject> knownObjects = new WeakSet();
    private FileObject cache = null;

    public static PersistentCache getDefault() {
        return INSTANCE;
    }

    private PersistentCache() {
    }

    public void addErrorFile(FileObject key, FileObject error) {
        Set<FileObject> contained = fo2ContainedErrorFiles.get(key);
        if (contained == null) {
            contained = new HashSet<FileObject>();
            fo2ContainedErrorFiles.put(key, contained);
        }
        if (contained.add(error)) {
            // empty if block
        }
        knownObjects.add(error);
    }

    public void removeErrorFile(FileObject key, FileObject error) {
        Set<FileObject> contained = fo2ContainedErrorFiles.get(key);
        if (contained == null) {
            contained = new HashSet<FileObject>();
            fo2ContainedErrorFiles.put(key, contained);
        }
        if (contained.remove(error)) {
            // empty if block
        }
        knownObjects.add(error);
    }

    public boolean hasErrors(FileObject file) {
        Set<FileObject> contained = fo2ContainedErrorFiles.get(file);
        return contained != null && !contained.isEmpty();
    }

    public boolean isKnown(FileObject file) {
        return knownObjects.contains(file);
    }

    private synchronized FileObject cacheFile() {
        if (this.cache == null) {
            try {
                String nbuser = System.getProperty("netbeans.user");
                File userDir = new File(nbuser);
                FileObject userDirFO = FileUtil.toFileObject((File)userDir);
                this.cache = FileUtil.createFolder((FileObject)userDirFO, (String)"var/cache/errors");
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.cache;
    }

    private FileObject getCacheFileFor(FileObject file) throws IOException {
        File f = FileUtil.toFile((FileObject)file);
        if (f == null) {
            return null;
        }
        String path = f.getAbsolutePath().replace(':', '-').replace(File.separatorChar, '-');
        FileObject directory = FileUtil.createFolder((FileObject)this.cacheFile(), (String)path);
        FileObject errors = directory.getFileObject("errors");
        if (errors == null) {
            errors = directory.createData("errors");
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCache() {
        for (FileObject file : fo2ContainedErrorFiles.keySet()) {
            try {
                FileObject cache = this.getCacheFileFor(file);
                if (cache == null) continue;
                FileLock lock = cache.lock();
                OutputStream out = cache.getOutputStream(lock);
                try {
                    Set<FileObject> errors = fo2ContainedErrorFiles.get(file);
                    for (FileObject f : errors) {
                        out.write(FileUtil.toFile((FileObject)f).getAbsolutePath().getBytes());
                        out.write(10);
                    }
                }
                finally {
                    out.close();
                    lock.releaseLock();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    void loadCache() {
        this.loadCacheRecursive("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCacheRecursive(String path) {
        FileObject f = this.cacheFile().getFileObject(path);
        FileObject[] children = f.getChildren();
        for (int cntr = 0; cntr < children.length; ++cntr) {
            FileObject c = children[cntr];
            if (!c.isFolder()) continue;
            this.loadCacheRecursive(path + "/" + c.getNameExt());
        }
        try {
            FileObject errors = f.getFileObject("errors");
            if (errors == null) {
                return;
            }
            InputStream ins = errors.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            HashSet<FileObject> errorFiles = new HashSet<FileObject>();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    File resolved = new File(line);
                    FileObject resolvedFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)resolved));
                    if (resolvedFO == null) continue;
                    errorFiles.add(resolvedFO);
                }
            }
            finally {
                reader.close();
            }
            FileObject original = FileUtil.toFileObject((File)new File("/", path));
            if (original != null) {
                fo2ContainedErrorFiles.put(original, errorFiles);
                knownObjects.add(original);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

