/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.editor.hints.options.ModelImpl;
import org.netbeans.modules.editor.hints.options.SeverityComboRenderer;
import org.netbeans.spi.editor.hints.ProviderDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AdvancedPanelImpl
extends JPanel {
    private ModelImpl model;
    public JComboBox eagerCombo;
    public JCheckBox jCheckBox1;
    public JComboBox jComboBox1;
    public JLabel jLabel1;
    public JTable jTable1;
    private static final String[] SEVERITIES_ARRAY = new String[]{"<html><font color=\"#808080\">disabled", "<html><font color=\"#800000\">error", "<html><font color=\"#808000\">warning", "<html><font color=\"#000080\">verifier", "<html><font color=\"#000080\">hint", "<html><font color=\"#000080\">todo"};
    static final List SEVERITIES = Arrays.asList(SEVERITIES_ARRAY);

    public AdvancedPanelImpl(ModelImpl model) {
        this.model = model;
        this.initComponents();
        AdvancedPanelImpl.loc(this.jCheckBox1, "CTL_enabled");
        AdvancedPanelImpl.loc(this.jLabel1, "CTL_eagerness");
        this.jTable1.setDefaultRenderer(Severity.class, new SeverityCellRenderer());
        JComboBox<Object> editor = new JComboBox<Object>(new Object[]{Severity.ERROR, Severity.WARNING, Severity.VERIFIER, Severity.HINT, Severity.TODO, Severity.DISABLED});
        editor.setRenderer(new SeverityComboRenderer());
        this.jTable1.setDefaultEditor(Severity.class, new DefaultCellEditor(editor));
        TableColumn c = this.jTable1.getColumnModel().getColumn(0);
        c.setHeaderValue("XXXXXXXXX");
        c.setHeaderRenderer(new HeaderTableCellRenderer());
        c.sizeWidthToFit();
        this.updateForCurrentProvider();
        this.eagerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{AdvancedPanelImpl.loc("LBL_eagerness_on_project_open"), AdvancedPanelImpl.loc("LBL_eagerness_on_demand"), AdvancedPanelImpl.loc("LBL_eagerness_lazy")}));
        this.eagerCombo.setSelectedIndex(2);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(AdvancedPanelImpl.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)AdvancedPanelImpl.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)AdvancedPanelImpl.loc(key));
        }
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.eagerCombo = new JComboBox();
        this.jComboBox1.setModel(new ComboModelImpl());
        this.jComboBox1.setSelectedIndex(this.jComboBox1.getModel().getSize() > 0 ? 0 : -1);
        this.jComboBox1.setRenderer(new RendererImpl());
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedPanelImpl.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Enabled");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedPanelImpl.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new OptionsTableModel());
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jLabel1.setText("Eagerness:");
        this.eagerCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedPanelImpl.this.eagerComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTable1, -1, 454, Short.MAX_VALUE).add((Component)this.jCheckBox1, -1, 454, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.eagerCombo, 0, 376, Short.MAX_VALUE)).add((Component)this.jComboBox1, 0, 454, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.eagerCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jComboBox1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTable1, -2, -1, -2).add((Component)this.jCheckBox1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void eagerComboActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.model.setProviderEnabled(this.getProviderDescription().getKey(), this.jCheckBox1.isSelected());
        int index = this.jComboBox1.getSelectedIndex();
        ((ComboModelImpl)this.jComboBox1.getModel()).fireContentsChanged(index, index);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.updateForCurrentProvider();
    }

    private void updateForCurrentProvider() {
        ProviderDescription desc = this.getProviderDescription();
        if (desc != null) {
            this.jCheckBox1.setSelected(this.model.isProviderEnabled(desc.getKey()));
            this.jCheckBox1.setEnabled(true);
        } else {
            this.jCheckBox1.setSelected(false);
            this.jCheckBox1.setEnabled(false);
        }
        ((OptionsTableModel)this.jTable1.getModel()).fireTableDataChanged();
    }

    private ProviderDescription getProviderDescription() {
        return (ProviderDescription)this.jComboBox1.getSelectedItem();
    }

    private final class ComboModelImpl
    extends DefaultComboBoxModel {
        private ComboModelImpl() {
        }

        public int getSize() {
            return AdvancedPanelImpl.this.model.getDescriptions().size();
        }

        public Object getElementAt(int index) {
            return AdvancedPanelImpl.this.model.getDescriptions().get(index);
        }

        public void fireContentsChanged(int start, int end) {
            super.fireContentsChanged(this, start, end);
        }
    }

    private static final class HeaderTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private HeaderTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            return this;
        }
    }

    private final class OptionsTableModel
    extends AbstractTableModel {
        private OptionsTableModel() {
        }

        public int getRowCount() {
            ProviderDescription desc = AdvancedPanelImpl.this.getProviderDescription();
            if (desc == null) {
                return 0;
            }
            return desc.getSupportedErrorKeys().size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Severity";
                }
                case 1: {
                    return "Name";
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Severity.class;
                }
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ProviderDescription desc = AdvancedPanelImpl.this.getProviderDescription();
            switch (columnIndex) {
                case 0: {
                    return AdvancedPanelImpl.this.model.getErrorSeverity(desc.getKey(), (String)desc.getSupportedErrorKeys().get(rowIndex));
                }
                case 1: {
                    return desc.getErrorDisplayName((String)desc.getSupportedErrorKeys().get(rowIndex));
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ProviderDescription desc = AdvancedPanelImpl.this.getProviderDescription();
            switch (columnIndex) {
                case 0: {
                    AdvancedPanelImpl.this.model.setSeverity(desc.getKey(), (String)desc.getSupportedErrorKeys().get(rowIndex), (Severity)((Object)aValue));
                    return;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }
    }

    private final class RendererImpl
    implements ListCellRenderer {
        private ListCellRenderer delegateTo = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            if (value == null) {
                text = "<none>";
            } else {
                text = ((ProviderDescription)value).getDisplayName();
                if (!AdvancedPanelImpl.this.model.isProviderEnabled(((ProviderDescription)value).getKey())) {
                    text = "<html><s>" + text;
                }
            }
            return this.delegateTo.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    private static final class SeverityCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateTo = HtmlRenderer.createRenderer();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.delegateTo.getTableCellRendererComponent(table, SEVERITIES.get(((Severity)((Object)value)).ordinal()), isSelected, hasFocus, row, column);
        }
    }
}

