/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.List;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;
import org.openide.util.Exceptions;

class FCLSupport {
    ListenerList<FileChangeListener> listeners;

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fcl) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add(fcl);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fcl) {
        if (this.listeners != null) {
            this.listeners.remove(fcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fe, Op operation) {
        List<FileChangeListener> fcls;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            fcls = this.listeners.getAllListeners();
        }
        for (FileChangeListener l : fcls) {
            FCLSupport.dispatchEvent(l, fe, operation);
        }
    }

    static final void dispatchEvent(FileChangeListener fcl, FileEvent fe, Op operation) {
        try {
            switch (operation) {
                case DATA_CREATED: {
                    fcl.fileDataCreated(fe);
                    break;
                }
                case FOLDER_CREATED: {
                    fcl.fileFolderCreated(fe);
                    break;
                }
                case FILE_CHANGED: {
                    fcl.fileChanged(fe);
                    break;
                }
                case FILE_DELETED: {
                    fcl.fileDeleted(fe);
                    break;
                }
                case FILE_RENAMED: {
                    fcl.fileRenamed((FileRenameEvent)fe);
                    break;
                }
                case ATTR_CHANGED: {
                    fcl.fileAttributeChanged((FileAttributeEvent)fe);
                    break;
                }
                default: {
                    throw new AssertionError((Object)operation);
                }
            }
        }
        catch (RuntimeException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.hasListeners();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Op {
        DATA_CREATED,
        FOLDER_CREATED,
        FILE_CHANGED,
        FILE_DELETED,
        FILE_RENAMED,
        ATTR_CHANGED;

    }
}

