/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = -98124752801761145L;
    private static RequestProcessor req = new RequestProcessor("JarFs - modification watcher");
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.JarFileSystem.REFRESH_TIME", 0);
    private static final long MEM_STREAM_SIZE = 100000L;
    private transient JarFile jar;
    private transient Manifest manifest;
    private File root = new File(".");
    private transient RequestProcessor.Task watcherTask = null;
    private transient RequestProcessor.Task closeTask = null;
    private transient long lastModification = 0L;
    private static final Logger LOGGER = Logger.getLogger(JarFileSystem.class.getName());
    private transient Object closeSync = new Object();
    private int checkTime = REFRESH_TIME;
    private transient long aliveCount = 0L;
    private transient Cache strongCache;
    private transient Reference<Cache> softCache = new SoftReference<Object>(null);
    private transient FileObject foRoot;
    private transient FileChangeListener fcl;

    public JarFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    @Deprecated
    public JarFileSystem(FileSystemCapability cap) {
        this();
        this.setCapability(cap);
    }

    @Override
    protected <T extends FileObject> Reference<T> createReference(T fo) {
        ++this.aliveCount;
        if (this.checkTime > 0 && this.watcherTask == null) {
            this.watcherTask = req.post(this.watcherTask(), this.checkTime);
        }
        return new Ref(this, fo);
    }

    private void freeReference() {
        --this.aliveCount;
        if (this.aliveCount == 0L) {
            if (this.watcherTask != null) {
                this.watcherTask.cancel();
                this.watcherTask = null;
            }
            this.strongCache = null;
            this.closeCurrentRoot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    JarFile j = this.reOpenJarFile();
                    this.manifest = j == null ? null : j.getManifest();
                    this.manifest = this.manifest == null ? null : new Manifest(this.manifest);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeCurrentRoot(false);
            }
            if (this.manifest == null) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    public void setJarFile(File aRoot) throws IOException, PropertyVetoException {
        this.setJarFile(aRoot, true);
    }

    private void _setSystemName(String s) throws PropertyVetoException {
        this.setSystemName(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJarFile(final File aRoot, boolean refreshRoot) throws IOException, PropertyVetoException {
        if (!aRoot.equals(FileUtil.normalizeFile(aRoot))) {
            throw new IllegalArgumentException("Parameter aRoot was not normalized. Was " + aRoot + " instead of " + FileUtil.normalizeFile(aRoot));
        }
        FileObject newRoot = null;
        String oldDisplayName = this.getDisplayName();
        if (this.getRefreshTime() > 0) {
            this.setRefreshTime(0);
        }
        if (aRoot == null) {
            FSException.io("EXC_NotValidFile", aRoot);
        }
        if (!aRoot.exists()) {
            FSException.io("EXC_FileNotExists", aRoot.getAbsolutePath());
        }
        if (!aRoot.canRead()) {
            FSException.io("EXC_CanntRead", aRoot.getAbsolutePath());
        }
        if (!aRoot.isFile()) {
            FSException.io("EXC_NotValidFile", aRoot.getAbsolutePath());
        }
        String s = aRoot.getAbsolutePath();
        s = s.intern();
        JarFile tempJar = null;
        try {
            tempJar = new JarFile(s);
            LOGGER.log(Level.FINE, "opened: " + System.currentTimeMillis() + "   " + s);
        }
        catch (ZipException e) {
            FSException.io("EXC_NotValidJarFile2", e.getLocalizedMessage(), s);
        }
        Object object = this.closeSync;
        synchronized (object) {
            this._setSystemName(s);
            this.closeCurrentRoot(false);
            this.jar = tempJar;
            this.root = new File(s);
            if (refreshRoot) {
                this.strongCache = null;
                this.softCache.clear();
                this.aliveCount = 0L;
                newRoot = this.refreshRoot();
                this.manifest = null;
                this.lastModification = 0L;
                if (newRoot != null) {
                    this.firePropertyChange("root", null, newRoot);
                }
            }
        }
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
        this.foRoot = FileUtil.toFileObject(this.root);
        if (this.foRoot != null && this.fcl == null) {
            this.fcl = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    if (JarFileSystem.this.watcherTask == null) {
                        JarFileSystem.this.parse(true);
                    }
                }

                public void fileRenamed(FileRenameEvent fe) {
                    File f = FileUtil.toFile(fe.getFile());
                    if (f != null && !f.equals(aRoot)) {
                        try {
                            JarFileSystem.this.setJarFile(f, false);
                        }
                        catch (IOException iex) {
                            ExternalUtil.exception(iex);
                        }
                        catch (PropertyVetoException pvex) {
                            ExternalUtil.exception(pvex);
                        }
                    }
                }

                public void fileDeleted(FileEvent fe) {
                    Enumeration<? extends FileObject> en = JarFileSystem.this.existingFileObjects(JarFileSystem.this.getRoot());
                    while (en.hasMoreElements()) {
                        AbstractFolder fo = (AbstractFolder)en.nextElement();
                        fo.validFlag = false;
                        fo.fileDeleted0(new FileEvent(fo));
                    }
                    JarFileSystem.this.refreshRoot();
                }
            };
            if (refreshRoot) {
                this.foRoot.addFileChangeListener(FileUtil.weakFileChangeListener(this.fcl, this.foRoot));
            }
        }
    }

    public File getJarFile() {
        return this.root;
    }

    @Override
    public String getDisplayName() {
        return this.root != null ? this.root.getAbsolutePath() : JarFileSystem.getString("JAR_UnknownJar");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void removeNotify() {
        this.closeCurrentRoot(true);
    }

    @Override
    @Deprecated
    public void prepareEnvironment(FileSystem.Environment env) {
        if (this.root != null) {
            env.addClassPath(this.root.getAbsolutePath());
        }
    }

    protected String[] children(String name) {
        Cache cache = this.getCache();
        return cache.getChildrenOf(name);
    }

    protected void createFolder(String name) throws IOException {
        throw new IOException();
    }

    protected void createData(String name) throws IOException {
        throw new IOException();
    }

    protected void rename(String oldName, String newName) throws IOException {
        throw new IOException();
    }

    protected void delete(String name) throws IOException {
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date lastModified(String name) {
        try {
            Date date = new Date(this.getEntry(name).getTime());
            return date;
        }
        finally {
            this.closeCurrentRoot(false);
        }
    }

    protected boolean folder(String name) {
        if ("".equals(name)) {
            return true;
        }
        Cache cache = this.getCache();
        return cache.isFolder(name);
    }

    protected boolean readOnly(String name) {
        return true;
    }

    protected String mimeType(String name) {
        return null;
    }

    protected long size(String name) {
        long retVal = this.getEntry(name).getSize();
        this.closeCurrentRoot(false);
        return retVal == -1L ? 0L : retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getMemInputStream(JarFile jf, JarEntry je) throws IOException {
        InputStream is = this.getInputStream4336753(jf, je);
        ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
        try {
            FileUtil.copy(is, os);
        }
        finally {
            os.close();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getTemporaryInputStream(JarFile jf, JarEntry je, boolean forceRecreate) throws IOException {
        File f;
        boolean createContent;
        String filePath = jf.getName();
        String entryPath = je.getName();
        StringBuffer jarCacheFolder = new StringBuffer("jarfscache");
        jarCacheFolder.append(System.getProperty("user.name")).append("/");
        File jarfscache = new File(System.getProperty("java.io.tmpdir"), jarCacheFolder.toString());
        if (!jarfscache.exists()) {
            jarfscache.mkdirs();
        }
        boolean bl = createContent = !(f = new File(jarfscache, JarFileSystem.temporaryName(filePath, entryPath))).exists();
        if (createContent) {
            f.createNewFile();
        } else {
            forceRecreate |= Math.abs(System.currentTimeMillis() - f.lastModified()) > 10000L;
        }
        if (createContent || forceRecreate) {
            InputStream is = this.getInputStream4336753(jf, je);
            try {
                FileOutputStream os = new FileOutputStream(f);
                try {
                    FileUtil.copy(is, os);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                is.close();
            }
        }
        f.deleteOnExit();
        return new FileInputStream(f);
    }

    private static String temporaryName(String filePath, String entryPath) {
        String fileHash = String.valueOf(filePath.hashCode());
        String entryHash = String.valueOf(entryPath.hashCode());
        StringBuffer sb = new StringBuffer();
        sb.append("f").append(fileHash).append("e").append(entryHash);
        return sb.toString().replace('-', 'x');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream inputStream(String name) throws FileNotFoundException {
        InputStream is = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                JarEntry je;
                JarFile j = this.reOpenJarFile();
                if (j != null && (je = j.getJarEntry(name)) != null) {
                    is = je.getSize() < 100000L ? this.getMemInputStream(j, je) : this.getTemporaryInputStream(j, je, this.strongCache != null);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        finally {
            this.closeCurrentRoot(false);
        }
        if (is == null) {
            throw new FileNotFoundException(name);
        }
        return is;
    }

    private InputStream getInputStream4336753(JarFile j, JarEntry je) throws IOException {
        InputStream in = null;
        while (in == null) {
            try {
                in = j.getInputStream(je);
                break;
            }
            catch (NullPointerException ex) {
            }
        }
        return in;
    }

    protected OutputStream outputStream(String name) throws IOException {
        throw new IOException();
    }

    protected void lock(String name) throws IOException {
        FSException.io("EXC_CannotLock", name, this.getDisplayName(), name);
    }

    protected void unlock(String name) {
    }

    protected void markUnimportant(String name) {
    }

    protected Object readAttribute(String name, String attrName) {
        Attributes attr = this.getManifest().getAttributes(name);
        try {
            return attr == null ? null : attr.getValue(attrName);
        }
        catch (IllegalArgumentException iax) {
            return null;
        }
    }

    protected void writeAttribute(String name, String attrName, Object value) throws IOException {
        throw new IOException();
    }

    protected Enumeration<String> attributes(String name) {
        Attributes attr = this.getManifest().getAttributes(name);
        if (attr != null) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ToString
            implements Enumerations.Processor<Object, String> {
                ToString() {
                }

                public String process(Object obj, Collection<Object> ignore) {
                    return obj.toString();
                }
            }
            return Enumerations.convert(Collections.enumeration(attr.keySet()), (Enumerations.Processor)new ToString());
        }
        return Enumerations.empty();
    }

    protected void renameAttributes(String oldName, String newName) {
    }

    protected void deleteAttributes(String name) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeCurrentRoot(false);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.closeSync = new Object();
        this.strongCache = null;
        this.softCache = new SoftReference<Object>(null);
        this.aliveCount = 0L;
        try {
            this.setJarFile(this.root);
        }
        catch (PropertyVetoException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (IOException iex) {
            ExternalUtil.log(iex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFile reOpenJarFile() throws IOException {
        Object object = this.closeSync;
        synchronized (object) {
            JarFile j;
            if (this.closeTask != null) {
                this.closeTask.cancel();
            }
            if ((j = this.jar) != null) {
                return j;
            }
            if (this.jar == null && this.root != null) {
                this.jar = new JarFile(this.root);
                LOGGER.log(Level.FINE, "opened: " + System.currentTimeMillis() + "   " + this.root.getAbsolutePath());
            }
            return this.jar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentRoot(boolean isRealClose) {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.closeTask != null) {
                this.closeTask.cancel();
            }
            if (isRealClose) {
                this.realClose().run();
            } else {
                this.closeTask = req.post(this.realClose(), 300);
            }
        }
    }

    private Runnable realClose() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = JarFileSystem.this.closeSync;
                synchronized (object) {
                    if (JarFileSystem.this.jar != null) {
                        try {
                            JarFileSystem.this.jar.close();
                            LOGGER.log(Level.FINE, "closed: " + System.currentTimeMillis() + "   " + JarFileSystem.this.root.getAbsolutePath());
                        }
                        catch (Exception exc) {
                            ExternalUtil.exception(exc);
                        }
                        finally {
                            JarFileSystem.this.jar = null;
                            JarFileSystem.this.closeTask = null;
                        }
                    }
                }
            }
        };
    }

    private Cache getCache() {
        Cache ret = this.strongCache;
        if (ret == null) {
            ret = this.softCache.get();
        }
        if (ret == null) {
            ret = this.parse(false);
        }
        assert (ret != null);
        return ret;
    }

    private void refreshExistingFileObjects() {
        Cache cache = this.getCache();
        String[] empty = new String[]{};
        Enumeration<? extends FileObject> en = this.existingFileObjects(this.getRoot());
        while (en.hasMoreElements()) {
            AbstractFolder fo = (AbstractFolder)en.nextElement();
            assert (fo != null);
            if (fo.isFolder() && !fo.isInitialized()) continue;
            String[] children = cache.getChildrenOf(fo.getPath());
            if (children == null) {
                children = empty;
            }
            fo.refresh(null, null, true, true, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cache parse(boolean refresh) {
        Cache cache;
        block20: {
            JarFile j = null;
            this.beginAtomicAction();
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    long start = System.currentTimeMillis();
                    this.lastModification = 0L;
                    this.closeCurrentRoot(false);
                    for (int i = 0; i <= 2; ++i) {
                        try {
                            j = this.reOpenJarFile();
                            break;
                        }
                        catch (IOException ex) {
                            if (i < 2) continue;
                            Cache cache2 = Cache.INVALID;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 8, 11] lbl16 : MonitorExitStatement: MONITOREXIT : var5_3
                            this.closeCurrentRoot(false);
                            if (refresh) {
                                this.refreshExistingFileObjects();
                            }
                            if (this.checkTime > 0 && this.watcherTask == null) {
                                this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                            }
                            this.finishAtomicAction();
                            return cache2;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeCurrentRoot(false);
                if (refresh) {
                    this.refreshExistingFileObjects();
                }
                if (this.checkTime > 0 && this.watcherTask == null) {
                    this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                }
                this.finishAtomicAction();
                throw throwable;
            }
            {
                try {
                    Enumeration<JarEntry> en = j.entries();
                    Cache newCache = new Cache(en);
                    this.lastModification = this.root.lastModified();
                    this.strongCache = newCache;
                    this.softCache = new SoftReference<Cache>(newCache);
                    cache = newCache;
                    // MONITOREXIT @DISABLED, blocks:[4, 7] lbl40 : MonitorExitStatement: MONITOREXIT : var5_3
                    this.closeCurrentRoot(false);
                    if (refresh) {
                        this.refreshExistingFileObjects();
                    }
                    if (this.checkTime <= 0 || this.watcherTask != null) break block20;
                }
                catch (Throwable t) {
                    Cache cache3 = Cache.INVALID;
                    // MONITOREXIT @DISABLED, blocks:[7, 9] lbl48 : MonitorExitStatement: MONITOREXIT : var5_3
                    this.closeCurrentRoot(false);
                    if (refresh) {
                        this.refreshExistingFileObjects();
                    }
                    if (this.checkTime > 0 && this.watcherTask == null) {
                        this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                    }
                    this.finishAtomicAction();
                    return cache3;
                }
            }
            this.watcherTask = req.post(this.watcherTask(), this.checkTime);
        }
        this.finishAtomicAction();
        return cache;
    }

    private Runnable watcherTask() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (JarFileSystem.this.root == null) {
                        return;
                    }
                    if (JarFileSystem.this.root.lastModified() != JarFileSystem.this.lastModification) {
                        JarFileSystem.this.parse(true);
                    }
                }
                finally {
                    if (JarFileSystem.this.watcherTask != null) {
                        JarFileSystem.this.watcherTask.schedule(JarFileSystem.this.checkTime);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JarEntry getEntry(String file) {
        JarFile j = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                j = this.reOpenJarFile();
                JarEntry je = j.getJarEntry(file);
                if (je != null) {
                    return je;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JarEntry(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache {
        static Cache INVALID = new Cache(Enumerations.empty());
        byte[] names = new byte[1000];
        private int nameOffset = 0;
        int[] EMPTY = new int[0];
        private Map<String, Folder> folders = new HashMap<String, Folder>();

        public Cache(Enumeration<JarEntry> en) {
            this.parse(en);
            this.trunc();
        }

        public boolean isFolder(String name) {
            return this.folders.get(name) != null;
        }

        public String[] getChildrenOf(String folder) {
            Folder fol = this.folders.get(folder);
            if (fol != null) {
                return fol.getNames();
            }
            return new String[0];
        }

        private void parse(Enumeration<JarEntry> en) {
            this.folders.put("", new Folder());
            while (en.hasMoreElements()) {
                JarEntry je = en.nextElement();
                String name = je.getName();
                boolean isFolder = false;
                if ((name = name.replace('\\', '/')).startsWith("/")) {
                    name = name.substring(1);
                }
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                    isFolder = true;
                }
                int lastSlash = name.lastIndexOf(47);
                String dirName = "";
                String realName = name;
                if (lastSlash > 0) {
                    dirName = name.substring(0, lastSlash);
                    realName = name.substring(lastSlash + 1);
                }
                if (isFolder) {
                    this.getFolder(name);
                    continue;
                }
                Folder fl = this.getFolder(dirName);
                fl.addChild(realName);
            }
        }

        private Folder getFolder(String name) {
            Folder fl = this.folders.get(name);
            if (fl == null) {
                int lastSlash = name.lastIndexOf(47);
                String dirName = "";
                String realName = name;
                if (lastSlash > 0) {
                    dirName = name.substring(0, lastSlash);
                    realName = name.substring(lastSlash + 1);
                }
                this.getFolder(dirName).addChild(realName);
                fl = new Folder();
                this.folders.put(name, fl);
            }
            return fl;
        }

        private void trunc() {
            byte[] newNames = new byte[this.nameOffset];
            System.arraycopy(this.names, 0, newNames, 0, this.nameOffset);
            this.names = newNames;
            Iterator<Folder> it = this.folders.values().iterator();
            while (it.hasNext()) {
                it.next().trunc();
            }
        }

        private int putName(byte[] name) {
            int start = this.nameOffset;
            if (start + name.length > this.names.length) {
                byte[] newNames = new byte[this.names.length * 2 + name.length];
                System.arraycopy(this.names, 0, newNames, 0, start);
                this.names = newNames;
            }
            System.arraycopy(name, 0, this.names, start, name.length);
            this.nameOffset += name.length;
            return start;
        }

        private class Folder {
            private int[] indices;
            private int idx;

            public Folder() {
                this.indices = Cache.this.EMPTY;
                this.idx = 0;
            }

            public String[] getNames() {
                String[] ret = new String[this.idx / 2];
                for (int i = 0; i < ret.length; ++i) {
                    byte[] name = new byte[this.indices[2 * i + 1]];
                    System.arraycopy(Cache.this.names, this.indices[2 * i], name, 0, name.length);
                    try {
                        ret[i] = new String(name, "UTF-8");
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new InternalError("No UTF-8");
                    }
                }
                return ret;
            }

            void addChild(String name) {
                if (this.idx + 2 > this.indices.length) {
                    int[] newInd = new int[2 * this.indices.length + 2];
                    System.arraycopy(this.indices, 0, newInd, 0, this.idx);
                    this.indices = newInd;
                }
                try {
                    byte[] bytes = name.getBytes("UTF-8");
                    this.indices[this.idx++] = Cache.this.putName(bytes);
                    this.indices[this.idx++] = bytes.length;
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalError("No UTF-8");
                }
            }

            void trunc() {
                if (this.indices.length > this.idx) {
                    int[] newInd = new int[this.idx];
                    System.arraycopy(this.indices, 0, newInd, 0, this.idx);
                    this.indices = newInd;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        static final long serialVersionUID = -67233308132567232L;
        private JarFileSystem fs;

        public Impl(JarFileSystem fs) {
            this.fs = fs;
        }

        @Override
        public String[] children(String name) {
            return this.fs.children(name);
        }

        @Override
        public void createFolder(String name) throws IOException {
            this.fs.createFolder(name);
        }

        @Override
        public void createData(String name) throws IOException {
            this.fs.createData(name);
        }

        @Override
        public void rename(String oldName, String newName) throws IOException {
            this.fs.rename(oldName, newName);
        }

        @Override
        public void delete(String name) throws IOException {
            this.fs.delete(name);
        }

        @Override
        public Date lastModified(String name) {
            return this.fs.lastModified(name);
        }

        @Override
        public boolean folder(String name) {
            return this.fs.folder(name);
        }

        @Override
        public boolean readOnly(String name) {
            return this.fs.readOnly(name);
        }

        @Override
        public String mimeType(String name) {
            return this.fs.mimeType(name);
        }

        @Override
        public long size(String name) {
            return this.fs.size(name);
        }

        @Override
        public InputStream inputStream(String name) throws FileNotFoundException {
            return this.fs.inputStream(name);
        }

        @Override
        public OutputStream outputStream(String name) throws IOException {
            return this.fs.outputStream(name);
        }

        @Override
        public void lock(String name) throws IOException {
            this.fs.lock(name);
        }

        @Override
        public void unlock(String name) {
            this.fs.unlock(name);
        }

        @Override
        public void markUnimportant(String name) {
            this.fs.markUnimportant(name);
        }

        @Override
        public Object readAttribute(String name, String attrName) {
            return this.fs.readAttribute(name, attrName);
        }

        @Override
        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            this.fs.writeAttribute(name, attrName, value);
        }

        @Override
        public Enumeration<String> attributes(String name) {
            return this.fs.attributes(name);
        }

        @Override
        public void renameAttributes(String oldName, String newName) {
            this.fs.renameAttributes(oldName, newName);
        }

        @Override
        public void deleteAttributes(String name) {
            this.fs.deleteAttributes(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ref<T extends FileObject>
    extends WeakReference<T>
    implements Runnable {
        final /* synthetic */ JarFileSystem this$0;

        public Ref(T fo) {
            this.this$0 = var1_1;
            super(fo, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            this.this$0.freeReference();
        }
    }
}

