/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Union2;

final class MIMESupport {
    private static final Reference<FileObject> EMPTY = new WeakReference<Object>(null);
    private static Reference<FileObject> lastFo = EMPTY;
    private static Reference<FileObject> lastCfo = EMPTY;
    private static Object lock = new Object();
    private static Logger ERR = Logger.getLogger(MIMESupport.class.getName());

    private MIMESupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findMIMEType(FileObject fo, String def) {
        if (!fo.isValid() || fo.isFolder()) {
            return null;
        }
        if (def != null && !CachedFileObject.isAnyResolver()) {
            return def;
        }
        CachedFileObject cfo = null;
        try {
            Object object = lock;
            synchronized (object) {
                CachedFileObject lcfo = (CachedFileObject)lastCfo.get();
                cfo = lcfo == null || fo != lastFo.get() || MIMESupport.timeOf(fo) != MIMESupport.timeOf(lcfo) ? new CachedFileObject(fo) : lcfo;
                lastCfo = EMPTY;
            }
            object = cfo.getMIMEType(def);
            return object;
        }
        finally {
            Object object = lock;
            synchronized (object) {
                lastFo = new WeakReference<FileObject>(fo);
                lastCfo = new WeakReference<CachedFileObject>(cfo);
            }
        }
    }

    private static long timeOf(FileObject fo) {
        if (fo == null) {
            throw new NullPointerException();
        }
        Date d = fo.lastModified();
        assert (d != null) : "Null lastModified from " + fo;
        return d.getTime();
    }

    static MIMEResolver[] getResolvers() {
        return CachedFileObject.getResolvers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedFileObject
    extends FileObject
    implements FileChangeListener {
        static Lookup.Result<MIMEResolver> result;
        private static Union2<MIMEResolver[], Set<Thread>> resolvers;
        private static MIMEResolver[] previousResolvers;
        String mimeType;
        Date lastModified;
        CachedInputStream fixIt;
        FileObject fileObj;

        CachedFileObject(FileObject fo) {
            this.fileObj = fo;
            this.lastModified = this.fileObj.lastModified();
            this.fileObj.addFileChangeListener(FileUtil.weakFileChangeListener(this, this.fileObj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MIMEResolver[] getResolvers() {
            Class<CachedFileObject> clazz = CachedFileObject.class;
            synchronized (CachedFileObject.class) {
                HashSet<Thread> creators;
                if (resolvers != null && resolvers.hasFirst()) {
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return (MIMEResolver[])resolvers.first();
                }
                if (resolvers != null) {
                    creators = (HashSet<Thread>)resolvers.second();
                    if (creators.contains(Thread.currentThread())) {
                        ERR.fine("Stack Overflow prevention. Returning previousResolvers: " + previousResolvers);
                        MIMEResolver[] toRet = previousResolvers;
                        if (toRet == null) {
                            toRet = new MIMEResolver[]{};
                        }
                        // ** MonitorExit[var1] (shouldn't be in output)
                        return toRet;
                    }
                } else {
                    creators = new HashSet<Thread>();
                    resolvers = Union2.createSecond(creators);
                }
                if (result == null) {
                    result = Lookup.getDefault().lookupResult(MIMEResolver.class);
                    result.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent evt) {
                            Class<CachedFileObject> clazz = CachedFileObject.class;
                            synchronized (CachedFileObject.class) {
                                ERR.fine("Clearing cache");
                                Union2 prev = resolvers;
                                if (prev != null && prev.hasFirst()) {
                                    CachedFileObject.access$302((MIMEResolver[])prev.first());
                                }
                                resolvers = null;
                                lastFo = EMPTY;
                                lastCfo = EMPTY;
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
                creators.add(Thread.currentThread());
                // ** MonitorExit[var1] (shouldn't be in output)
                ERR.fine("Computing resolvers");
                MIMEResolver[] toRet = result.allInstances().toArray(new MIMEResolver[0]);
                ERR.fine("Resolvers computed");
                Class<CachedFileObject> clazz2 = CachedFileObject.class;
                synchronized (CachedFileObject.class) {
                    if (resolvers != null && resolvers.hasSecond() && resolvers.second() == creators) {
                        resolvers = Union2.createFirst((Object)toRet);
                        previousResolvers = null;
                        ERR.fine("Resolvers assigned");
                    } else {
                        ERR.fine("Somebody else computes resolvers: " + resolvers);
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return toRet;
                }
            }
        }

        public static boolean isAnyResolver() {
            return CachedFileObject.getResolvers().length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        @Override
        public String getMIMEType() {
            return this.getMIMEType(null);
        }

        public String getMIMEType(String def) {
            if (this.mimeType == null) {
                this.mimeType = this.resolveMIME(def);
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMIME(String def) {
            String retVal = null;
            MIMEResolver[] local = CachedFileObject.getResolvers();
            try {
                for (int i = 0; i < local.length; ++i) {
                    retVal = local[i].findMIMEType(this);
                    if (retVal == null) continue;
                    String string = retVal;
                    return string;
                }
                if (def != null) {
                    String string = def;
                    return string;
                }
                String string = "content/unknown";
                return string;
            }
            finally {
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
            }
        }

        @Override
        public Date lastModified() {
            if (this.lastModified != null) {
                return this.lastModified;
            }
            this.lastModified = this.fileObj.lastModified();
            return this.lastModified;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                InputStream is = this.fileObj.getInputStream();
                if (!(is instanceof BufferedInputStream)) {
                    is = new BufferedInputStream(is);
                }
                this.fixIt = new CachedInputStream(is);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.freeCaches();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.freeCaches();
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.freeCaches();
        }

        @Override
        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        @Override
        @Deprecated
        public String getPackageNameExt(char separatorChar, char extSepChar) {
            return this.fileObj.getPackageNameExt(separatorChar, extSepChar);
        }

        @Override
        public FileObject copy(FileObject target, String name, String ext) throws IOException {
            return this.fileObj.copy(target, name, ext);
        }

        @Override
        protected void fireFileDeletedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileDeletedEvent(en, fe);
        }

        @Override
        protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileFolderCreatedEvent(en, fe);
        }

        @Override
        @Deprecated
        public void setImportant(boolean b) {
            this.fileObj.setImportant(b);
        }

        @Override
        public boolean isData() {
            return this.fileObj.isData();
        }

        @Override
        public Object getAttribute(String attrName) {
            return this.fileObj.getAttribute(attrName);
        }

        @Override
        public Enumeration<? extends FileObject> getFolders(boolean rec) {
            return this.fileObj.getFolders(rec);
        }

        @Override
        public void delete(FileLock lock) throws IOException {
            this.fileObj.delete(lock);
        }

        @Override
        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        @Override
        public Enumeration<? extends FileObject> getData(boolean rec) {
            return this.fileObj.getData(rec);
        }

        @Override
        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        @Override
        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        @Override
        public boolean isValid() {
            return this.fileObj.isValid();
        }

        @Override
        @Deprecated
        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        @Override
        public String getExt() {
            return this.fileObj.getExt();
        }

        @Override
        public String getName() {
            return this.fileObj.getName();
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fcl) {
            this.fileObj.removeFileChangeListener(fcl);
        }

        @Override
        protected void fireFileRenamedEvent(Enumeration<FileChangeListener> en, FileRenameEvent fe) {
            this.fileObj.fireFileRenamedEvent(en, fe);
        }

        @Override
        public void refresh(boolean expected) {
            this.fileObj.refresh(expected);
        }

        @Override
        protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> en, FileAttributeEvent fe) {
            this.fileObj.fireFileAttributeChangedEvent(en, fe);
        }

        @Override
        public long getSize() {
            return this.fileObj.getSize();
        }

        @Override
        public Enumeration<String> getAttributes() {
            return this.fileObj.getAttributes();
        }

        @Override
        public void rename(FileLock lock, String name, String ext) throws IOException {
            this.fileObj.rename(lock, name, ext);
        }

        @Override
        protected void fireFileChangedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileChangedEvent(en, fe);
        }

        @Override
        public FileObject getFileObject(String name, String ext) {
            return this.fileObj.getFileObject(name, ext);
        }

        @Override
        public void refresh() {
            this.fileObj.refresh();
        }

        @Override
        public FileObject createData(String name, String ext) throws IOException {
            return this.fileObj.createData(name, ext);
        }

        @Override
        public void addFileChangeListener(FileChangeListener fcl) {
            this.fileObj.addFileChangeListener(fcl);
        }

        @Override
        protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileDataCreatedEvent(en, fe);
        }

        @Override
        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        @Override
        public FileObject createFolder(String name) throws IOException {
            return this.fileObj.createFolder(name);
        }

        @Override
        public Enumeration<? extends FileObject> getChildren(boolean rec) {
            return this.fileObj.getChildren(rec);
        }

        @Override
        public void setAttribute(String attrName, Object value) throws IOException {
            this.fileObj.setAttribute(attrName, value);
        }

        @Override
        @Deprecated
        public String getPackageName(char separatorChar) {
            return this.fileObj.getPackageName(separatorChar);
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        @Override
        public OutputStream getOutputStream(FileLock lock) throws IOException {
            return this.fileObj.getOutputStream(lock);
        }

        @Override
        public boolean existsExt(String ext) {
            return this.fileObj.existsExt(ext);
        }

        @Override
        public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
            return this.fileObj.move(lock, target, name, ext);
        }

        @Override
        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CachedFileObject) {
                return ((CachedFileObject)obj).fileObj.equals(this.fileObj);
            }
            return super.equals(obj);
        }

        static /* synthetic */ MIMEResolver[] access$302(MIMEResolver[] x0) {
            previousResolvers = x0;
            return x0;
        }
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = null;
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream is) {
            this.inputStream = is;
        }

        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        public int read() throws IOException {
            int c;
            int n;
            if (this.eof) {
                return -1;
            }
            if (this.pos < this.len) {
                int c2;
                c2 = (c2 = this.buffer[this.pos++]) < 0 ? c2 + 256 : c2;
                return c2;
            }
            int buflen = this.len > 0 ? this.len * 2 : 256;
            byte[] buf = new byte[buflen];
            if (this.len > 0) {
                System.arraycopy(this.buffer, 0, buf, 0, this.len);
            }
            if ((n = this.inputStream.read(buf, this.len, buflen - this.len)) <= 0) {
                this.eof = true;
                return -1;
            }
            this.buffer = buf;
            this.len += n;
            c = (c = this.buffer[this.pos++]) < 0 ? c + 256 : c;
            return c;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String retVal = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            retVal = retVal + new String(this.buffer);
            return retVal;
        }
    }
}

