/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemoryFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Attr {
    private static final Logger ERR = Logger.getLogger(MemoryFileSystem.class.getName());
    private Date created = new Date();
    private Map<String, Entry> entries = this.initEntry();

    private void _setSystemName(String s) throws PropertyVetoException {
        this.setSystemName(s);
    }

    public MemoryFileSystem() {
        this.attr = this;
        this.list = this;
        this.change = this;
        this.info = this;
        try {
            this._setSystemName("MemoryFileSystem" + String.valueOf(System.identityHashCode(this)));
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public MemoryFileSystem(String[] resources) {
        this();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < resources.length; ++i) {
            sb.append(resources[i]);
            this.getOrCreateEntry((String)resources[i]).data = (byte[])(resources[i].endsWith("/") ? null : new byte[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getOrCreateEntry(String n) {
        if (n.length() > 0 && n.charAt(0) == '/') {
            n = n.substring(1);
        }
        boolean isValidEntry = this.isValidEntry(n);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Entry x = this.entries.get(n);
            if (x == null || !isValidEntry) {
                x = new Entry(n);
                this.entries.put(n, x);
            }
            return x;
        }
    }

    private boolean isValidEntry(String n) {
        return this.isValidEntry(n, null);
    }

    private boolean isValidEntry(String n, Boolean expectedResult) {
        Reference<? extends FileObject> ref;
        boolean retval;
        boolean bl = retval = n.length() == 0;
        if (n.length() > 0 && n.charAt(0) == '/') {
            n = n.substring(1);
        }
        Entry x = this.entries.get(n);
        FileObject fo = null;
        if (x != null && (ref = this.findReference(n)) != null) {
            fo = ref.get();
            boolean bl2 = retval = fo != null ? fo.isValid() : true;
        }
        if (ERR.isLoggable(Level.FINE) && expectedResult != null && retval != expectedResult) {
            MemoryFileSystem.logMessage("entry: " + x + " isValidReference.fo: " + (fo == null ? "null" : (fo.isValid() ? "valid" : "invalid")));
        }
        return retval;
    }

    @Override
    public String getDisplayName() {
        return "MemoryFileSystem";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Enumeration<String> attributes(String name) {
        if (!this.isValidEntry(name)) {
            return Enumerations.empty();
        }
        return Collections.enumeration(this.getOrCreateEntry((String)name).attrs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] children(String f) {
        if (f.length() > 0 && f.charAt(0) == '/') {
            f = f.substring(1);
        }
        if (f.length() > 0 && !f.endsWith("/")) {
            f = f + "/";
        }
        HashSet<String> l = new HashSet<String>();
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            for (String name : this.entries.keySet()) {
                if (!name.startsWith(f) && f.trim().length() != 0) continue;
                int i = name.indexOf(47, f.length());
                String child = null;
                child = i > 0 ? name.substring(f.length(), i) : name.substring(f.length());
                if (child.trim().length() <= 0) continue;
                l.add(child);
            }
            return l.toArray(new String[0]);
        }
    }

    @Override
    public void createData(String name) throws IOException {
        if (this.isValidEntry(name, Boolean.FALSE)) {
            StringBuffer message = new StringBuffer();
            message.append("File already exists: ").append(name);
            throw new IOException(message.toString());
        }
        this.getOrCreateEntry((String)name).data = new byte[0];
    }

    @Override
    public void createFolder(String name) throws IOException {
        if (this.isValidEntry(name, Boolean.FALSE)) {
            StringBuffer message = new StringBuffer();
            message.append("Folder already exists: ").append(name);
            throw new IOException(message.toString());
        }
        this.getOrCreateEntry((String)name).data = null;
    }

    @Override
    public void delete(String name) throws IOException {
        if (this.entries.remove(name) == null) {
            throw new IOException("No file to delete: " + name);
        }
    }

    @Override
    public void deleteAttributes(String name) {
    }

    @Override
    public boolean folder(String name) {
        return this.getOrCreateEntry((String)name).data == null;
    }

    @Override
    public InputStream inputStream(String name) throws FileNotFoundException {
        byte[] arr = this.getOrCreateEntry((String)name).data;
        if (arr == null) {
            arr = new byte[]{};
        }
        return new ByteArrayInputStream(arr);
    }

    @Override
    public Date lastModified(String name) {
        Date d = this.getOrCreateEntry((String)name).last;
        return d == null ? this.created : d;
    }

    @Override
    public void lock(String name) throws IOException {
    }

    @Override
    public void markUnimportant(String name) {
    }

    @Override
    public String mimeType(String name) {
        return (String)this.getOrCreateEntry((String)name).attrs.get("mimeType");
    }

    @Override
    public OutputStream outputStream(final String name) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Out
        extends ByteArrayOutputStream {
            Out() {
            }

            @Override
            public void close() throws IOException {
                super.close();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)name).data = this.toByteArray();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)name).last = new Date();
            }
        }
        return new Out();
    }

    @Override
    public Object readAttribute(String name, String attrName) {
        return this.isValidEntry(name) ? this.getOrCreateEntry((String)name).attrs.get(attrName) : null;
    }

    @Override
    public boolean readOnly(String name) {
        return false;
    }

    @Override
    public void rename(String oldName, String newName) throws IOException {
        if (!this.isValidEntry(oldName)) {
            throw new IOException("The file to rename does not exist.");
        }
        if (this.isValidEntry(newName)) {
            throw new IOException("Cannot rename to existing file");
        }
        if (newName.length() > 0 && newName.charAt(0) == '/') {
            newName = newName.substring(1);
        }
        Entry e = this.getOrCreateEntry(oldName);
        this.entries.remove(oldName);
        this.entries.put(newName, e);
    }

    @Override
    public void renameAttributes(String oldName, String newName) {
    }

    @Override
    public long size(String name) {
        byte[] d = this.getOrCreateEntry((String)name).data;
        return d == null ? 0L : (long)d.length;
    }

    @Override
    public void unlock(String name) {
    }

    @Override
    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        this.getOrCreateEntry((String)name).attrs.put(attrName, value);
    }

    private Map<String, Entry> initEntry() {
        if (!ERR.isLoggable(Level.FINE)) {
            return new ConcurrentHashMap<String, Entry>();
        }
        return new ConcurrentHashMap<String, Entry>(){

            public Entry get(String key) {
                Entry retval = (Entry)super.get(key);
                MemoryFileSystem.logMessage("called: GET key: " + key + " result: " + retval);
                return retval;
            }

            @Override
            public Entry put(String key, Entry value) {
                Entry retval = super.put(key, value);
                MemoryFileSystem.logMessage("called: PUT key: " + key + " value: " + value + " result: " + retval);
                return retval;
            }

            public Entry remove(String key) {
                Entry retval = (Entry)super.remove(key);
                MemoryFileSystem.logMessage("called: REMOVE key: " + key + " result: " + retval);
                return retval;
            }
        };
    }

    private static void logMessage(String message) {
        StringBuffer sb = new StringBuffer();
        sb.append(" -> ").append(message);
        ERR.fine(sb.toString());
    }

    static final class Entry {
        public Map<String, Object> attrs = new HashMap<String, Object>();
        public byte[] data;
        public Date last;
        private final String entryName;

        Entry(String entryName) {
            this.entryName = entryName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" [").append(this.entryName);
            sb.append(" -> ").append(super.toString());
            sb.append("] ");
            return sb.toString();
        }
    }
}

