/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.usages.ClassIndexFactory;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexImplListener;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndex {
    private static final Logger LOGGER = Logger.getLogger(ClassIndex.class.getName());
    private final ClassPath bootPath;
    private final ClassPath classPath;
    private final ClassPath sourcePath;
    private final Set<URL> oldSources;
    private final Set<URL> oldDeps;
    private final Set<ClassIndexImpl> sourceIndeces;
    private final Set<ClassIndexImpl> depsIndeces;
    private final List<ClassIndexListener> listeners = new CopyOnWriteArrayList<ClassIndexListener>();
    private final SPIListener spiListener = new SPIListener();

    ClassIndex(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath) {
        assert (bootPath != null);
        assert (classPath != null);
        assert (sourcePath != null);
        this.bootPath = bootPath;
        this.classPath = classPath;
        this.sourcePath = sourcePath;
        ClassIndexManager manager = ClassIndexManager.getDefault();
        manager.addClassIndexManagerListener((ClassIndexManagerListener)WeakListeners.create(ClassIndexManagerListener.class, (EventListener)this.spiListener, (Object)manager));
        this.sourceIndeces = new HashSet<ClassIndexImpl>();
        this.oldSources = new HashSet<URL>();
        this.createQueriesForRoots(this.sourcePath, true, this.sourceIndeces, this.oldSources);
        this.depsIndeces = new HashSet<ClassIndexImpl>();
        this.oldDeps = new HashSet<URL>();
        this.createQueriesForRoots(this.bootPath, false, this.depsIndeces, this.oldDeps);
        this.createQueriesForRoots(this.classPath, false, this.depsIndeces, this.oldDeps);
    }

    public void addClassIndexListener(ClassIndexListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void removeClassIndexListener(ClassIndexListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    public Set<ElementHandle<TypeElement>> getElements(ElementHandle<TypeElement> element, Set<SearchKind> searchKind, Set<SearchScope> scope) {
        assert (element != null);
        assert (element.getSignature()[0] != null);
        assert (searchKind != null);
        HashSet result = new HashSet();
        Iterable<? extends ClassIndexImpl> queries = this.getQueries(scope);
        Set<ClassIndexImpl.UsageType> ut = ClassIndex.encodeSearchKind(element.getKind(), searchKind);
        String binaryName = element.getSignature()[0];
        ResultConvertor<ElementHandle<TypeElement>> thConvertor = ResultConvertor.elementHandleConvertor();
        if (!ut.isEmpty()) {
            for (ClassIndexImpl classIndexImpl : queries) {
                classIndexImpl.search(binaryName, ut, thConvertor, result);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<FileObject> getResources(ElementHandle<TypeElement> element, Set<SearchKind> searchKind, Set<SearchScope> scope) {
        assert (element != null);
        assert (element.getSignature()[0] != null);
        assert (searchKind != null);
        HashSet result = new HashSet();
        Iterable<? extends ClassIndexImpl> queries = this.getQueries(scope);
        Set<ClassIndexImpl.UsageType> ut = ClassIndex.encodeSearchKind(element.getKind(), searchKind);
        String binaryName = element.getSignature()[0];
        if (!ut.isEmpty()) {
            for (ClassIndexImpl classIndexImpl : queries) {
                ResultConvertor<FileObject> foConvertor = ResultConvertor.fileObjectConvertor(classIndexImpl.getSourceRoots());
                classIndexImpl.search(binaryName, ut, foConvertor, result);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<ElementHandle<TypeElement>> getDeclaredTypes(String name, NameKind kind, Set<SearchScope> scope) {
        assert (name != null);
        assert (kind != null);
        HashSet result = new HashSet();
        Iterable<? extends ClassIndexImpl> queries = this.getQueries(scope);
        ResultConvertor<ElementHandle<TypeElement>> thConvertor = ResultConvertor.elementHandleConvertor();
        for (ClassIndexImpl classIndexImpl : queries) {
            classIndexImpl.getDeclaredTypes(name, kind, thConvertor, result);
        }
        LOGGER.fine(String.format("ClassIndex.getDeclaredTypes returned %d elements\n", result.size()));
        return Collections.unmodifiableSet(result);
    }

    public Set<String> getPackageNames(String prefix, boolean directOnly, Set<SearchScope> scope) {
        assert (prefix != null);
        HashSet<String> result = new HashSet<String>();
        Iterable<? extends ClassIndexImpl> queries = this.getQueries(scope);
        for (ClassIndexImpl classIndexImpl : queries) {
            classIndexImpl.getPackageNames(prefix, directOnly, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private synchronized void reset(boolean source, boolean deps) {
        if (source) {
            for (ClassIndexImpl impl : this.sourceIndeces) {
                impl.removeClassIndexImplListener(this.spiListener);
            }
            this.sourceIndeces.clear();
            this.oldSources.clear();
            this.createQueriesForRoots(this.sourcePath, true, this.sourceIndeces, this.oldSources);
        }
        if (deps) {
            for (ClassIndexImpl impl : this.depsIndeces) {
                impl.removeClassIndexImplListener(this.spiListener);
            }
            this.depsIndeces.clear();
            this.oldDeps.clear();
            this.createQueriesForRoots(this.bootPath, false, this.depsIndeces, this.oldDeps);
            this.createQueriesForRoots(this.classPath, false, this.depsIndeces, this.oldDeps);
        }
    }

    private synchronized Iterable<? extends ClassIndexImpl> getQueries(Set<SearchScope> scope) {
        HashSet<ClassIndexImpl> result = new HashSet<ClassIndexImpl>();
        if (scope.contains((Object)SearchScope.SOURCE)) {
            result.addAll(this.sourceIndeces);
        }
        if (scope.contains((Object)SearchScope.DEPENDENCIES)) {
            result.addAll(this.depsIndeces);
        }
        LOGGER.fine(String.format("ClassIndex.queries[Scope=%s, sourcePath=%s, bootPath=%s, classPath=%s] => %s\n", scope, this.sourcePath, this.bootPath, this.classPath, result));
        return result;
    }

    private synchronized Set<? extends URL> getOldState(Set<SearchScope> scope) {
        HashSet<URL> result = new HashSet<URL>();
        if (scope.contains((Object)SearchScope.SOURCE)) {
            result.addAll(this.oldSources);
        }
        if (scope.contains((Object)SearchScope.DEPENDENCIES)) {
            result.addAll(this.oldDeps);
        }
        return result;
    }

    private void createQueriesForRoots(ClassPath cp, boolean sources, Set<? super ClassIndexImpl> queries, Set<? super URL> oldState) {
        GlobalSourcePath gsp = GlobalSourcePath.getDefault();
        List entries = cp.entries();
        for (ClassPath.Entry entry : entries) {
            try {
                URL[] srcRoots;
                if (!sources) {
                    srcRoots = gsp.getSourceRootForBinaryRoot(entry.getURL(), cp, true);
                    if (srcRoots == null) {
                        srcRoots = new URL[]{entry.getURL()};
                    }
                } else {
                    srcRoots = new URL[]{entry.getURL()};
                }
                for (URL srcRoot : srcRoots) {
                    oldState.add(srcRoot);
                    ClassIndexImpl ci = ClassIndexManager.getDefault().getUsagesQuery(srcRoot);
                    if (ci == null) continue;
                    ci.addClassIndexImplListener(this.spiListener);
                    queries.add(ci);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private static Set<ClassIndexImpl.UsageType> encodeSearchKind(ElementKind elementKind, Set<SearchKind> kind) {
        assert (kind != null);
        EnumSet<ClassIndexImpl.UsageType> result = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
        block12: for (SearchKind sk : kind) {
            switch (sk) {
                case METHOD_REFERENCES: {
                    result.add(ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    continue block12;
                }
                case FIELD_REFERENCES: {
                    result.add(ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    continue block12;
                }
                case TYPE_REFERENCES: {
                    result.add(ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    continue block12;
                }
                case IMPLEMENTORS: {
                    switch (elementKind) {
                        case INTERFACE: 
                        case ANNOTATION_TYPE: {
                            result.add(ClassIndexImpl.UsageType.SUPER_INTERFACE);
                            continue block12;
                        }
                        case CLASS: {
                            result.add(ClassIndexImpl.UsageType.SUPER_CLASS);
                            continue block12;
                        }
                        case ENUM: {
                            continue block12;
                        }
                        case OTHER: {
                            result.add(ClassIndexImpl.UsageType.SUPER_INTERFACE);
                            result.add(ClassIndexImpl.UsageType.SUPER_CLASS);
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            throw new IllegalArgumentException();
        }
        return result;
    }

    static {
        ClassIndexImpl.FACTORY = new ClassIndexFactoryImpl();
    }

    private static class ClassIndexFactoryImpl
    implements ClassIndexFactory {
        private ClassIndexFactoryImpl() {
        }

        public ClassIndex create(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath) {
            return new ClassIndex(bootPath, classPath, sourcePath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameKind {
        SIMPLE_NAME,
        PREFIX,
        CASE_INSENSITIVE_PREFIX,
        CAMEL_CASE,
        REGEXP,
        CASE_INSENSITIVE_REGEXP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPIListener
    implements ClassIndexImplListener,
    ClassIndexManagerListener {
        private SPIListener() {
        }

        @Override
        public void typesAdded(ClassIndexImplEvent event) {
            assert (event != null);
            TypesEvent _event = new TypesEvent(ClassIndex.this, event.getTypes());
            for (ClassIndexListener l : ClassIndex.this.listeners) {
                l.typesAdded(_event);
            }
        }

        @Override
        public void typesRemoved(ClassIndexImplEvent event) {
            assert (event != null);
            TypesEvent _event = new TypesEvent(ClassIndex.this, event.getTypes());
            for (ClassIndexListener l : ClassIndex.this.listeners) {
                l.typesRemoved(_event);
            }
        }

        @Override
        public void typesChanged(ClassIndexImplEvent event) {
            assert (event != null);
            TypesEvent _event = new TypesEvent(ClassIndex.this, event.getTypes());
            for (ClassIndexListener l : ClassIndex.this.listeners) {
                l.typesChanged(_event);
            }
        }

        @Override
        public void classIndexAdded(ClassIndexManagerEvent event) {
            Set<? extends URL> roots = event.getRoots();
            assert (roots != null);
            LinkedList ar = new LinkedList();
            boolean srcF = this.containsRoot(ClassIndex.this.sourcePath, roots, ar, false);
            boolean depF = this.containsRoot(ClassIndex.this.bootPath, roots, ar, true);
            if (srcF || (depF |= this.containsRoot(ClassIndex.this.classPath, roots, ar, true))) {
                ClassIndex.this.reset(srcF, depF);
                RootsEvent e = new RootsEvent(ClassIndex.this, ar);
                for (ClassIndexListener l : ClassIndex.this.listeners) {
                    l.rootsAdded(e);
                }
            }
        }

        @Override
        public void classIndexRemoved(ClassIndexManagerEvent event) {
            Set<? extends URL> roots = event.getRoots();
            assert (roots != null);
            LinkedList ar = new LinkedList();
            boolean srcF = this.containsRoot(ClassIndex.this.getOldState(EnumSet.of(SearchScope.SOURCE)), roots, ar);
            boolean depF = this.containsRoot(ClassIndex.this.getOldState(EnumSet.of(SearchScope.DEPENDENCIES)), roots, ar);
            if (srcF || depF) {
                ClassIndex.this.reset(srcF, depF);
                RootsEvent e = new RootsEvent(ClassIndex.this, ar);
                for (ClassIndexListener l : ClassIndex.this.listeners) {
                    l.rootsRemoved(e);
                }
            }
        }

        private boolean containsRoot(ClassPath cp, Set<? extends URL> roots, List<? super URL> affectedRoots, boolean translate) {
            List entries = cp.entries();
            GlobalSourcePath gsp = GlobalSourcePath.getDefault();
            boolean result = false;
            for (ClassPath.Entry entry : entries) {
                URL url = entry.getURL();
                URL[] srcRoots = null;
                if (translate) {
                    srcRoots = gsp.getSourceRootForBinaryRoot(entry.getURL(), cp, false);
                }
                if (srcRoots == null) {
                    if (!roots.contains(url)) continue;
                    affectedRoots.add(url);
                    result = true;
                    continue;
                }
                for (URL _url : srcRoots) {
                    if (!roots.contains(_url)) continue;
                    affectedRoots.add(url);
                    result = true;
                }
            }
            return result;
        }

        private boolean containsRoot(Set<? extends URL> cp, Set<? extends URL> roots, List<? super URL> affectedRoots) {
            boolean result = false;
            for (URL uRL : cp) {
                if (!roots.contains(uRL)) continue;
                affectedRoots.add(uRL);
                result = true;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchKind {
        IMPLEMENTORS,
        METHOD_REFERENCES,
        FIELD_REFERENCES,
        TYPE_REFERENCES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        SOURCE,
        DEPENDENCIES;

    }
}

