/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.util.Context;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.usages.ClassFileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementHandle<T extends Element> {
    private ElementKind kind;
    private String[] signatures;

    private ElementHandle(ElementKind kind, String[] signatures) {
        assert (kind != null);
        assert (signatures != null);
        this.kind = kind;
        this.signatures = signatures;
    }

    public T resolve(CompilationInfo compilationInfo) {
        assert (compilationInfo != null);
        switch (this.kind) {
            case PACKAGE: {
                assert (this.signatures.length == 1);
                return (T)compilationInfo.getElements().getPackageElement(this.signatures[0]);
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case OTHER: {
                assert (this.signatures.length == 1);
                return (T)ElementHandle.getTypeElementByBinaryName(this.signatures[0], compilationInfo);
            }
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                assert (this.signatures.length == 3);
                TypeElement type = ElementHandle.getTypeElementByBinaryName(this.signatures[0], compilationInfo);
                if (type == null) break;
                List<? extends Element> members = type.getEnclosedElements();
                for (Element element : members) {
                    if (this.kind != element.getKind()) continue;
                    String[] desc = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                    assert (desc.length == 3);
                    if (!this.signatures[1].equals(desc[1]) || !this.signatures[2].equals(desc[2])) continue;
                    return (T)element;
                }
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                assert (this.signatures.length == 3);
                TypeElement type = ElementHandle.getTypeElementByBinaryName(this.signatures[0], compilationInfo);
                if (type == null) break;
                List<? extends Element> members = type.getEnclosedElements();
                for (Element element : members) {
                    if (this.kind != element.getKind()) continue;
                    String[] desc = ClassFileUtil.createFieldDescriptor((VariableElement)element);
                    assert (desc.length == 3);
                    if (!this.signatures[1].equals(desc[1]) || !this.signatures[2].equals(desc[2])) continue;
                    return (T)element;
                }
                break;
            }
            case TYPE_PARAMETER: {
                if (this.signatures.length == 2) {
                    TypeElement type = ElementHandle.getTypeElementByBinaryName(this.signatures[0], compilationInfo);
                    if (type == null) break;
                    List<? extends TypeParameterElement> tpes = type.getTypeParameters();
                    for (TypeParameterElement typeParameterElement : tpes) {
                        if (!typeParameterElement.getSimpleName().contentEquals(this.signatures[1])) continue;
                        return (T)typeParameterElement;
                    }
                    break;
                }
                if (this.signatures.length == 4) {
                    TypeElement type = ElementHandle.getTypeElementByBinaryName(this.signatures[0], compilationInfo);
                    if (type == null) break;
                    List<? extends Element> members = type.getEnclosedElements();
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) continue;
                        String[] desc = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                        assert (desc.length == 3);
                        if (!this.signatures[1].equals(desc[1]) || !this.signatures[2].equals(desc[2])) continue;
                        assert (element instanceof ExecutableElement);
                        List<? extends TypeParameterElement> tpes = ((ExecutableElement)element).getTypeParameters();
                        for (TypeParameterElement typeParameterElement : tpes) {
                            if (!typeParameterElement.getSimpleName().contentEquals(this.signatures[3])) continue;
                            return (T)typeParameterElement;
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return null;
    }

    public boolean signatureEquals(ElementHandle<? extends Element> handle) {
        if (!ElementHandle.isSameKind(this.kind, handle.kind) || this.signatures.length != handle.signatures.length) {
            return false;
        }
        for (int i = 0; i < this.signatures.length; ++i) {
            if (this.signatures[i].equals(handle.signatures[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameKind(ElementKind k1, ElementKind k2) {
        return k1 == k2 || k1 == ElementKind.OTHER && (k2.isClass() || k2.isInterface()) || k2 == ElementKind.OTHER && (k1.isClass() || k1.isField());
    }

    public String getBinaryName() throws IllegalStateException {
        if (this.kind.isClass() && !ElementHandle.isArray(this.signatures[0]) || this.kind.isInterface() || this.kind == ElementKind.OTHER) {
            return this.signatures[0];
        }
        throw new IllegalStateException();
    }

    public String getQualifiedName() throws IllegalStateException {
        if (this.kind.isClass() && !ElementHandle.isArray(this.signatures[0]) || this.kind.isInterface() || this.kind == ElementKind.OTHER) {
            return this.signatures[0].replace(Target.DEFAULT.syntheticNameChar(), '.');
        }
        throw new IllegalStateException();
    }

    public boolean signatureEquals(T element) {
        ElementKind thisKind;
        ElementKind ek = element.getKind();
        if (ek != (thisKind = this.getKind()) && (thisKind != ElementKind.OTHER || !ek.isClass() && !ek.isInterface())) {
            return false;
        }
        ElementHandle<T> handle = ElementHandle.create(element);
        return this.signatureEquals((T)handle);
    }

    public ElementKind getKind() {
        return this.kind;
    }

    public static <T extends Element> ElementHandle<T> create(T element) throws IllegalArgumentException {
        String[] signatures;
        assert (element != null);
        ElementKind kind = element.getKind();
        switch (kind) {
            case PACKAGE: {
                assert (element instanceof PackageElement);
                signatures = new String[]{((PackageElement)element).getQualifiedName().toString()};
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                assert (element instanceof TypeElement);
                signatures = new String[]{ClassFileUtil.encodeClassNameOrArray((TypeElement)element)};
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                assert (element instanceof ExecutableElement);
                signatures = ClassFileUtil.createExecutableDescriptor((ExecutableElement)element);
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                assert (element instanceof VariableElement);
                signatures = ClassFileUtil.createFieldDescriptor((VariableElement)element);
                break;
            }
            case TYPE_PARAMETER: {
                assert (element instanceof TypeParameterElement);
                TypeParameterElement tpe = (TypeParameterElement)element;
                Element ge = tpe.getGenericElement();
                ElementKind gek = ge.getKind();
                if (gek.isClass() || gek.isInterface()) {
                    assert (ge instanceof TypeElement);
                    signatures = new String[]{ClassFileUtil.encodeClassNameOrArray((TypeElement)ge), tpe.getSimpleName().toString()};
                    break;
                }
                if (gek == ElementKind.METHOD || gek == ElementKind.CONSTRUCTOR) {
                    assert (ge instanceof ExecutableElement);
                    String[] _sigs = ClassFileUtil.createExecutableDescriptor((ExecutableElement)ge);
                    signatures = new String[_sigs.length + 1];
                    System.arraycopy(_sigs, 0, signatures, 0, _sigs.length);
                    signatures[_sigs.length] = tpe.getSimpleName().toString();
                    break;
                }
                throw new IllegalArgumentException(gek.toString());
            }
            default: {
                throw new IllegalArgumentException(kind.toString());
            }
        }
        return new ElementHandle<T>(kind, signatures);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append('[');
        result.append("kind=" + this.kind.toString());
        result.append("; sigs=");
        for (String sig : this.signatures) {
            result.append(sig);
            result.append(' ');
        }
        result.append(']');
        return result.toString();
    }

    public int hashCode() {
        return this.signatures.length == 0 || this.signatures[0] == null ? 0 : this.signatures[0].hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ElementHandle) {
            return this.signatureEquals((T)((ElementHandle)other));
        }
        return false;
    }

    String[] getSignature() {
        return this.signatures;
    }

    private static TypeElement getTypeElementByBinaryName(String signature, CompilationInfo ci) {
        if (ElementHandle.isArray(signature)) {
            return Symtab.instance((Context)ci.getJavacTask().getContext()).arrayClass;
        }
        assert (ci.getElements() instanceof JavacElements);
        JavacElements elements = (JavacElements)ci.getElements();
        return elements.getTypeElementByBinaryName(signature);
    }

    private static boolean isArray(String signature) {
        return signature.length() == 1 && signature.charAt(0) == '[';
    }

    static {
        ElementHandleAccessor.INSTANCE = new ElementHandleAccessorImpl();
    }

    private static class ElementHandleAccessorImpl
    extends ElementHandleAccessor {
        private ElementHandleAccessorImpl() {
        }

        public ElementHandle create(ElementKind kind, String ... descriptors) {
            assert (kind != null);
            assert (descriptors != null);
            switch (kind) {
                case PACKAGE: {
                    if (descriptors.length != 1) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(kind, descriptors);
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case OTHER: {
                    if (descriptors.length != 1) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(kind, descriptors);
                }
                case METHOD: 
                case CONSTRUCTOR: 
                case INSTANCE_INIT: 
                case STATIC_INIT: {
                    if (descriptors.length != 3) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(kind, descriptors);
                }
                case FIELD: 
                case ENUM_CONSTANT: {
                    if (descriptors.length != 3) {
                        throw new IllegalArgumentException();
                    }
                    return new ElementHandle(kind, descriptors);
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

