/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.javadoc.Doc;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javadoc.DocEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.ElementsService;
import org.netbeans.modules.java.source.engine.RootTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementUtilities {
    private Context ctx;
    private ElementsService delegate;

    ElementUtilities(CompilationInfo info) {
        this(info.getJavacTask());
    }

    public ElementUtilities(JavacTask task) {
        this.ctx = ((JavacTaskImpl)task).getContext();
        this.delegate = ElementsService.instance(this.ctx);
    }

    public TypeElement enclosingTypeElement(Element element) {
        return this.delegate.enclosingTypeElement(element);
    }

    public TypeElement outermostTypeElement(Element element) {
        return this.delegate.outermostTypeElement(element);
    }

    public PackageElement packageElement(Element element) {
        return this.delegate.packageElement(element);
    }

    public Element getImplementationOf(ExecutableElement method, TypeElement origin) {
        return this.delegate.getImplementationOf(method, origin);
    }

    public boolean isSynthetic(Element element) {
        return this.delegate.isSynthetic(element);
    }

    public boolean overridesMethod(ExecutableElement element) {
        return this.delegate.overridesMethod(element);
    }

    public static String getBinaryName(TypeElement element) throws IllegalArgumentException {
        if (element instanceof Symbol.TypeSymbol) {
            return ((Symbol.TypeSymbol)((Object)element)).flatName().toString();
        }
        throw new IllegalArgumentException();
    }

    public Doc javaDocFor(Element element) {
        if (element != null) {
            DocEnv env = DocEnv.instance((Context)this.ctx);
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return env.getClassDoc((Symbol.ClassSymbol)element);
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    return env.getFieldDoc((Symbol.VarSymbol)element);
                }
                case METHOD: {
                    if (element.getEnclosingElement().getKind() == ElementKind.ANNOTATION_TYPE) {
                        return env.getAnnotationTypeElementDoc((Symbol.MethodSymbol)element);
                    }
                    return env.getMethodDoc((Symbol.MethodSymbol)element);
                }
                case CONSTRUCTOR: {
                    return env.getConstructorDoc((Symbol.MethodSymbol)element);
                }
                case PACKAGE: {
                    return env.getPackageDoc((Symbol.PackageSymbol)element);
                }
            }
        }
        return null;
    }

    public Element elementFor(Doc doc) {
        return doc instanceof JavadocEnv.ElementHolder ? ((JavadocEnv.ElementHolder)doc).getElement() : null;
    }

    public Iterable<? extends Element> getMembers(TypeMirror type, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        if (type != null) {
            JavacElements elements = JavacElements.instance(this.ctx);
            switch (type.getKind()) {
                case DECLARED: {
                    for (Element element : elements.getAllMembers((TypeElement)((DeclaredType)type).asElement())) {
                        if (acceptor != null && !acceptor.accept(element, type)) continue;
                        members.add(element);
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)type) : List.nil();
                    t = new Type.ClassType(t.getEnclosingType(), list, t.tsym);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Name.Table.instance((Context)this.ctx)._class, t, ((Type)type).tsym);
                    if (acceptor != null && !acceptor.accept(classPseudoMember, type)) break;
                    members.add(classPseudoMember);
                    break;
                }
                case ARRAY: {
                    for (Element element : elements.getAllMembers((TypeElement)((Object)((Type)type).tsym))) {
                        if (acceptor != null && !acceptor.accept(element, type)) continue;
                        members.add(element);
                    }
                    break;
                }
            }
        }
        return members;
    }

    public Iterable<? extends Element> getLocalMembersAndVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList<Element> h;
        TypeElement cls;
        ArrayList<Element> members = new ArrayList<Element>();
        HashMap<String, ArrayList<Element>> hiders = new HashMap<String, ArrayList<Element>>();
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        while (scope != null && (cls = scope.getEnclosingClass()) != null) {
            for (Element element : scope.getLocalElements()) {
                String string;
                if (acceptor != null && !acceptor.accept(element, null) || this.isHidden(element, (Iterable<Element>)(h = (ArrayList<Element>)hiders.get(string = element.getSimpleName().toString())), elements, types)) continue;
                members.add(element);
                if (h == null) {
                    h = new ArrayList<Element>();
                    hiders.put(string, h);
                }
                h.add(element);
            }
            TypeMirror type = cls.asType();
            for (Element element : elements.getAllMembers(cls)) {
                String name2;
                ArrayList<Element> h2;
                if (acceptor != null && !acceptor.accept(element, type) || this.isHidden(element, (Iterable<Element>)(h2 = (ArrayList<Element>)hiders.get(name2 = element.getSimpleName().toString())), elements, types)) continue;
                members.add(element);
                if (h2 == null) {
                    h2 = new ArrayList<Element>();
                    hiders.put(name2, h2);
                }
                h2.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        while (scope != null) {
            for (Element element : scope.getLocalElements()) {
                String string;
                if (element.getKind().isClass() || element.getKind().isInterface() || acceptor != null && !acceptor.accept(element, element.getEnclosingElement().asType()) || this.isHidden(element, (Iterable<Element>)(h = (ArrayList)hiders.get(string = element.getSimpleName().toString())), elements, types)) continue;
                members.add(element);
                if (h == null) {
                    h = new ArrayList();
                    hiders.put(string, h);
                }
                h.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return members;
    }

    public Iterable<? extends Element> getLocalVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        HashMap<String, ArrayList<Element>> hiders = new HashMap<String, ArrayList<Element>>();
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        while (scope != null && scope.getEnclosingClass() != null) {
            for (Element element : scope.getLocalElements()) {
                String name;
                ArrayList<Element> h;
                if (acceptor != null && !acceptor.accept(element, null) || this.isHidden(element, (Iterable<Element>)(h = (ArrayList<Element>)hiders.get(name = element.getSimpleName().toString())), elements, types)) continue;
                members.add(element);
                if (h == null) {
                    h = new ArrayList<Element>();
                    hiders.put(name, h);
                }
                h.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return members;
    }

    public Iterable<? extends TypeElement> getGlobalTypes(ElementAcceptor acceptor) {
        HashSet<TypeElement> members = new HashSet<TypeElement>();
        JavacTrees trees = JavacTrees.instance(this.ctx);
        RootTree root = (RootTree)ASTService.instance(this.ctx).getRoot();
        for (CompilationUnitTree unit : root.getCompilationUnits()) {
            TreePath path = new TreePath(unit);
            Element element = ((Trees)trees).getElement(path);
            if (element != null && element.getKind() == ElementKind.PACKAGE) {
                for (Element element2 : element.getEnclosedElements()) {
                    if (acceptor != null && !acceptor.accept(element2, null)) continue;
                    members.add((TypeElement)element2);
                }
            }
            for (Scope scope = ((Trees)trees).getScope(path); scope != null; scope = scope.getEnclosingScope()) {
                for (Element element3 : scope.getLocalElements()) {
                    if (!element3.getKind().isClass() && !element3.getKind().isInterface() || acceptor != null && !acceptor.accept(element3, null)) continue;
                    members.add((TypeElement)element3);
                }
            }
        }
        return members;
    }

    private boolean isHidden(Element member, Iterable<Element> hiders, Elements elements, Types types) {
        if (hiders != null) {
            for (Element hider : hiders) {
                if (hider != member && (hider.getClass() != member.getClass() || hider.getSimpleName() != member.getSimpleName() || (hider.getKind() == ElementKind.METHOD || hider.getKind() == ElementKind.CONSTRUCTOR) && !types.isSubsignature((ExecutableType)hider.asType(), (ExecutableType)member.asType()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean referenced(Element e, Element parent) {
        return this.delegate.referenced(e, parent);
    }

    public boolean assigned(Element e, Element parent) {
        return this.delegate.assigned(e, parent);
    }

    public boolean parameter(Element e, Element parent) {
        return this.delegate.parameter(e, parent);
    }

    public boolean isLocal(Element element) {
        return this.delegate.isLocal(element);
    }

    public boolean alreadyDefinedIn(CharSequence name, ExecutableType method, TypeElement enclClass) {
        return this.delegate.alreadyDefinedIn(name, method, enclClass);
    }

    public boolean isMemberOf(Element e, TypeElement type) {
        return this.delegate.isMemberOf(e, type);
    }

    public CharSequence getFullName(Element element) {
        return this.delegate.getFullName(element);
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement method) {
        return this.delegate.getOverriddenMethod(method);
    }

    public boolean implementsMethod(ExecutableElement element) {
        return this.delegate.implementsMethod(element);
    }

    public static interface ElementAcceptor {
        public boolean accept(Element var1, TypeMirror var2);
    }
}

