/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javadoc.JavadocEnter;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.Messager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.editor.Registry;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.ParamNameResolver;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.Scanner;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.usages.SymbolClassReader;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSource {
    private static final int INVALID = 1;
    private static final int CHANGE_EXPECTED = 2;
    private static final int RESCHEDULE_FINISHED_TASKS = 4;
    private static final int UPDATE_INDEX = 8;
    private static final Pattern excludedTasks;
    private static final int SLOW_CANCEL_LIMIT = 50;
    static int REPARSE_DELAY;
    static JavaFileObjectProvider jfoProvider;
    private static Map<Phase, String> phase2Key;
    private static Map<Phase, String> phase2Message;
    private static final PriorityBlockingQueue<Request> requests;
    private static final Map<JavaSource, Collection<Request>> finishedRequests;
    private static final Map<JavaSource, Collection<Request>> waitingRequests;
    private static final Collection<CancellableTask> toRemove;
    private static final SingleThreadFactory factory;
    private static final CurrentRequestReference currentRequest;
    private static final EditorRegistryListener editorRegistryListener;
    private static final java.util.List<DeferredTask> todo;
    private static final ReentrantLock javacLock;
    private final Collection<FileObject> files;
    private final FileObject rootFo;
    private final FileChangeListener fileChangeListener;
    private DocListener listener;
    private DataObjectListener dataObjectListener;
    private final ClasspathInfo classpathInfo;
    private CompilationInfo currentInfo;
    private Stack<CompilationInfo> infoStack = new Stack();
    private int flags = 0;
    private FilterListener filterListener;
    private static final Logger LOGGER;
    private static Map<FileObject, Reference<JavaSource>> file2JavaSource;
    private static final RequestProcessor RP;
    private final RequestProcessor.Task resetTask = RP.create(new Runnable(){

        public void run() {
            JavaSource.this.resetStateImpl();
        }
    });
    private static final int MAX_DUMPS = 255;

    public static JavaSource create(ClasspathInfo cpInfo, Collection<? extends FileObject> files) throws IllegalArgumentException {
        if (files == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new JavaSource(cpInfo, files);
        }
        catch (DataObjectNotFoundException donf) {
            LOGGER.warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)donf.getFileObject()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static JavaSource create(ClasspathInfo cpInfo, FileObject ... files) throws IllegalArgumentException {
        if (files == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        return JavaSource.create(cpInfo, Arrays.asList(files));
    }

    public static JavaSource forFileObject(FileObject fileObject) throws IllegalArgumentException {
        JavaSource js;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid()) {
            return null;
        }
        if (!"text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObject)) && !"java".equals(fileObject.getExt())) {
            return null;
        }
        Reference<JavaSource> ref = file2JavaSource.get(fileObject);
        JavaSource javaSource = js = ref != null ? ref.get() : null;
        if (js == null) {
            js = JavaSource.create(ClasspathInfo.create(fileObject), fileObject);
            file2JavaSource.put(fileObject, new WeakReference<JavaSource>(js));
        }
        return js;
    }

    public static JavaSource forDocument(Document doc) throws IllegalArgumentException {
        DataObject dObj;
        JavaSource js;
        if (doc == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference ref = (Reference)doc.getProperty(JavaSource.class);
        JavaSource javaSource = js = ref != null ? (JavaSource)ref.get() : null;
        if (js == null && (dObj = (DataObject)doc.getProperty("stream")) != null) {
            js = JavaSource.forFileObject(dObj.getPrimaryFile());
        }
        return js;
    }

    private JavaSource(ClasspathInfo cpInfo, Collection<? extends FileObject> files) throws IOException {
        this.files = Collections.unmodifiableList(new ArrayList<FileObject>(files));
        this.fileChangeListener = new FileChangeListenerImpl();
        boolean multipleSources = this.files.size() > 1;
        boolean filterAssigned = false;
        Iterator<FileObject> it = this.files.iterator();
        while (it.hasNext()) {
            FileObject file = it.next();
            try {
                TimesCollector.getDefault().reportReference(file, JavaSource.class.toString(), "[M] JavaSource", (Object)this);
                if (!multipleSources) {
                    file.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)file));
                    this.assignDocumentListener(file);
                    this.dataObjectListener = new DataObjectListener(file);
                }
                if (filterAssigned) continue;
                filterAssigned = true;
                JavaFileFilterImplementation filter = JavaFileFilterQuery.getFilter(file);
                if (filter == null) continue;
                this.filterListener = new FilterListener(filter);
            }
            catch (DataObjectNotFoundException donf) {
                if (multipleSources) {
                    LOGGER.warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)file));
                    it.remove();
                    continue;
                }
                throw donf;
            }
        }
        this.classpathInfo = cpInfo;
        this.rootFo = this.files.size() == 1 ? this.classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(this.files.iterator().next()) : null;
        this.classpathInfo.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)this.classpathInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUserActionTask(CancellableTask<CompilationController> task, boolean shared) throws IOException {
        block52: {
            Request request;
            if (task == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            assert (!JavaSource.holdsDocumentWriteLock(this.files)) : "JavaSource.runCompileControlTask called under Document write lock.";
            boolean a = false;
            if (!$assertionsDisabled) {
                a = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (a && SwingUtilities.isEventDispatchThread()) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                LOGGER.warning("JavaSource.runUserActionTask called in AWT event thread by: " + stackTrace[2]);
            }
            if (this.files.size() <= 1) {
                request = currentRequest.getTaskToCancel();
                try {
                    if (request != null) {
                        request.task.cancel();
                    }
                    javacLock.lock();
                    try {
                        CompilationInfo currentInfo = null;
                        JavaSource javaSource = this;
                        synchronized (javaSource) {
                            if (this.currentInfo != null && (this.flags & 1) == 0) {
                                currentInfo = this.currentInfo;
                            }
                            if (!shared) {
                                this.flags |= 1;
                            }
                        }
                        if (currentInfo == null) {
                            currentInfo = JavaSource.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                            if (shared) {
                                javaSource = this;
                                synchronized (javaSource) {
                                    if (this.currentInfo == null || (this.flags & 1) != 0) {
                                        this.currentInfo = currentInfo;
                                        this.flags &= 0xFFFFFFFE;
                                    } else {
                                        currentInfo = this.currentInfo;
                                    }
                                }
                            }
                        }
                        assert (currentInfo != null);
                        if (shared) {
                            if (!this.infoStack.isEmpty()) {
                                currentInfo = this.infoStack.peek();
                            }
                        } else {
                            this.infoStack.push(currentInfo);
                        }
                        try {
                            task.run(new CompilationController(currentInfo));
                            break block52;
                        }
                        finally {
                            if (!shared) {
                                this.infoStack.pop();
                            }
                        }
                    }
                    catch (Symbol.CompletionFailure e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                    finally {
                        javacLock.unlock();
                    }
                }
                finally {
                    currentRequest.cancelCompleted(request);
                }
            }
            request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    JavacTaskImpl jt = null;
                    FileObject activeFile = null;
                    Iterator<FileObject> files = this.files.iterator();
                    while (files.hasNext() || activeFile != null) {
                        boolean restarted;
                        if (activeFile == null) {
                            activeFile = files.next();
                            restarted = false;
                        } else {
                            restarted = true;
                        }
                        CompilationInfo ci = JavaSource.createCurrentInfo(this, activeFile, this.filterListener, jt);
                        task.run(new CompilationController(ci));
                        if (!ci.needsRestart) {
                            jt = ci.getJavacTask();
                            Log.instance((Context)jt.getContext()).nerrors = 0;
                            activeFile = null;
                            continue;
                        }
                        jt = null;
                        ci = null;
                        System.gc();
                        if (!restarted) continue;
                        throw new InsufficientMemoryException(activeFile);
                    }
                }
                catch (Symbol.CompletionFailure e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<Void> runWhenScanFinished(CancellableTask<CompilationController> task, boolean shared) throws IOException {
        assert (task != null);
        ScanSync sync = new ScanSync(task);
        DeferredTask r = new DeferredTask(this, task, shared, sync);
        todo.add(r);
        if (RepositoryUpdater.getDefault().isScanInProgress()) {
            return sync;
        }
        boolean locked = javacLock.tryLock();
        if (locked) {
            try {
                if (!todo.remove(r)) return sync;
                try {
                    this.runUserActionTask(task, shared);
                    return sync;
                }
                finally {
                    sync.taskFinished();
                }
            }
            finally {
                javacLock.unlock();
            }
        }
        while (true) {
            Request[] request = new Request[1];
            boolean isScanner = false;
            if (request[0] == null) {
                isScanner = currentRequest.getUserTaskToCancel(request);
            }
            try {
                if (isScanner) {
                    ScanSync scanSync = sync;
                    return scanSync;
                }
                if (request[0] != null) {
                    request[0].task.cancel();
                }
                if (!javacLock.tryLock()) continue;
                try {
                    if (!todo.remove(r)) continue;
                    try {
                        this.runUserActionTask(task, shared);
                        continue;
                    }
                    finally {
                        sync.taskFinished();
                        continue;
                    }
                }
                finally {
                    javacLock.unlock();
                    continue;
                }
            }
            finally {
                currentRequest.cancelCompleted(request[0]);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationResult runModificationTask(CancellableTask<WorkingCopy> task) throws IOException {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        assert (!JavaSource.holdsDocumentWriteLock(this.files)) : "JavaSource.runModificationTask called under Document write lock.";
        boolean a = false;
        if (!$assertionsDisabled) {
            a = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (a && SwingUtilities.isEventDispatchThread()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            LOGGER.warning("JavaSource.runModificationTask called in AWT event thread by: " + stackTrace[2]);
        }
        ModificationResult result = new ModificationResult(this);
        if (this.files.size() <= 1) {
            long start = System.currentTimeMillis();
            Request request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    CompilationInfo currentInfo = null;
                    JavaSource javaSource = this;
                    synchronized (javaSource) {
                        if (this.currentInfo != null && (this.flags & 1) == 0) {
                            currentInfo = this.currentInfo;
                        }
                    }
                    if (currentInfo == null) {
                        currentInfo = JavaSource.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                        javaSource = this;
                        synchronized (javaSource) {
                            if (this.currentInfo == null || (this.flags & 1) != 0) {
                                this.currentInfo = currentInfo;
                                this.flags &= 0xFFFFFFFE;
                            } else {
                                currentInfo = this.currentInfo;
                            }
                        }
                    }
                    assert (currentInfo != null);
                    WorkingCopy copy = new WorkingCopy(currentInfo);
                    task.run(copy);
                    java.util.List<ModificationResult.Difference> diffs = copy.getChanges();
                    if (diffs != null && diffs.size() > 0) {
                        result.diffs.put(currentInfo.getFileObject(), diffs);
                    }
                }
                catch (Symbol.CompletionFailure e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
            TimesCollector.getDefault().reportTime(this.currentInfo.getFileObject(), "java-source-modification-task", "Modification Task", System.currentTimeMillis() - start);
        } else {
            Request request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    JavacTaskImpl jt = null;
                    FileObject activeFile = null;
                    Iterator<FileObject> files = this.files.iterator();
                    while (files.hasNext() || activeFile != null) {
                        boolean restarted;
                        if (activeFile == null) {
                            activeFile = files.next();
                            restarted = false;
                        } else {
                            restarted = true;
                        }
                        CompilationInfo ci = JavaSource.createCurrentInfo(this, activeFile, this.filterListener, jt);
                        WorkingCopy copy = new WorkingCopy(ci);
                        task.run(copy);
                        if (!ci.needsRestart) {
                            jt = ci.getJavacTask();
                            Log.instance((Context)jt.getContext()).nerrors = 0;
                            java.util.List<ModificationResult.Difference> diffs = copy.getChanges();
                            if (diffs != null && diffs.size() > 0) {
                                result.diffs.put(ci.getFileObject(), diffs);
                            }
                            activeFile = null;
                            continue;
                        }
                        jt = null;
                        ci = null;
                        System.gc();
                        if (!restarted) continue;
                        throw new InsufficientMemoryException(activeFile);
                    }
                }
                catch (Symbol.CompletionFailure e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
        JavaSource javaSource = this;
        synchronized (javaSource) {
            this.flags |= 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPhaseCompletionTask(CancellableTask<CompilationInfo> task, Phase phase, Priority priority) throws IOException {
        CompilationInfo currentInfo;
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (phase == null || phase == Phase.MODIFIED) {
            throw new IllegalArgumentException(String.format("The %s is not a legal value of phase", new Object[]{phase}));
        }
        if (priority == null) {
            throw new IllegalArgumentException("The priority cannot be null");
        }
        if (excludedTasks != null && excludedTasks.matcher(task.getClass().getName()).matches()) {
            return;
        }
        JavaSource javaSource = this;
        synchronized (javaSource) {
            currentInfo = this.currentInfo;
        }
        if (currentInfo == null) {
            currentInfo = JavaSource.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
        }
        javaSource = this;
        synchronized (javaSource) {
            if (this.currentInfo == null) {
                this.currentInfo = currentInfo;
            }
        }
        JavaSource.handleAddRequest(new Request(task, this, phase, priority, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhaseCompletionTask(CancellableTask<CompilationInfo> task) {
        if (excludedTasks != null && excludedTasks.matcher(task.getClass().getName()).matches()) {
            return;
        }
        Class<JavaSource> clazz = JavaSource.class;
        synchronized (JavaSource.class) {
            toRemove.add(task);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleTask(CancellableTask<CompilationInfo> task) {
        Class<JavaSource> clazz = JavaSource.class;
        synchronized (JavaSource.class) {
            block8: {
                Request request = currentRequest.getTaskToCancel(task);
                if (request == null) {
                    Iterator<Collection<Request>> it = finishedRequests.values().iterator();
                    while (it.hasNext()) {
                        Collection<Request> cr = it.next();
                        Iterator<Request> it2 = cr.iterator();
                        while (it2.hasNext()) {
                            Request fr = it2.next();
                            if (task != fr.task) continue;
                            it2.remove();
                            requests.add(fr);
                            if (cr.size() == 0) {
                                it.remove();
                            }
                            break block8;
                        }
                    }
                } else {
                    currentRequest.cancelCompleted(request);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void revalidate() {
        this.resetState(true, false);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.classpathInfo;
    }

    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    JavacTaskImpl createJavacTask(DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        String sourceLevel = null;
        if (!this.files.isEmpty()) {
            FileObject file = this.files.iterator().next();
            sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
            FileObject root = this.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(file);
            if (root != null && sourceLevel != null) {
                try {
                    RepositoryUpdater.getDefault().verifySourceLevel(root.getURL(), sourceLevel);
                }
                catch (IOException ex) {
                    Logger.getLogger(JavaSource.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }
        if (sourceLevel == null) {
            sourceLevel = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
        }
        JavacTaskImpl javacTask = JavaSource.createJavacTask(this.getClasspathInfo(), diagnosticListener, sourceLevel, false);
        Context context = javacTask.getContext();
        ParamNameResolver.preRegister(context, this.getClasspathInfo());
        Messager.preRegister((Context)context, null);
        ErrorHandlingJavadocEnter.preRegister(context);
        JavadocMemberEnter.preRegister((Context)context);
        JavadocEnv.preRegister(context, this.getClasspathInfo());
        Scanner.Factory.instance(context);
        com.sun.tools.javac.main.JavaCompiler.instance((Context)context).keepComments = true;
        return javacTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavacTaskImpl createJavacTask(ClasspathInfo cpInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String sourceLevel, boolean backgroundCompilation) {
        ArrayList<String> options = new ArrayList<String>();
        String lintOptions = CompilerSettings.getCommandLine();
        if (lintOptions.length() > 0) {
            options.addAll(Arrays.asList(lintOptions.split(" ")));
        }
        if (!backgroundCompilation) {
            options.add("-Xjcov");
        } else {
            options.add("-XDbackgroundCompilation");
            options.add("-XDcompilePolicy=byfile");
        }
        options.add("-g:");
        options.add("-g:lines");
        options.add("-g:vars");
        options.add("-source");
        options.add(JavaSource.validateSourceLevel(sourceLevel));
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClasspathInfo.class.getClassLoader());
            JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
            JavacTaskImpl task = (JavacTaskImpl)tool.getTask(null, cpInfo.getFileManager(), diagnosticListener, options, null, Collections.emptySet());
            Context context = task.getContext();
            if (backgroundCompilation) {
                SymbolClassReader.preRegister(context, false);
            } else {
                SymbolClassReader.preRegister(context, true);
            }
            JavacTaskImpl javacTaskImpl = task;
            return javacTaskImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    static Phase moveToPhase(Phase phase, CompilationInfo currentInfo, boolean cancellable) throws IOException {
        Phase currentPhase = currentInfo.getPhase();
        boolean isMultiFiles = currentInfo.getJavaSource().files.size() > 1;
        LowMemoryNotifier lm = null;
        LMListener lmListener = null;
        if (isMultiFiles) {
            lm = LowMemoryNotifier.getDefault();
            assert (lm != null);
            lmListener = new LMListener();
            lm.addLowMemoryListener(lmListener);
        }
        try {
            long start2;
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase phase2 = currentPhase;
                return phase2;
            }
            if (currentPhase.compareTo(Phase.PARSED) < 0 && phase.compareTo(Phase.PARSED) >= 0) {
                if (cancellable && currentRequest.isCanceled()) {
                    Phase phase3 = Phase.MODIFIED;
                    return phase3;
                }
                start2 = System.currentTimeMillis();
                Iterable trees = currentInfo.getJavacTask().parse(new JavaFileObject[]{currentInfo.jfo});
                assert (trees != null) : "Did not parse anything";
                Iterator it = trees.iterator();
                assert (it.hasNext());
                CompilationUnitTree unit = (CompilationUnitTree)it.next();
                currentInfo.setCompilationUnit(unit);
                JCTree.JCCompilationUnit tree = (JCTree.JCCompilationUnit)unit;
                ASTService s = ASTService.instance(currentInfo.getJavacTask().getContext());
                if (tree.endPositions != null) {
                    s.setEndPosTable(tree.sourcefile, (Map<JCTree, Integer>)((Object)tree.endPositions));
                }
                ArrayList<CompilationUnitTree> units = new ArrayList<CompilationUnitTree>();
                units.add(tree);
                s.setRoot(new RootTree(units));
                UndoListService undoList = UndoListService.instance(currentInfo.getJavacTask().getContext());
                if (undoList != null) {
                    undoList.reset();
                }
                assert (!it.hasNext());
                currentPhase = Phase.PARSED;
                long end = System.currentTimeMillis();
                FileObject file = currentInfo.getFileObject();
                TimesCollector.getDefault().reportReference(file, "compilationUnit", "[M] Compilation Unit", (Object)unit);
                JavaSource.logTime(file, currentPhase, end - start2);
            }
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase start2 = currentPhase;
                return start2;
            }
            if (currentPhase == Phase.PARSED && phase.compareTo(Phase.ELEMENTS_RESOLVED) >= 0) {
                if (cancellable && currentRequest.isCanceled()) {
                    Phase start2 = Phase.MODIFIED;
                    return start2;
                }
                start2 = System.currentTimeMillis();
                currentInfo.getJavacTask().enter();
                currentPhase = Phase.ELEMENTS_RESOLVED;
                long end = System.currentTimeMillis();
                JavaSource.logTime(currentInfo.getFileObject(), currentPhase, end - start2);
            }
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase start3 = currentPhase;
                return start3;
            }
            if (currentPhase == Phase.ELEMENTS_RESOLVED && phase.compareTo(Phase.RESOLVED) >= 0) {
                if (cancellable && currentRequest.isCanceled()) {
                    Phase start3 = Phase.MODIFIED;
                    return start3;
                }
                start2 = System.currentTimeMillis();
                currentInfo.getJavacTask().analyze();
                currentPhase = Phase.RESOLVED;
                long end = System.currentTimeMillis();
                JavaSource.logTime(currentInfo.getFileObject(), currentPhase, end - start2);
            }
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase start4 = currentPhase;
                return start4;
            }
            if (currentPhase == Phase.RESOLVED && phase.compareTo(Phase.UP_TO_DATE) >= 0) {
                currentPhase = Phase.UP_TO_DATE;
            }
        }
        catch (CouplingAbort a) {
            RepositoryUpdater.couplingAbort(a, currentInfo.jfo);
            currentInfo.needsRestart = true;
            Phase phase4 = currentPhase;
            return phase4;
        }
        catch (Abort abort) {
            currentPhase = Phase.UP_TO_DATE;
        }
        catch (IOException ex) {
            JavaSource.dumpSource(currentInfo, ex);
            throw ex;
        }
        catch (ReattributionException ex) {
            JavaSource.dumpSource(currentInfo, ex);
            throw new RuntimeException(ex);
        }
        catch (RuntimeException ex) {
            JavaSource.dumpSource(currentInfo, ex);
            throw ex;
        }
        catch (Error ex) {
            JavaSource.dumpSource(currentInfo, ex);
            throw ex;
        }
        finally {
            if (isMultiFiles) {
                assert (lm != null);
                assert (lmListener != null);
                lm.removeLowMemoryListener(lmListener);
            }
            currentInfo.setPhase(currentPhase);
        }
        return currentPhase;
    }

    static void logTime(FileObject source, Phase phase, long time) {
        assert (source != null && phase != null);
        String key = phase2Key.get((Object)phase);
        String message = phase2Message.get((Object)phase);
        assert (key != null && message != null);
        TimesCollector.getDefault().reportTime(source, key, message, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState(boolean invalidate, boolean updateIndex) {
        boolean invalid;
        JavaSource javaSource = this;
        synchronized (javaSource) {
            invalid = (this.flags & 1) != 0;
            this.flags |= 2;
            if (invalidate) {
                this.flags |= 5;
            }
            if (updateIndex) {
                this.flags |= 8;
            }
        }
        if (updateIndex && !invalid) {
            this.updateIndex();
        }
        Request r = currentRequest.getTaskToCancel(this);
        try {
            if (r != null) {
                r.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(r);
        }
        this.resetTask.schedule(REPARSE_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStateImpl() {
        Class<JavaSource> clazz = JavaSource.class;
        synchronized (JavaSource.class) {
            Collection<Request> cr;
            boolean updateIndex;
            boolean reschedule;
            JavaSource javaSource = this;
            synchronized (javaSource) {
                reschedule = (this.flags & 4) != 0;
                updateIndex = (this.flags & 8) != 0;
                this.flags &= 0xFFFFFFF1;
            }
            if (updateIndex) {
                this.updateIndex();
            }
            if (reschedule && (cr = finishedRequests.remove(this)) != null && cr.size() > 0) {
                requests.addAll(cr);
            }
            if ((cr = waitingRequests.remove(this)) != null && cr.size() > 0) {
                requests.addAll(cr);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void updateIndex() {
        if (this.rootFo != null) {
            try {
                ClassIndexImpl ciImpl = ClassIndexManager.getDefault().getUsagesQuery(this.rootFo.getURL());
                if (ciImpl != null) {
                    ciImpl.setDirty(this);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private void assignDocumentListener(FileObject fo) throws IOException {
        DataObject od = DataObject.find((FileObject)fo);
        EditorCookie.Observable ec = (EditorCookie.Observable)od.getCookie(EditorCookie.Observable.class);
        if (ec != null) {
            this.listener = new DocListener(ec);
        } else {
            LOGGER.log(Level.WARNING, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)fo)));
        }
    }

    private static CompilationInfo createCurrentInfo(JavaSource js, FileObject fo, FilterListener filterListener, JavacTaskImpl javac) throws IOException {
        CompilationInfo info = new CompilationInfo(js, fo, filterListener == null ? null : filterListener.filter, javac);
        TimesCollector.getDefault().reportReference(fo, CompilationInfo.class.toString(), "[M] CompilationInfo", (Object)info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequest(Request nr) {
        assert (nr != null);
        requests.add(nr);
        Request request = currentRequest.getTaskToCancel(nr.priority);
        try {
            if (request != null) {
                request.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(request);
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<FileObject> files) {
        Class<AbstractDocument> docClass = AbstractDocument.class;
        try {
            Method method = docClass.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread currentThread = Thread.currentThread();
            for (FileObject fo : files) {
                try {
                    Object result;
                    StyledDocument doc;
                    DataObject dobj = DataObject.find((FileObject)fo);
                    EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                    if (ec == null || !((doc = ec.getDocument()) instanceof AbstractDocument) || (result = method.invoke((Object)doc, new Object[0])) != currentThread) continue;
                    return true;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return false;
    }

    private static String validateSourceLevel(String sourceLevel) {
        Source[] sources = Source.values();
        if (sourceLevel == null) {
            return sources[sources.length - 1].name;
        }
        for (Source source : sources) {
            if (!source.name.equals(sourceLevel)) continue;
            return sourceLevel;
        }
        SpecificationVersion JAVA_12 = new SpecificationVersion("1.2");
        SpecificationVersion specVer = new SpecificationVersion(sourceLevel);
        if (JAVA_12.compareTo((Object)specVer) > 0) {
            return sources[0].name;
        }
        return sources[sources.length - 1].name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfo info, Throwable exc) {
        String dumpDir = System.getProperty("netbeans.user") + "/var/log/";
        String src = info.getText();
        FileObject file = info.getFileObject();
        String fileName = FileUtil.getFileDisplayName((FileObject)info.getFileObject());
        String origName = file.getName();
        File f = new File(dumpDir + origName + ".dump");
        boolean dumpSucceeded = false;
        for (int i = 1; i < 255 && f.exists(); ++i) {
            f = new File(dumpDir + origName + '_' + i + ".dump");
        }
        if (!f.exists()) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                try {
                    writer.println(src);
                    writer.println("----- Classpath: ---------------------------------------------");
                    ClassPath bootPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    writer.println("bootPath: " + (bootPath != null ? bootPath.toString() : "null"));
                    writer.println("classPath: " + (classPath != null ? classPath.toString() : "null"));
                    writer.println("sourcePath: " + (sourcePath != null ? sourcePath.toString() : "null"));
                    writer.println("----- Original exception ---------------------------------------------");
                    exc.printStackTrace(writer);
                }
                finally {
                    writer.close();
                    dumpSucceeded = true;
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Error when writing parser dump file!", ioe);
            }
        }
        if (dumpSucceeded) {
            Throwable t = Exceptions.attachMessage((Throwable)exc, (String)("An error occurred during parsing of '" + fileName + "'. Please report a bug against java/source and attach dump file '" + f.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)t);
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + dumpDir + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static /* synthetic */ Collection access$1200() {
        return toRemove;
    }

    static /* synthetic */ Map access$1300() {
        return finishedRequests;
    }

    static /* synthetic */ PriorityBlockingQueue access$1400() {
        return requests;
    }

    static /* synthetic */ CurrentRequestReference access$1500() {
        return currentRequest;
    }

    static /* synthetic */ ReentrantLock access$1900() {
        return javacLock;
    }

    static /* synthetic */ Collection access$2100(JavaSource x0) {
        return x0.files;
    }

    static /* synthetic */ Map access$2300() {
        return waitingRequests;
    }

    static /* synthetic */ FilterListener access$2500(JavaSource x0) {
        return x0.filterListener;
    }

    static /* synthetic */ CompilationInfo access$2600(JavaSource x0, FileObject x1, FilterListener x2, JavacTaskImpl x3) throws IOException {
        return JavaSource.createCurrentInfo(x0, x1, x2, x3);
    }

    static /* synthetic */ CompilationInfo access$2402(JavaSource x0, CompilationInfo x1) {
        x0.currentInfo = x1;
        return x0.currentInfo;
    }

    static /* synthetic */ int access$2272(JavaSource x0, int x1) {
        return x0.flags &= x1;
    }

    static {
        REPARSE_DELAY = 500;
        jfoProvider = new DefaultJavaFileObjectProvider();
        phase2Key = new HashMap<Phase, String>();
        phase2Message = new HashMap<Phase, String>();
        JavaSourceAccessor.INSTANCE = new JavaSourceAccessorImpl();
        phase2Key.put(Phase.PARSED, "parsed");
        phase2Message.put(Phase.PARSED, "Parsed");
        phase2Key.put(Phase.ELEMENTS_RESOLVED, "sig-attributed");
        phase2Message.put(Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Key.put(Phase.RESOLVED, "attributed");
        phase2Message.put(Phase.RESOLVED, "Attributed");
        Pattern _excludedTasks = null;
        try {
            String excludedValue = System.getProperty("org.netbeans.api.java.source.JavaSource.excludedTasks");
            if (excludedValue != null) {
                _excludedTasks = Pattern.compile(excludedValue);
            }
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
        excludedTasks = _excludedTasks;
        requests = new PriorityBlockingQueue<Request>(10, new RequestComparator());
        finishedRequests = new WeakHashMap<JavaSource, Collection<Request>>();
        waitingRequests = new WeakHashMap<JavaSource, Collection<Request>>();
        toRemove = new LinkedList<CancellableTask>();
        factory = new SingleThreadFactory();
        currentRequest = new CurrentRequestReference();
        editorRegistryListener = new EditorRegistryListener();
        todo = Collections.synchronizedList(new LinkedList());
        javacLock = new ReentrantLock(true);
        LOGGER = Logger.getLogger(JavaSource.class.getName());
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        file2JavaSource = new WeakHashMap<FileObject, Reference<JavaSource>>();
        RP = new RequestProcessor("JavaSource-event-collector", 1);
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private long cancelTime;
        private boolean canceled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCurrentTask(Request reference) throws InterruptedException {
            boolean result = false;
            CurrentRequestReference currentRequestReference = this;
            synchronized (currentRequestReference) {
                while (this.canceledReference != null) {
                    this.wait();
                }
                result = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.reference = reference;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Priority priority) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && priority.compareTo(this.reference.priority) < 0) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(JavaSource js) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && js.equals(this.reference.javaSource)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(CancellableTask task) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && task == this.reference.task) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getUserTaskToCancel(Request[] request) {
            assert (request != null);
            assert (request.length == 1);
            boolean result = false;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    request[0] = this.reference;
                    if (request[0] != null) {
                        boolean bl = result = request[0].phase == null;
                        assert (this.canceledReference == null || result);
                        this.canceledReference = request[0];
                        if (!result) {
                            this.reference = null;
                        }
                        this.canceled = result;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return result;
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized long getCancelTime() {
            return this.cancelTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelCompleted(Request request) {
            if (request != null) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    this.notify();
                }
            }
        }
    }

    private final class DataObjectListener
    implements PropertyChangeListener {
        private DataObject dobj;
        private final FileObject fobj;
        private PropertyChangeListener wlistener;

        public DataObjectListener(FileObject fo) throws DataObjectNotFoundException {
            this.fobj = fo;
            this.dobj = DataObject.find((FileObject)fo);
            this.wlistener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.dobj);
            this.dobj.addPropertyChangeListener(this.wlistener);
        }

        public void propertyChange(PropertyChangeEvent pce) {
            DataObject invalidDO = (DataObject)pce.getSource();
            if (invalidDO != this.dobj) {
                return;
            }
            if ("valid".equals(pce.getPropertyName())) {
                this.handleInvalidDataObject(invalidDO);
            } else if (pce.getPropertyName() == null && !this.dobj.isValid()) {
                this.handleInvalidDataObject(invalidDO);
            }
        }

        private void handleInvalidDataObject(final DataObject invalidDO) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    DataObjectListener.this.handleInvalidDataObjectImpl(invalidDO);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInvalidDataObjectImpl(DataObject invalidDO) {
            invalidDO.removePropertyChangeListener(this.wlistener);
            if (this.fobj.isValid()) {
                try {
                    DataObject dobjNew = DataObject.find((FileObject)this.fobj);
                    DataObjectListener dataObjectListener = this;
                    synchronized (dataObjectListener) {
                        if (dobjNew == this.dobj) {
                            return;
                        }
                        this.dobj = dobjNew;
                        this.dobj.addPropertyChangeListener(this.wlistener);
                    }
                    JavaSource.this.assignDocumentListener(this.fobj);
                    JavaSource.this.resetState(true, true);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    static final class DefaultJavaFileObjectProvider
    implements JavaFileObjectProvider {
        DefaultJavaFileObjectProvider() {
        }

        public JavaFileObject createJavaFileObject(FileObject fo, JavaFileFilterImplementation filter) throws IOException {
            return FileObjects.nbFileObject(fo, filter, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DeferredTask {
        final JavaSource js;
        final CancellableTask<CompilationController> task;
        final boolean shared;
        final ScanSync sync;

        public DeferredTask(JavaSource js, CancellableTask<CompilationController> task, boolean shared, ScanSync sync) {
            assert (js != null);
            assert (task != null);
            assert (sync != null);
            this.js = js;
            this.task = task;
            this.shared = shared;
            this.sync = sync;
        }
    }

    private class DocListener
    implements DocumentListener,
    PropertyChangeListener,
    ChangeListener {
        private EditorCookie.Observable ec;
        private DocumentListener docListener;

        public DocListener(EditorCookie.Observable ec) {
            assert (ec != null);
            this.ec = ec;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument doc = ec.getDocument();
            if (doc != null) {
                this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc);
                doc.addDocumentListener(this.docListener);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            JavaSource.this.resetState(true, true);
        }

        public void removeUpdate(DocumentEvent e) {
            JavaSource.this.resetState(true, true);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                StyledDocument doc;
                Object old = evt.getOldValue();
                if (old instanceof Document && this.docListener != null) {
                    ((Document)old).removeDocumentListener(this.docListener);
                    this.docListener = null;
                }
                if ((doc = this.ec.getDocument()) != null) {
                    this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc);
                    doc.addDocumentListener(this.docListener);
                    JavaSource.this.resetState(true, false);
                }
            }
        }

        public void stateChanged(ChangeEvent e) {
            JavaSource.this.resetState(true, false);
        }
    }

    private static class EditorRegistryListener
    implements ChangeListener,
    CaretListener {
        private JTextComponent lastEditor;

        public EditorRegistryListener() {
            Registry.addChangeListener((ChangeListener)this);
        }

        public void stateChanged(ChangeEvent event) {
            JTextComponent editor = Registry.getMostActiveComponent();
            if (this.lastEditor != editor) {
                if (this.lastEditor != null) {
                    this.lastEditor.removeCaretListener(this);
                }
                this.lastEditor = editor;
                if (this.lastEditor != null) {
                    this.lastEditor.addCaretListener(this);
                }
            }
        }

        public void caretUpdate(CaretEvent event) {
            JavaSource js;
            Document doc;
            if (this.lastEditor != null && (doc = this.lastEditor.getDocument()) != null && (js = JavaSource.forDocument(doc)) != null) {
                js.resetState(false, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorHandlingJavadocEnter
    extends JavadocEnter {
        private Messager messager;

        public static void preRegister(final Context context) {
            context.put(enterKey, new Context.Factory<Enter>(){

                public Enter make() {
                    return new ErrorHandlingJavadocEnter(context);
                }
            });
        }

        protected ErrorHandlingJavadocEnter(Context context) {
            super(context);
            this.messager = Messager.instance0((Context)context);
        }

        public void main(List<JCTree.JCCompilationUnit> trees) {
            this.complete(trees, null);
        }
    }

    private class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileChanged(FileEvent fe) {
            JavaSource.this.resetState(true, false);
        }

        public void fileRenamed(FileRenameEvent fe) {
            JavaSource.this.resetState(true, false);
        }
    }

    private final class FilterListener
    implements ChangeListener {
        private final JavaFileFilterImplementation filter;

        public FilterListener(JavaFileFilterImplementation filter) {
            this.filter = filter;
            this.filter.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.filter));
        }

        public void stateChanged(ChangeEvent event) {
            JavaSource.this.resetState(true, false);
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String message, FileObject fo) {
            super(message);
            this.fo = fo;
        }

        private InsufficientMemoryException(FileObject fo) {
            this(NbBundle.getMessage(JavaSource.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fo)), fo);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    static interface JavaFileObjectProvider {
        public JavaFileObject createJavaFileObject(FileObject var1, JavaFileFilterImplementation var2) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaSourceAccessorImpl
    extends JavaSourceAccessor {
        private JavaSourceAccessorImpl() {
        }

        @Override
        protected void runSpecialTaskImpl(CancellableTask<CompilationInfo> task, Priority priority) {
            JavaSource.handleAddRequest(new Request(task, null, null, priority, false));
        }

        @Override
        public JavacTaskImpl createJavacTask(ClasspathInfo cpInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String sourceLevel) {
            if (sourceLevel == null) {
                sourceLevel = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
            }
            return JavaSource.createJavacTask(cpInfo, diagnosticListener, sourceLevel, true);
        }

        @Override
        public JavacTaskImpl getJavacTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.getJavacTask();
        }

        @Override
        public QueryEnvironment getCommandEnvironment(WorkingCopy copy) {
            assert (copy != null);
            return copy.getCommandEnvironment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationInfo getCurrentCompilationInfo(JavaSource js, Phase phase) throws IOException {
            assert (js != null);
            assert (this.isDispatchThread());
            CompilationInfo info = null;
            JavaSource javaSource = js;
            synchronized (javaSource) {
                if ((js.flags & 1) == 0) {
                    info = js.currentInfo;
                }
            }
            if (info == null) {
                return null;
            }
            Phase currentPhase = JavaSource.moveToPhase(phase, info, true);
            return currentPhase.compareTo(phase) < 0 ? null : info;
        }

        @Override
        public void revalidate(JavaSource js) {
            js.revalidate();
        }

        @Override
        public boolean isDispatchThread() {
            return factory.isDispatchThread(Thread.currentThread());
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent event) {
            this.lowMemory.set(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        MODIFIED,
        PARSED,
        ELEMENTS_RESOLVED,
        RESOLVED,
        UP_TO_DATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request {
        private final CancellableTask<? extends CompilationInfo> task;
        private final JavaSource javaSource;
        private final Phase phase;
        private final Priority priority;
        private final boolean reschedule;

        public Request(CancellableTask<? extends CompilationInfo> task, JavaSource javaSource, Phase phase, Priority priority, boolean reschedule) {
            assert (task != null);
            this.task = task;
            this.javaSource = javaSource;
            this.phase = phase;
            this.priority = priority;
            this.reschedule = reschedule;
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase.name(), this.priority, this.task.toString()});
            }
            return String.format("One time request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase != null ? this.phase.name() : "<null>", this.priority, this.task.toString()});
        }

        public int hashCode() {
            return this.priority.ordinal();
        }

        public boolean equals(Object other) {
            if (other instanceof Request) {
                Request otherRequest = (Request)other;
                return this.priority == otherRequest.priority && this.reschedule == otherRequest.reschedule && (this.phase == null ? otherRequest.phase == null : this.phase.equals((Object)otherRequest.phase)) && this.task.equals(otherRequest.task);
            }
            return false;
        }

        static /* synthetic */ boolean access$1800(Request x0) {
            return x0.reschedule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestComparator
    implements Comparator<Request> {
        private RequestComparator() {
        }

        @Override
        public int compare(Request r1, Request r2) {
            assert (r1 != null && r2 != null);
            return r1.priority.compareTo(r2.priority);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ScanSync
    implements Future<Void> {
        private CancellableTask<CompilationController> task;
        private final CountDownLatch sync;
        private final AtomicBoolean canceled;

        public ScanSync(CancellableTask<CompilationController> task) {
            assert (task != null);
            this.task = task;
            this.sync = new CountDownLatch(1);
            this.canceled = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.sync.getCount() == 0L) {
                return false;
            }
            java.util.List list = todo;
            synchronized (list) {
                boolean _canceled = this.canceled.getAndSet(true);
                if (!_canceled) {
                    Iterator it = todo.iterator();
                    while (it.hasNext()) {
                        DeferredTask task = (DeferredTask)it.next();
                        if (task.task != this.task) continue;
                        it.remove();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled.get();
        }

        @Override
        public synchronized boolean isDone() {
            return this.sync.getCount() == 0L;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.sync.await();
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.sync.await(timeout, unit);
            return null;
        }

        private void taskFinished() {
            this.sync.countDown();
        }
    }

    private static class SingleThreadFactory
    implements ThreadFactory {
        private Thread t;

        private SingleThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            assert (this.t == null);
            this.t = new Thread(r, "Java Source Worker Thread");
            return this.t;
        }

        public boolean isDispatchThread(Thread t) {
            assert (t != null);
            return this.t == t;
        }
    }
}

