/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSourceTaskFactory {
    private static final Logger LOG = Logger.getLogger(JavaSourceTaskFactory.class.getName());
    static final String BEFORE_ADDING_REMOVING_TASKS = "beforeAddingRemovingTasks";
    static final String FILEOBJECTS_COMPUTATION = "fileObjectsComputation";
    private final JavaSource.Phase phase;
    private final JavaSource.Priority priority;
    static boolean SYNCHRONOUS_EVENTS = false;
    private final Map<FileObject, CancellableTask<CompilationInfo>> file2Task;
    private final Map<FileObject, JavaSource> file2JS;
    private static RequestProcessor WORKER = new RequestProcessor("JavaSourceTaskFactory", 1);
    static Accessor2 ACCESSOR2;

    protected JavaSourceTaskFactory(JavaSource.Phase phase, JavaSource.Priority priority) {
        this.phase = phase;
        this.priority = priority;
        this.file2Task = new HashMap<FileObject, CancellableTask<CompilationInfo>>();
        this.file2JS = new HashMap<FileObject, JavaSource>();
    }

    protected abstract CancellableTask<CompilationInfo> createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected final void fileObjectsChanged() {
        LOG.log(Level.FINEST, FILEOBJECTS_COMPUTATION);
        final ArrayList<FileObject> currentFiles = new ArrayList<FileObject>(this.getFileObjects());
        if (SYNCHRONOUS_EVENTS) {
            this.stateChangedImpl(currentFiles);
        } else {
            WORKER.post(new Runnable(){

                public void run() {
                    JavaSourceTaskFactory.this.stateChangedImpl(currentFiles);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(List<FileObject> currentFiles) {
        HashMap<JavaSource, CancellableTask<CompilationInfo>> toRemove = new HashMap<JavaSource, CancellableTask<CompilationInfo>>();
        HashMap<JavaSource, CancellableTask<CompilationInfo>> toAdd = new HashMap<JavaSource, CancellableTask<CompilationInfo>>();
        JavaSourceTaskFactory javaSourceTaskFactory = this;
        synchronized (javaSourceTaskFactory) {
            ArrayList<FileObject> addedFiles = new ArrayList<FileObject>(currentFiles);
            ArrayList<FileObject> removedFiles = new ArrayList<FileObject>(this.file2Task.keySet());
            addedFiles.removeAll(this.file2Task.keySet());
            removedFiles.removeAll(currentFiles);
            for (FileObject r : removedFiles) {
                JavaSource source = this.file2JS.remove(r);
                if (source == null) continue;
                toRemove.put(source, this.file2Task.remove(r));
            }
            for (FileObject a : addedFiles) {
                JavaSource js;
                if (a == null || !a.isValid() || (js = JavaSource.forFileObject(a)) == null) continue;
                CancellableTask<CompilationInfo> task = this.createTask(a);
                toAdd.put(js, task);
                this.file2Task.put(a, task);
                this.file2JS.put(a, js);
            }
        }
        LOG.log(Level.FINEST, BEFORE_ADDING_REMOVING_TASKS);
        for (Map.Entry e : toRemove.entrySet()) {
            ACCESSOR2.removePhaseCompletionTask((JavaSource)e.getKey(), (CancellableTask)e.getValue());
        }
        for (Map.Entry e : toAdd.entrySet()) {
            try {
                ACCESSOR2.addPhaseCompletionTask((JavaSource)e.getKey(), (CancellableTask)e.getValue(), this.phase, this.priority);
            }
            catch (FileObjects.InvalidFileException ie) {
                LOG.info("JavaSource.addPhaseCompletionTask called on deleted file");
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    protected final synchronized void reschedule(FileObject file) throws IllegalArgumentException {
        JavaSource source = this.file2JS.get(file);
        if (source == null) {
            return;
        }
        CancellableTask<CompilationInfo> task = this.file2Task.get(file);
        if (task == null) {
            return;
        }
        ACCESSOR2.rescheduleTask(source, task);
    }

    static {
        JavaSourceTaskFactoryManager.ACCESSOR = new JavaSourceTaskFactoryManager.Accessor(){

            public void fireChangeEvent(JavaSourceTaskFactory f) {
                f.fileObjectsChanged();
            }
        };
        ACCESSOR2 = new Accessor2(){

            @Override
            public void addPhaseCompletionTask(JavaSource js, CancellableTask<CompilationInfo> task, JavaSource.Phase phase, JavaSource.Priority priority) throws IOException {
                js.addPhaseCompletionTask(task, phase, priority);
            }

            @Override
            public void removePhaseCompletionTask(JavaSource js, CancellableTask<CompilationInfo> task) {
                js.removePhaseCompletionTask(task);
            }

            @Override
            public void rescheduleTask(JavaSource js, CancellableTask<CompilationInfo> task) {
                js.rescheduleTask(task);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Accessor2 {
        public void addPhaseCompletionTask(JavaSource var1, CancellableTask<CompilationInfo> var2, JavaSource.Phase var3, JavaSource.Priority var4) throws IOException;

        public void removePhaseCompletionTask(JavaSource var1, CancellableTask<CompilationInfo> var2);

        public void rescheduleTask(JavaSource var1, CancellableTask<CompilationInfo> var2);
    }
}

