/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceUtils {
    private static final String PACKAGE_SUMMARY = "package-summary";
    private static EnumSet JAVA_JFO_KIND = EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);

    private SourceUtils() {
    }

    public static Tree treeFor(CompilationInfo info, Element element) {
        Element e;
        Context ctx = SourceUtils.getSourceContextFor(info.getClasspathInfo(), JavaSource.Phase.ELEMENTS_RESOLVED, element);
        if (ctx != null && (e = SourceUtils.getSourceElementFor(element, ctx)) != null) {
            return JavacElements.instance(ctx).getTree((Symbol)e);
        }
        return null;
    }

    public static TreePath pathFor(CompilationInfo info, Element element) {
        Element e;
        Context ctx = SourceUtils.getSourceContextFor(info.getClasspathInfo(), JavaSource.Phase.ELEMENTS_RESOLVED, element);
        if (ctx != null && (e = SourceUtils.getSourceElementFor(element, ctx)) != null) {
            return JavacTrees.instance(ctx).getPath(e);
        }
        return null;
    }

    public static Element getImplementationOf(CompilationInfo info, ExecutableElement method, TypeElement origin) {
        Context c = info.getJavacTask().getContext();
        return ((Symbol.MethodSymbol)method).implementation((Symbol.TypeSymbol)((Object)origin), Types.instance(c), true);
    }

    public static boolean checkTypesAssignable(CompilationInfo info, TypeMirror from, TypeMirror to) {
        Context c = info.getJavacTask().getContext();
        if (from.getKind() == TypeKind.DECLARED) {
            List<Type> typeVars = List.nil();
            for (TypeMirror typeMirror : ((DeclaredType)from).getTypeArguments()) {
                if (typeMirror.getKind() != TypeKind.TYPEVAR) continue;
                typeVars = typeVars.append((Type)typeMirror);
            }
            if (!typeVars.isEmpty()) {
                from = new Type.ForAll(typeVars, (Type)from);
            }
        } else if (from.getKind() == TypeKind.WILDCARD) {
            from = Types.instance(c).upperBound((Type)from);
        }
        return Check.instance(c).checkType(null, (Type)from, (Type)to).getKind() != TypeKind.ERROR;
    }

    public static TypeMirror getBound(WildcardType wildcardType) {
        Type.TypeVar bound = ((Type.WildcardType)wildcardType).bound;
        return bound != null ? bound.bound : null;
    }

    public static TypeElement getEnclosingTypeElement(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if (element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (!element.getEnclosingElement().getKind().isClass() && !element.getEnclosingElement().getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element.getEnclosingElement();
    }

    public static TypeElement getOutermostEnclosingTypeElement(Element element) {
        Element ec = SourceUtils.getEnclosingTypeElement(element);
        if (ec == null) {
            ec = element;
        }
        while (ec.getEnclosingElement().getKind().isClass() || ec.getEnclosingElement().getKind().isInterface()) {
            ec = ec.getEnclosingElement();
        }
        return (TypeElement)ec;
    }

    public static String resolveImport(final CompilationInfo info, TreePath context, final String fqn) throws NullPointerException, IOException {
        if (info == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        if (fqn == null) {
            throw new NullPointerException();
        }
        CompilationUnitTree cut = info.getCompilationUnit();
        Scope scope = info.getTrees().getScope(context);
        String qName = fqn;
        StringBuilder sqName = new StringBuilder();
        String sName = null;
        boolean clashing = false;
        ElementUtilities eu = info.getElementUtilities();
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror type) {
                return e.getKind().isClass() || e.getKind().isInterface();
            }
        };
        while (qName != null && qName.length() > 0) {
            int lastDot = qName.lastIndexOf(46);
            String simple = qName.substring(lastDot < 0 ? 0 : lastDot + 1);
            if (sName == null) {
                sName = simple;
            } else {
                sqName.insert(0, '.');
            }
            sqName.insert(0, simple);
            if (info.getElements().getTypeElement(qName) != null) {
                boolean matchFound = false;
                for (Element element : eu.getLocalMembersAndVars(scope, acceptor)) {
                    if (!simple.contentEquals(element.getSimpleName())) continue;
                    if (qName.contentEquals(((TypeElement)element).getQualifiedName())) {
                        return sqName.toString();
                    }
                    if (fqn == qName) {
                        clashing = true;
                    }
                    matchFound = true;
                    break;
                }
                if (!matchFound) {
                    for (TypeElement typeElement : eu.getGlobalTypes(acceptor)) {
                        if (!simple.contentEquals(typeElement.getSimpleName())) continue;
                        if (qName.contentEquals(typeElement.getQualifiedName())) {
                            return sqName.toString();
                        }
                        if (fqn != qName) break;
                        clashing = true;
                        break;
                    }
                }
            }
            qName = lastDot < 0 ? null : qName.substring(0, lastDot);
        }
        if (clashing) {
            return fqn;
        }
        if (info instanceof WorkingCopy) {
            CompilationUnitTree nue = (CompilationUnitTree)((WorkingCopy)info).getChangeSet().getChange(cut);
            cut = nue != null ? nue : cut;
            ((WorkingCopy)info).rewrite(info.getCompilationUnit(), SourceUtils.addImports(cut, Collections.singletonList(fqn), ((WorkingCopy)info).getTreeMaker()));
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        info.getJavaSource().runModificationTask(new CancellableTask<WorkingCopy>(){

                            @Override
                            public void cancel() {
                            }

                            @Override
                            public void run(WorkingCopy copy) throws Exception {
                                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                copy.rewrite(copy.getCompilationUnit(), SourceUtils.addImports(copy.getCompilationUnit(), Collections.singletonList(fqn), copy.getTreeMaker()));
                            }
                        }).commit();
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            });
        }
        TypeElement te = info.getElements().getTypeElement(fqn);
        if (te != null) {
            ((JCTree.JCCompilationUnit)info.getCompilationUnit()).namedImportScope.enterIfAbsent((Symbol)((Object)te));
        }
        return sName;
    }

    public static CompilationUnitTree addImports(CompilationUnitTree cut, java.util.List<String> toImport, TreeMaker make) throws IOException {
        toImport = new ArrayList<String>(toImport);
        Collections.sort(toImport);
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
        int currentToImport = toImport.size() - 1;
        int currentExisting = imports.size() - 1;
        while (currentToImport >= 0 && currentExisting >= 0) {
            String currentToImportText = toImport.get(currentToImport);
            while (currentExisting >= 0 && (((ImportTree)imports.get(currentExisting)).isStatic() || ((ImportTree)imports.get(currentExisting)).getQualifiedIdentifier().toString().compareTo(currentToImportText) > 0)) {
                --currentExisting;
            }
            if (currentExisting < 0) continue;
            imports.add(currentExisting + 1, make.Import(make.Identifier(currentToImportText), false));
            --currentToImport;
        }
        while (currentToImport >= 0) {
            String importText = toImport.get(currentToImport);
            imports.add(0, make.Import(make.Identifier(importText), false));
            --currentToImport;
        }
        return make.CompilationUnit(cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    public static FileObject getFile(Element element) {
        URI uri;
        if (element == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getFile");
        }
        Element prev = null;
        while (element.getKind() != ElementKind.PACKAGE) {
            prev = element;
            element = element.getEnclosingElement();
        }
        if (prev == null || !prev.getKind().isClass() && !prev.getKind().isInterface()) {
            return null;
        }
        Symbol.ClassSymbol clsSym = (Symbol.ClassSymbol)prev;
        if (clsSym.completer != null) {
            clsSym.complete();
        }
        if (clsSym.sourcefile != null && (uri = clsSym.sourcefile.toUri()) != null && uri.isAbsolute()) {
            try {
                return URLMapper.findFileObject((URL)uri.toURL());
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static FileObject getFile(Element element, ClasspathInfo cpInfo) {
        try {
            URI uri;
            if (element == null || cpInfo == null) {
                throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getFile");
            }
            Element prev = null;
            while (element.getKind() != ElementKind.PACKAGE) {
                prev = element;
                element = element.getEnclosingElement();
            }
            if (prev == null || !prev.getKind().isClass() && !prev.getKind().isInterface()) {
                return null;
            }
            Symbol.ClassSymbol clsSym = (Symbol.ClassSymbol)prev;
            if (clsSym.completer != null) {
                clsSym.complete();
            }
            if (clsSym.sourcefile != null && (uri = clsSym.sourcefile.toUri()) != null && uri.isAbsolute()) {
                return URLMapper.findFileObject((URL)uri.toURL());
            }
            if (clsSym.classfile == null) {
                return null;
            }
            uri = clsSym.classfile.toUri();
            if (uri == null || !uri.isAbsolute()) {
                return null;
            }
            FileObject classFo = URLMapper.findFileObject((URL)uri.toURL());
            if (classFo == null) {
                return null;
            }
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.OUTPUT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.COMPILE)});
            FileObject root = cp.findOwnerRoot(classFo);
            if (root == null) {
                return null;
            }
            String parentResName = cp.getResourceName(classFo.getParent(), '/', false);
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)root.getURL());
            FileObject[] sourceRoots = result.getRoots();
            ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
            java.util.List folders = sourcePath.findAllResources(parentResName);
            boolean caseSensitive = SourceUtils.isCaseSensitive();
            String sourceFileName = SourceUtils.getSourceFileName(classFo.getName());
            for (FileObject folder : folders) {
                FileObject[] children;
                for (FileObject child : children = folder.getChildren()) {
                    if ((!caseSensitive || !child.getName().equals(sourceFileName)) && (caseSensitive || !child.getName().equalsIgnoreCase(sourceFileName)) || !"java".equalsIgnoreCase(child.getExt())) continue;
                    return child;
                }
            }
        }
        catch (MalformedURLException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    public static FileObject getFile(ElementHandle<? extends Element> handle, ClasspathInfo cpInfo) {
        if (handle == null || cpInfo == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getFile");
        }
        try {
            String pkgName;
            boolean pkg = handle.getKind() == ElementKind.PACKAGE;
            String[] signature = handle.getSignature();
            assert (signature.length >= 1);
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.OUTPUT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.COMPILE)});
            String className = null;
            if (pkg) {
                pkgName = FileObjects.convertPackage2Folder(signature[0]);
            } else {
                int index = signature[0].lastIndexOf(46);
                if (index < 0) {
                    pkgName = "";
                    className = signature[0];
                } else {
                    pkgName = FileObjects.convertPackage2Folder(signature[0].substring(0, index));
                    className = signature[0].substring(index + 1);
                }
            }
            java.util.List fos = cp.findAllResources(pkgName);
            for (FileObject fo : fos) {
                FileObject root = cp.findOwnerRoot(fo);
                assert (root != null);
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)root.getURL()).getRoots();
                ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
                LinkedList<FileObject> folders = new LinkedList<FileObject>(sourcePath.findAllResources(pkgName));
                if (pkg) {
                    return folders.isEmpty() ? fo : (FileObject)folders.get(0);
                }
                boolean caseSensitive = SourceUtils.isCaseSensitive();
                String sourceFileName = SourceUtils.getSourceFileName(className);
                folders.addFirst(fo);
                for (FileObject folder : folders) {
                    FileObject[] children;
                    for (FileObject child : children = folder.getChildren()) {
                        if ((!caseSensitive || !child.getName().equals(sourceFileName)) && (caseSensitive || !child.getName().equalsIgnoreCase(sourceFileName)) || !child.isData() || !"java".equalsIgnoreCase(child.getExt())) continue;
                        return child;
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static URL getJavadoc(Element element, ClasspathInfo cpInfo) {
        String pageName;
        String pkgName;
        if (element == null || cpInfo == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getJavadoc");
        }
        Symbol.ClassSymbol clsSym = null;
        if (element.getKind() == ElementKind.PACKAGE) {
            java.util.List<? extends Element> els = element.getEnclosedElements();
            for (Element element2 : els) {
                if (!element2.getKind().isClass() && !element2.getKind().isInterface()) continue;
                clsSym = (Symbol.ClassSymbol)element2;
                break;
            }
            if (clsSym == null) {
                return null;
            }
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)element).getQualifiedName().toString());
            pageName = PACKAGE_SUMMARY;
        } else {
            Element prev = null;
            while (element.getKind() != ElementKind.PACKAGE) {
                prev = element;
                element = element.getEnclosingElement();
            }
            if (prev == null || !prev.getKind().isClass() && !prev.getKind().isInterface()) {
                return null;
            }
            clsSym = (Symbol.ClassSymbol)prev;
            pkgName = FileObjects.convertPackage2Folder(((Symbol)clsSym.getEnclosingElement()).getQualifiedName().toString());
            pageName = clsSym.getSimpleName().toString();
        }
        if (clsSym.completer != null) {
            clsSym.complete();
        }
        URL sourceRoot = null;
        HashSet<URL> binaries = new HashSet<URL>();
        try {
            FileObject fileObject;
            if (clsSym.classfile != null) {
                URL url;
                void var7_7;
                FileObject fileObject2 = URLMapper.findFileObject((URL)clsSym.classfile.toUri().toURL());
                StringTokenizer tk = new StringTokenizer(pkgName, "/");
                for (int i = 0; var7_7 != null && i <= tk.countTokens(); ++i) {
                    FileObject fileObject3 = var7_7.getParent();
                }
                if (var7_7 != null && (sourceRoot = Index.getSourceRootForClassFolder(url = var7_7.getURL())) == null) {
                    binaries.add(url);
                }
            }
            if (sourceRoot == null && binaries.isEmpty() && clsSym.sourcefile != null) {
                sourceRoot = clsSym.sourcefile.toUri().toURL();
            }
            if (sourceRoot != null && (fileObject = URLMapper.findFileObject(sourceRoot)) != null) {
                ClassPath exec = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
                ClassPath compile = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                ClassPath source = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (exec == null) {
                    exec = compile;
                    compile = null;
                }
                if (exec == null || source == null) {
                    return null;
                }
                HashSet<URL> roots = new HashSet<URL>();
                for (ClassPath.Entry e : exec.entries()) {
                    roots.add(e.getURL());
                }
                if (compile != null) {
                    for (ClassPath.Entry e : compile.entries()) {
                        roots.remove(e.getURL());
                    }
                }
                java.util.List<FileObject> sourceRoots = Arrays.asList(source.getRoots());
                block8: for (URL e : roots) {
                    FileObject[] res;
                    for (FileObject fo : res = SourceForBinaryQuery.findSourceRoots((URL)e).getRoots()) {
                        if (!sourceRoots.contains(fo)) continue;
                        binaries.add(e);
                        continue block8;
                    }
                }
            }
            for (URL binary : binaries) {
                URL[] result = JavadocForBinaryQuery.findJavadoc((URL)binary).getRoots();
                ClassPath cp = ClassPathSupport.createClassPath((URL[])result);
                FileObject fo = cp.findResource(pkgName);
                if (fo == null) continue;
                for (FileObject child : fo.getChildren()) {
                    if (!pageName.equals(child.getName()) || !"html".equalsIgnoreCase(child.getExt())) continue;
                    return child.getURL();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static boolean isScanInProgress() {
        return RepositoryUpdater.getDefault().isScanInProgress();
    }

    public static void waitScanFinished() throws InterruptedException {
        RepositoryUpdater.getDefault().waitScanFinished();
    }

    public static Set<URL> getDependentRoots(URL root) {
        Map<URL, java.util.List<URL>> deps = RepositoryUpdater.getDefault().getDependencies();
        return SourceUtils.getDependentRootsImpl(root, deps);
    }

    static Set<URL> getDependentRootsImpl(URL root, Map<URL, java.util.List<URL>> deps) {
        HashMap<URL, ArrayList<URL>> inverseDeps = new HashMap<URL, ArrayList<URL>>();
        for (Map.Entry<URL, java.util.List<URL>> entry : deps.entrySet()) {
            URL u1 = entry.getKey();
            java.util.List<URL> l1 = entry.getValue();
            for (URL u2 : l1) {
                ArrayList<URL> l2 = (ArrayList<URL>)inverseDeps.get(u2);
                if (l2 == null) {
                    l2 = new ArrayList<URL>();
                    inverseDeps.put(u2, l2);
                }
                l2.add(u1);
            }
        }
        HashSet<URL> result = new HashSet<URL>();
        LinkedList<URL> todo = new LinkedList<URL>();
        todo.add(root);
        while (!todo.isEmpty()) {
            URL u = (URL)todo.removeFirst();
            if (result.contains(u)) continue;
            result.add(u);
            java.util.List ideps = (java.util.List)inverseDeps.get(u);
            if (ideps == null) continue;
            todo.addAll(ideps);
        }
        Set cps = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        HashSet<URL> toRetain = new HashSet<URL>();
        for (ClassPath cp : cps) {
            for (ClassPath.Entry e : cp.entries()) {
                toRetain.add(e.getURL());
            }
        }
        result.retainAll(toRetain);
        return result;
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject fo) {
        if (fo == null || !fo.isValid() || fo.isVirtual()) {
            throw new IllegalArgumentException();
        }
        JavaSource js = JavaSource.forFileObject(fo);
        if (js == null) {
            throw new IllegalArgumentException();
        }
        try {
            final LinkedList<ElementHandle<TypeElement>> result = new LinkedList<ElementHandle<TypeElement>>();
            js.runUserActionTask(new CancellableTask<CompilationController>(){

                @Override
                public void run(final CompilationController control) throws Exception {
                    if (control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                        new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitMethod(MethodTree node, Void p) {
                                ExecutableElement method = (ExecutableElement)control.getTrees().getElement(this.getCurrentPath());
                                if (method != null && SourceUtils.isMainMethod(method) && this.isAccessible(method.getEnclosingElement())) {
                                    result.add(ElementHandle.create((TypeElement)method.getEnclosingElement()));
                                }
                                return null;
                            }
                        }.scan(control.getCompilationUnit(), null);
                    }
                }

                private boolean isAccessible(Element element) {
                    ElementKind kind = element.getKind();
                    while (kind != ElementKind.PACKAGE) {
                        if (!kind.isClass() && !kind.isInterface()) {
                            return false;
                        }
                        Set<Modifier> modifiers = ((TypeElement)element).getModifiers();
                        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                            return false;
                        }
                        Element parent = element.getEnclosingElement();
                        if (parent.getKind() != ElementKind.PACKAGE && !modifiers.contains((Object)Modifier.STATIC)) {
                            return false;
                        }
                        element = parent;
                        kind = element.getKind();
                    }
                    return true;
                }

                @Override
                public void cancel() {
                }
            }, true);
            return result;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return Collections.emptySet();
        }
    }

    public static boolean isMainClass(final String qualifiedName, ClasspathInfo cpInfo) {
        if (qualifiedName == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        final boolean[] result = new boolean[]{false};
        JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
        try {
            js.runUserActionTask(new CancellableTask<CompilationController>(){

                @Override
                public void run(CompilationController control) throws Exception {
                    TypeElement type = control.getElements().getTypeElement(qualifiedName);
                    if (type == null) {
                        return;
                    }
                    java.util.List<ExecutableElement> methods = ElementFilter.methodsIn(type.getEnclosedElements());
                    for (ExecutableElement method : methods) {
                        if (!SourceUtils.isMainMethod(method)) continue;
                        result[0] = true;
                        break;
                    }
                }

                @Override
                public void cancel() {
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }

    public static boolean isMainMethod(ExecutableElement method) {
        if (!"main".contentEquals(method.getSimpleName())) {
            return false;
        }
        long flags = ((Symbol.MethodSymbol)method).flags();
        if ((flags & 1L) == 0L || (flags & 8L) == 0L) {
            return false;
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            return false;
        }
        java.util.List<? extends VariableElement> params = method.getParameters();
        if (params.size() != 1) {
            return false;
        }
        TypeMirror param = params.get(0).asType();
        if (param.getKind() != TypeKind.ARRAY) {
            return false;
        }
        ArrayType array = (ArrayType)param;
        TypeMirror compound = array.getComponentType();
        if (compound.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return "java.lang.String".contentEquals(((TypeElement)((DeclaredType)compound).asElement()).getQualifiedName());
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject[] sourceRoots) {
        final LinkedList<ElementHandle<TypeElement>> result = new LinkedList<ElementHandle<TypeElement>>();
        for (FileObject root : sourceRoots) {
            try {
                ClassPath bootPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
                ClassPath compilePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
                ClassPath srcPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root});
                ClasspathInfo cpInfo = ClasspathInfo.create(bootPath, compilePath, srcPath);
                final Set<ElementHandle<TypeElement>> classes = cpInfo.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
                js.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void run(CompilationController control) throws Exception {
                        for (ElementHandle cls : classes) {
                            TypeElement te = (TypeElement)cls.resolve(control);
                            if (te == null) continue;
                            java.util.List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
                            for (ExecutableElement method : methods) {
                                if (!SourceUtils.isMainMethod(method)) continue;
                                result.add(cls);
                            }
                        }
                    }

                    @Override
                    public void cancel() {
                    }
                }, false);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return Collections.emptySet();
            }
        }
        return result;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static String getSourceFileName(String classFileName) {
        int index = classFileName.indexOf(36);
        return index == -1 ? classFileName : classFileName.substring(0, index);
    }

    private static ClassPath createClassPath(ClasspathInfo cpInfo, ClasspathInfo.PathKind kind) throws MalformedURLException {
        return ClasspathInfoAccessor.INSTANCE.getCachedClassPath(cpInfo, kind);
    }

    private static Context getSourceContextFor(ClasspathInfo cpInfo, final JavaSource.Phase phase, Element element) {
        try {
            JavaSource js;
            FileObject fo = SourceUtils.getFile(element, cpInfo);
            if (fo != null && (js = JavaSource.forFileObject(fo)) != null) {
                final Context[] ret = new Context[1];
                js.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(phase);
                        ret[0] = controller.getJavacTask().getContext();
                    }
                }, true);
                return ret[0];
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private static Element getSourceElementFor(Element element, Context ctx) {
        block10: {
            Symbol.ClassSymbol cls;
            Symbol owner;
            Name.Table nameTable;
            Symbol sym;
            block9: {
                sym = (Symbol)element;
                Symtab symbolTable = Symtab.instance(ctx);
                nameTable = Name.Table.instance((Context)ctx);
                owner = sym.owner;
                Symbol.ClassSymbol enclCls = sym.enclClass();
                Name name = nameTable.fromString(enclCls.flatname.toString());
                cls = (Symbol.ClassSymbol)((Object)symbolTable.classes.get(name));
                if (enclCls == sym) {
                    return cls;
                }
                if (cls == null || owner != enclCls) break block9;
                Scope.Entry e = cls.members().lookup(nameTable.fromString(sym.name.toString()));
                while (e.scope != null) {
                    if (e.sym.kind == sym.kind && (e.sym.flags_field & 0x1000L) == 0L && e.sym.type.toString().equals(sym.type.toString())) {
                        return e.sym;
                    }
                    e = e.next();
                }
                break block10;
            }
            if (cls == null || owner.kind != 16 || sym.kind != 4) break block10;
            Scope.Entry e = cls.members().lookup(nameTable.fromString(owner.name.toString()));
            Symbol newOwner = null;
            while (e.scope != null) {
                if (e.sym.kind == owner.kind && (e.sym.flags_field & 0x1000L) == 0L && e.sym.type.toString().equals(owner.type.toString())) {
                    newOwner = e.sym;
                    break;
                }
                e = e.next();
            }
            if (newOwner != null && newOwner.kind == 16) {
                int i = 0;
                List<Symbol.VarSymbol> l = ((Symbol.MethodSymbol)owner).params;
                while (l.nonEmpty()) {
                    ++i;
                    if (sym == l.head) break;
                    l = l.tail;
                }
                l = ((Symbol.MethodSymbol)newOwner).params;
                while (l.nonEmpty()) {
                    if (--i == 0) {
                        return (Element)l.head;
                    }
                    l = l.tail;
                }
            }
        }
        return null;
    }
}

